/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections;

import com.github.hypfvieh.util.TypeUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.freedesktop.dbus.exceptions.DBusException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusAddress {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AddressBusTypes type;
    private final Map<String, String> parameters = new HashMap<String, String>();
    private final String rawAddress;

    public BusAddress(String address) throws DBusException {
        String[] ps;
        if (null == address || "".equals(address)) {
            throw new DBusException("Bus address is blank");
        }
        this.logger.trace("Parsing bus address: {}", (Object)address);
        String[] ss = address.split(":", 2);
        if (ss.length < 2) {
            throw new DBusException("Bus address is invalid: " + address);
        }
        this.type = AddressBusTypes.toEnum(ss[0]);
        if (this.type == null) {
            throw new DBusException("Unsupported transport type: " + ss[0]);
        }
        this.logger.trace("Transport type: {}", (Object)this.type);
        this.rawAddress = address;
        for (String p : ps = ss[1].split(",")) {
            String[] kv = p.split("=", 2);
            this.parameters.put(kv[0], kv[1]);
        }
        this.logger.trace("Transport options: {}", (Object)this.parameters);
    }

    public String getType() {
        return this.type.getBusType();
    }

    public AddressBusTypes getBusType() {
        return this.type;
    }

    public boolean isAbstract() {
        return this.parameters.containsKey("abstract");
    }

    public boolean isListeningSocket() {
        return this.parameters.containsKey("listen");
    }

    public boolean hasPath() {
        return this.parameters.containsKey("path");
    }

    public boolean hasHost() {
        return this.parameters.containsKey("host");
    }

    public boolean hasPort() {
        return this.parameters.containsKey("port");
    }

    public boolean hasGuid() {
        return this.parameters.containsKey("guid");
    }

    public String getAbstract() {
        return this.parameters.get("abstract");
    }

    public String getPath() {
        return this.parameters.get("path");
    }

    public int getPort() {
        return TypeUtil.isValidNetworkPort(this.parameters.get("port"), true) ? Integer.valueOf(Integer.parseInt(this.parameters.get("port"))) : null;
    }

    public String getHost() {
        return this.parameters.get("host");
    }

    public String getGuid() {
        return this.parameters.get("guid");
    }

    public String toString() {
        return (Object)((Object)this.type) + ": " + this.parameters;
    }

    public String getRawAddress() {
        return this.rawAddress;
    }

    public boolean isServer() {
        return this.isListeningSocket();
    }

    public static enum AddressBusTypes {
        UNIX,
        TCP;


        public String getBusType() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public static AddressBusTypes toEnum(String _str) {
            for (AddressBusTypes itm : AddressBusTypes.values()) {
                if (!itm.getBusType().equals(_str.toLowerCase(Locale.ROOT))) continue;
                return itm;
            }
            return null;
        }
    }
}

