/*
 * Decompiled with CFR 0.152.
 */
package dataflow.cfg.block;

import dataflow.cfg.block.Block;
import dataflow.cfg.block.BlockImpl;
import dataflow.cfg.block.ExceptionBlock;
import dataflow.cfg.block.SingleSuccessorBlockImpl;
import dataflow.cfg.node.Node;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.type.TypeMirror;

public class ExceptionBlockImpl
extends SingleSuccessorBlockImpl
implements ExceptionBlock {
    protected Map<TypeMirror, Set<Block>> exceptionalSuccessors;
    protected Node node;

    public ExceptionBlockImpl() {
        this.type = Block.BlockType.EXCEPTION_BLOCK;
        this.exceptionalSuccessors = new HashMap<TypeMirror, Set<Block>>();
    }

    public void setNode(Node c) {
        this.node = c;
        c.setBlock(this);
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    public void addExceptionalSuccessor(BlockImpl b, TypeMirror cause) {
        Set<Block> blocks;
        if (this.exceptionalSuccessors == null) {
            this.exceptionalSuccessors = new HashMap<TypeMirror, Set<Block>>();
        }
        if ((blocks = this.exceptionalSuccessors.get(cause)) == null) {
            blocks = new HashSet<Block>();
            this.exceptionalSuccessors.put(cause, blocks);
        }
        blocks.add(b);
        b.addPredecessor(this);
    }

    @Override
    public Map<TypeMirror, Set<Block>> getExceptionalSuccessors() {
        if (this.exceptionalSuccessors == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.exceptionalSuccessors);
    }

    public String toString() {
        return "ExceptionBlock(" + this.node + ")";
    }
}

