/*
 * Decompiled with CFR 0.152.
 */
package com.welie.blessed;

import com.welie.blessed.BluetoothBytesParser;
import com.welie.blessed.BluetoothCentralManager;
import com.welie.blessed.BluetoothCommandStatus;
import com.welie.blessed.BluetoothGattCharacteristic;
import com.welie.blessed.BluetoothGattDescriptor;
import com.welie.blessed.BluetoothGattService;
import com.welie.blessed.BluetoothPeripheralCallback;
import com.welie.blessed.BluezSignalHandler;
import com.welie.blessed.BondState;
import com.welie.blessed.ConnectionState;
import com.welie.blessed.Handler;
import com.welie.blessed.bluez.BluezDevice;
import com.welie.blessed.bluez.BluezGattCharacteristic;
import com.welie.blessed.bluez.BluezGattDescriptor;
import com.welie.blessed.bluez.BluezGattService;
import com.welie.blessed.internal.GattCallback;
import com.welie.blessed.internal.InternalCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledFuture;
import org.bluez.exceptions.BluezAlreadyConnectedException;
import org.bluez.exceptions.BluezAlreadyExistsException;
import org.bluez.exceptions.BluezAuthenticationCanceledException;
import org.bluez.exceptions.BluezAuthenticationFailedException;
import org.bluez.exceptions.BluezAuthenticationRejectedException;
import org.bluez.exceptions.BluezAuthenticationTimeoutException;
import org.bluez.exceptions.BluezConnectionAttemptFailedException;
import org.bluez.exceptions.BluezFailedException;
import org.bluez.exceptions.BluezInProgressException;
import org.bluez.exceptions.BluezInvalidArgumentsException;
import org.bluez.exceptions.BluezInvalidOffsetException;
import org.bluez.exceptions.BluezInvalidValueLengthException;
import org.bluez.exceptions.BluezNotAuthorizedException;
import org.bluez.exceptions.BluezNotPermittedException;
import org.bluez.exceptions.BluezNotReadyException;
import org.bluez.exceptions.BluezNotSupportedException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.handlers.AbstractPropertiesChangedHandler;
import org.freedesktop.dbus.interfaces.Properties;
import org.freedesktop.dbus.types.DBusListType;
import org.freedesktop.dbus.types.Variant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BluetoothPeripheral {
    private static final String TAG = BluetoothPeripheral.class.getSimpleName();
    private final Logger logger = LoggerFactory.getLogger(TAG);
    private static final String ERROR_NATIVE_CHARACTERISTIC_IS_NULL = "ERROR: Native characteristic is null";
    private static final String NO_VALID_SERVICE_UUID_PROVIDED = "no valid service UUID provided";
    private static final String NO_VALID_CHARACTERISTIC_UUID_PROVIDED = "no valid characteristic UUID provided";
    private static final String NO_VALID_CHARACTERISTIC_PROVIDED = "no valid characteristic provided";
    private static final String NO_VALID_WRITE_TYPE_PROVIDED = "no valid writeType provided";
    private static final String NO_VALID_VALUE_PROVIDED = "no valid value provided";
    @NotNull
    private final BluetoothCentralManager central;
    @Nullable
    private BluezDevice device;
    @NotNull
    private String deviceName;
    @NotNull
    private final String deviceAddress;
    @Nullable
    private byte[] currentWriteBytes;
    @NotNull
    private final Handler callBackHandler;
    @NotNull
    private final InternalCallback listener;
    @NotNull
    private BluetoothPeripheralCallback peripheralCallback = new BluetoothPeripheralCallback.NULL();
    @NotNull
    protected final Map<String, BluezGattService> serviceMap = new ConcurrentHashMap<String, BluezGattService>();
    @NotNull
    protected final Map<String, BluezGattCharacteristic> characteristicMap = new ConcurrentHashMap<String, BluezGattCharacteristic>();
    @NotNull
    protected final Map<String, BluezGattDescriptor> descriptorMap = new ConcurrentHashMap<String, BluezGattDescriptor>();
    @NotNull
    protected @NotNull List<@NotNull BluetoothGattService> services = new ArrayList<BluetoothGattService>();
    @Nullable
    private ScheduledFuture<?> timeoutFuture;
    @NotNull
    private final Queue<Runnable> commandQueue = new ConcurrentLinkedQueue<Runnable>();
    @Nullable
    private Handler queueHandler;
    @Nullable
    private Handler signalHandler;
    @NotNull
    private final Set<BluetoothGattCharacteristic> notifyingCharacteristics = new HashSet<BluetoothGattCharacteristic>();
    private volatile boolean commandQueueBusy = false;
    private int nrTries;
    private boolean isBonded = false;
    private boolean manualBonding = false;
    private volatile boolean bondingInProgress = false;
    private long connectTimestamp;
    private boolean isRetrying;
    private volatile ConnectionState state = ConnectionState.DISCONNECTED;
    private volatile boolean serviceDiscoveryCompleted = false;
    private static final int MAX_TRIES = 2;
    private static final int SERVICE_DISCOVERY_TIMEOUT_IN_MS = 10000;
    static final String BLUEZ_CHARACTERISTIC_INTERFACE = "org.bluez.GattCharacteristic1";
    static final String BLUEZ_DEVICE_INTERFACE = "org.bluez.Device1";
    static final String PROPERTY_NOTIFYING = "Notifying";
    static final String PROPERTY_VALUE = "Value";
    static final String PROPERTY_SERVICES_RESOLVED = "ServicesResolved";
    static final String PROPERTY_CONNECTED = "Connected";
    static final String PROPERTY_PAIRED = "Paired";
    static final String PROPERTY_SERVICE_UUIDS = "UUIDs";
    static final String PROPERTY_NAME = "Name";
    static final String PROPERTY_ADDRESS = "Address";
    static final String PROPERTY_RSSI = "RSSI";
    static final String PROPERTY_MANUFACTURER_DATA = "ManufacturerData";
    static final String PROPERTY_SERVICE_DATA = "ServiceData";
    final GattCallback gattCallback = new GattCallback(){

        @Override
        public void onConnectionStateChanged(@NotNull ConnectionState connectionState, @NotNull BluetoothCommandStatus status) {
            ConnectionState previousState = BluetoothPeripheral.this.state;
            BluetoothPeripheral.this.state = connectionState;
            if (status == BluetoothCommandStatus.COMMAND_SUCCESS) {
                switch (connectionState) {
                    case CONNECTED: {
                        this.successfullyConnected();
                        break;
                    }
                    case DISCONNECTED: {
                        this.successfullyDisconnected(status, previousState);
                        break;
                    }
                    case CONNECTING: {
                        BluetoothPeripheral.this.logger.info("peripheral is connecting");
                        break;
                    }
                    case DISCONNECTING: {
                        BluetoothPeripheral.this.logger.info("peripheral is disconnecting");
                        break;
                    }
                    default: {
                        BluetoothPeripheral.this.logger.error("unhandled connection state");
                        break;
                    }
                }
            } else {
                this.connectionStateChangeUnsuccessful(status, previousState, connectionState);
            }
        }

        private void successfullyConnected() {
            long timePassed = System.currentTimeMillis() - BluetoothPeripheral.this.connectTimestamp;
            BluetoothPeripheral.this.isBonded = BluetoothPeripheral.this.isPaired();
            BluetoothPeripheral.this.logger.info(String.format("connected to '%s' (%s) in %.1fs", BluetoothPeripheral.this.deviceName, BluetoothPeripheral.this.isBonded ? "BONDED" : "BOND_NONE", Float.valueOf((float)timePassed / 1000.0f)));
        }

        private void successfullyDisconnected(@NotNull BluetoothCommandStatus status, @NotNull ConnectionState previousState) {
            if (!BluetoothPeripheral.this.serviceDiscoveryCompleted) {
                BluetoothPeripheral.this.listener.serviceDiscoveryFailed(BluetoothPeripheral.this);
            }
            this.completeDisconnect(true, status);
        }

        void connectionStateChangeUnsuccessful(@NotNull BluetoothCommandStatus status, @NotNull ConnectionState previousState, @NotNull ConnectionState newState) {
            if (previousState == ConnectionState.CONNECTING) {
                this.completeDisconnect(false, status);
                BluetoothPeripheral.this.logger.error(String.format("connection failed with status '%s'", new Object[]{status}));
                BluetoothPeripheral.this.listener.connectFailed(BluetoothPeripheral.this, status);
            } else if (previousState == ConnectionState.CONNECTED && newState == ConnectionState.DISCONNECTED && !BluetoothPeripheral.this.serviceDiscoveryCompleted) {
                this.completeDisconnect(false, status);
                BluetoothPeripheral.this.logger.error(String.format("connection failed with status '%s' during service discovery", new Object[]{status}));
                BluetoothPeripheral.this.listener.connectFailed(BluetoothPeripheral.this, status);
            } else {
                if (newState == ConnectionState.DISCONNECTED) {
                    BluetoothPeripheral.this.logger.error(String.format("disconnected with status '%s'", new Object[]{status}));
                }
                this.completeDisconnect(true, status);
            }
        }

        @Override
        public void onNotificationStateUpdate(@NotNull BluetoothGattCharacteristic characteristic, @NotNull BluetoothCommandStatus status) {
            if (status != BluetoothCommandStatus.COMMAND_SUCCESS) {
                BluetoothPeripheral.this.logger.error(String.format("set notify failed with status '%s'", new Object[]{status}));
            }
            BluetoothPeripheral.this.callBackHandler.post(() -> BluetoothPeripheral.this.peripheralCallback.onNotificationStateUpdate(BluetoothPeripheral.this, characteristic, status));
            BluetoothPeripheral.this.completedCommand();
        }

        @Override
        public void onDescriptorWrite(@NotNull BluetoothGattDescriptor descriptor, @NotNull BluetoothCommandStatus status) {
            BluetoothGattCharacteristic parentCharacteristic = descriptor.getCharacteristic();
            if (status != BluetoothCommandStatus.COMMAND_SUCCESS) {
                BluetoothPeripheral.this.logger.info(String.format("ERROR: Write descriptor failed device: %s, characteristic: %s", BluetoothPeripheral.this.getAddress(), parentCharacteristic.getUuid()));
            }
            BluetoothPeripheral.this.callBackHandler.post(() -> BluetoothPeripheral.this.peripheralCallback.onDescriptorWrite(BluetoothPeripheral.this, new byte[0], descriptor, status));
            BluetoothPeripheral.this.completedCommand();
        }

        @Override
        public void onCharacteristicRead(@NotNull BluetoothGattCharacteristic characteristic, @NotNull BluetoothCommandStatus status) {
            if (status != BluetoothCommandStatus.COMMAND_SUCCESS) {
                BluetoothPeripheral.this.logger.error(String.format(Locale.ENGLISH, "read failed for characteristic: %s, status '%s'", new Object[]{characteristic.getUuid(), status}));
                BluetoothPeripheral.this.callBackHandler.post(() -> BluetoothPeripheral.this.peripheralCallback.onCharacteristicUpdate(BluetoothPeripheral.this, new byte[0], characteristic, status));
            }
            BluetoothPeripheral.this.completedCommand();
        }

        @Override
        public void onCharacteristicChanged(@NotNull byte[] value, @NotNull BluetoothGattCharacteristic characteristic) {
            BluetoothPeripheral.this.callBackHandler.post(() -> BluetoothPeripheral.this.peripheralCallback.onCharacteristicUpdate(BluetoothPeripheral.this, value, characteristic, BluetoothCommandStatus.COMMAND_SUCCESS));
        }

        @Override
        public void onCharacteristicWrite(@NotNull BluetoothGattCharacteristic characteristic, @NotNull BluetoothCommandStatus status) {
            if (status != BluetoothCommandStatus.COMMAND_SUCCESS) {
                BluetoothPeripheral.this.logger.error(String.format("write failed for characteristic: %s, status '%s'", new Object[]{characteristic.getUuid(), status}));
            }
            BluetoothPeripheral.this.callBackHandler.post(() -> BluetoothPeripheral.this.peripheralCallback.onCharacteristicWrite(BluetoothPeripheral.this, BluetoothPeripheral.this.currentWriteBytes, characteristic, status));
            BluetoothPeripheral.this.completedCommand();
        }

        @Override
        public void onPairingStarted() {
            BluetoothPeripheral.this.logger.info("bonding started");
            BluetoothPeripheral.this.bondingInProgress = true;
            BluetoothPeripheral.this.callBackHandler.post(() -> BluetoothPeripheral.this.peripheralCallback.onBondingStarted(BluetoothPeripheral.this));
        }

        @Override
        public void onPaired() {
            BluetoothPeripheral.this.logger.info("bonding succeeded");
            BluetoothPeripheral.this.callBackHandler.post(() -> BluetoothPeripheral.this.peripheralCallback.onBondingSucceeded(BluetoothPeripheral.this));
        }

        @Override
        public void onPairingFailed() {
            BluetoothPeripheral.this.logger.info("bonding failed");
            BluetoothPeripheral.this.callBackHandler.post(() -> BluetoothPeripheral.this.peripheralCallback.onBondingFailed(BluetoothPeripheral.this));
        }

        @Override
        public void onServicesDiscovered(@NotNull List<BluetoothGattService> services) {
            BluetoothPeripheral.this.serviceDiscoveryCompleted = true;
            BluetoothPeripheral.this.logger.info(String.format("discovered %d services for '%s' (%s)", services.size(), BluetoothPeripheral.this.getName(), BluetoothPeripheral.this.getAddress()));
            BluetoothPeripheral.this.listener.connected(BluetoothPeripheral.this);
            BluetoothPeripheral.this.callBackHandler.post(() -> BluetoothPeripheral.this.peripheralCallback.onServicesDiscovered(BluetoothPeripheral.this, services));
            BluetoothPeripheral.this.listener.servicesDiscovered(BluetoothPeripheral.this);
        }

        private void completeDisconnect(boolean notify, @NotNull BluetoothCommandStatus status) {
            BluetoothPeripheral.this.commandQueue.clear();
            BluetoothPeripheral.this.commandQueueBusy = false;
            BluetoothPeripheral.this.queueHandler.shutdown();
            BluetoothPeripheral.this.queueHandler = null;
            BluetoothPeripheral.this.signalHandler.shutdown();
            BluetoothPeripheral.this.signalHandler = null;
            if (notify) {
                BluetoothPeripheral.this.listener.disconnected(BluetoothPeripheral.this, status);
            }
            BluezSignalHandler.getInstance().removePeripheral(BluetoothPeripheral.this.deviceAddress);
        }
    };
    private final AbstractPropertiesChangedHandler propertiesChangedHandler = new AbstractPropertiesChangedHandler(){

        @Override
        public void handle(@NotNull Properties.PropertiesChanged propertiesChanged) {
            switch (propertiesChanged.getInterfaceName()) {
                case "org.bluez.GattCharacteristic1": {
                    BluetoothGattCharacteristic bluetoothGattCharacteristic = BluetoothPeripheral.this.getCharacteristicFromPath(propertiesChanged.getPath());
                    if (bluetoothGattCharacteristic == null) {
                        return;
                    }
                    propertiesChanged.getPropertiesChanged().forEach((key, value) -> this.handlePropertyChangedForCharacteristic(bluetoothGattCharacteristic, (String)key, (Variant<?>)value));
                    break;
                }
                case "org.bluez.Device1": {
                    propertiesChanged.getPropertiesChanged().forEach((key, value) -> this.handlePropertyChangeForDevice((String)key, (Variant<?>)value));
                    break;
                }
            }
        }

        private void handlePropertyChangedForCharacteristic(@NotNull BluetoothGattCharacteristic bluetoothGattCharacteristic, @NotNull String propertyName, @NotNull Variant<?> value) {
            switch (propertyName) {
                case "Notifying": {
                    boolean isNotifying = (Boolean)value.getValue();
                    if (isNotifying) {
                        BluetoothPeripheral.this.notifyingCharacteristics.add(bluetoothGattCharacteristic);
                    } else {
                        BluetoothPeripheral.this.notifyingCharacteristics.remove(bluetoothGattCharacteristic);
                    }
                    BluetoothPeripheral.this.logger.info(String.format("characteristic '%s' %s", bluetoothGattCharacteristic.getUuid(), isNotifying ? "is notifying" : "stopped notifying"));
                    BluetoothPeripheral.this.gattCallback.onNotificationStateUpdate(bluetoothGattCharacteristic, BluetoothCommandStatus.COMMAND_SUCCESS);
                    break;
                }
                case "Value": {
                    byte[] byteArray;
                    if (!(value.getType() instanceof DBusListType) || !(value.getValue() instanceof byte[]) || (byteArray = (byte[])value.getValue()) == null) break;
                    BluetoothPeripheral.this.gattCallback.onCharacteristicChanged(byteArray, bluetoothGattCharacteristic);
                    break;
                }
                default: {
                    BluetoothPeripheral.this.logger.error(String.format("Unhandled characteristic property change %s", propertyName));
                }
            }
        }

        private void handlePropertyChangeForDevice(@NotNull String propertyName, @NotNull Variant<?> value) {
            switch (propertyName) {
                case "ServicesResolved": {
                    BluetoothPeripheral.this.cancelServiceDiscoveryTimer();
                    if (value.getValue().equals(true)) {
                        BluetoothPeripheral.this.logger.info("service discovery completed");
                        if (BluetoothPeripheral.this.manualBonding || BluetoothPeripheral.this.bondingInProgress) break;
                        BluetoothPeripheral.this.servicesResolved();
                        break;
                    }
                    BluetoothPeripheral.this.logger.debug(String.format("servicesResolved is false (%s)", BluetoothPeripheral.this.deviceName));
                    break;
                }
                case "Connected": {
                    if (value.getValue().equals(true)) {
                        BluetoothPeripheral.this.gattCallback.onConnectionStateChanged(ConnectionState.CONNECTED, BluetoothCommandStatus.COMMAND_SUCCESS);
                        BluetoothPeripheral.this.startServiceDiscoveryTimer();
                        break;
                    }
                    BluetoothPeripheral.this.logger.info(String.format("disconnected '%s' (%s)", BluetoothPeripheral.this.deviceName, BluetoothPeripheral.this.deviceAddress));
                    BluetoothPeripheral.this.cancelServiceDiscoveryTimer();
                    if (BluetoothPeripheral.this.state == ConnectionState.DISCONNECTING) {
                        BluetoothPeripheral.this.gattCallback.onConnectionStateChanged(ConnectionState.DISCONNECTED, BluetoothCommandStatus.COMMAND_SUCCESS);
                        break;
                    }
                    BluetoothPeripheral.this.gattCallback.onConnectionStateChanged(ConnectionState.DISCONNECTED, BluetoothCommandStatus.REMOTE_USER_TERMINATED_CONNECTION);
                    break;
                }
                case "Paired": {
                    if (value.getValue().equals(true)) {
                        BluetoothPeripheral.this.isBonded = true;
                        BluetoothPeripheral.this.gattCallback.onPaired();
                        if (!BluetoothPeripheral.this.manualBonding && !BluetoothPeripheral.this.bondingInProgress) break;
                        BluetoothPeripheral.this.servicesResolved();
                        BluetoothPeripheral.this.manualBonding = false;
                        BluetoothPeripheral.this.bondingInProgress = false;
                        break;
                    }
                    BluetoothPeripheral.this.gattCallback.onPairingFailed();
                    break;
                }
            }
        }
    };

    public BluetoothPeripheral(@NotNull BluetoothCentralManager central, @Nullable BluezDevice bluezDevice, @Nullable String deviceName, @NotNull String deviceAddress, @NotNull InternalCallback listener, @Nullable BluetoothPeripheralCallback peripheralCallback, @NotNull Handler callBackHandler) {
        this.central = Objects.requireNonNull(central, "no valid central provided");
        this.device = bluezDevice;
        this.deviceName = deviceName == null ? "" : deviceName;
        this.deviceAddress = Objects.requireNonNull(deviceAddress, "no valid address provided");
        this.listener = Objects.requireNonNull(listener, "no valid listener provided");
        if (peripheralCallback != null) {
            this.peripheralCallback = peripheralCallback;
        }
        this.callBackHandler = Objects.requireNonNull(callBackHandler, "no callbackhandler provided");
    }

    void setPeripheralCallback(@NotNull BluetoothPeripheralCallback peripheralCallback) {
        this.peripheralCallback = Objects.requireNonNull(peripheralCallback, "no valid peripheral callback provided");
    }

    public void connect() {
        Objects.requireNonNull(this.device, "device is null");
        this.gattCallback.onConnectionStateChanged(ConnectionState.CONNECTING, BluetoothCommandStatus.COMMAND_SUCCESS);
        try {
            this.logger.info(String.format("connecting to '%s' (%s)", this.deviceName, this.deviceAddress));
            this.queueHandler = new Handler(this.deviceAddress + "-queue");
            this.signalHandler = new Handler(this.deviceAddress + "-signal");
            BluezSignalHandler.getInstance().addPeripheral(this.deviceAddress, this);
            this.connectTimestamp = System.currentTimeMillis();
            this.device.connect();
        }
        catch (DBusExecutionException e) {
            this.logger.error(e.getMessage());
            if (this.state != ConnectionState.CONNECTED) {
                this.gattCallback.onConnectionStateChanged(ConnectionState.DISCONNECTED, BluetoothCommandStatus.DBUS_EXECUTION_EXCEPTION);
            }
        }
        catch (BluezAlreadyConnectedException e) {
            this.logger.error("connect exception: already connected");
            this.gattCallback.onConnectionStateChanged(ConnectionState.CONNECTED, BluetoothCommandStatus.CONNECTION_ALREADY_EXISTS);
            this.serviceDiscoveryCompleted = true;
            this.listener.connected(this);
        }
        catch (BluezNotReadyException e) {
            this.logger.error("connect exception: not ready");
            this.logger.error(e.getMessage());
            this.gattCallback.onConnectionStateChanged(ConnectionState.DISCONNECTED, BluetoothCommandStatus.BLUEZ_NOT_READY);
        }
        catch (BluezFailedException e) {
            this.logger.error("connect exception: connect failed");
            this.logger.error(e.getMessage());
            this.gattCallback.onConnectionStateChanged(ConnectionState.DISCONNECTED, BluetoothCommandStatus.CONNECTION_FAILED_ESTABLISHMENT);
        }
        catch (BluezInProgressException e) {
            this.logger.error("connect exception: in progress");
            this.logger.error(e.getMessage());
            this.gattCallback.onConnectionStateChanged(ConnectionState.DISCONNECTED, BluetoothCommandStatus.BLUEZ_OPERATION_IN_PROGRESS);
        }
    }

    public void cancelConnection() {
        this.central.cancelConnection(this);
    }

    void disconnectBluezDevice() {
        this.logger.info(String.format("force disconnect '%s' (%s)", this.getName(), this.getAddress()));
        this.gattCallback.onConnectionStateChanged(ConnectionState.DISCONNECTING, BluetoothCommandStatus.COMMAND_SUCCESS);
        if (this.device != null) {
            this.device.disconnect();
        }
    }

    public boolean readCharacteristic(@NotNull UUID serviceUUID, @NotNull UUID characteristicUUID) {
        Objects.requireNonNull(serviceUUID, NO_VALID_SERVICE_UUID_PROVIDED);
        Objects.requireNonNull(characteristicUUID, NO_VALID_CHARACTERISTIC_PROVIDED);
        BluetoothGattCharacteristic characteristic = this.getCharacteristic(serviceUUID, characteristicUUID);
        if (characteristic != null) {
            return this.readCharacteristic(characteristic);
        }
        return false;
    }

    public boolean readCharacteristic(@NotNull BluetoothGattCharacteristic characteristic) {
        Objects.requireNonNull(characteristic, "characteristic is 'null', ignoring read request");
        if (this.state != ConnectionState.CONNECTED) {
            this.gattCallback.onCharacteristicRead(characteristic, BluetoothCommandStatus.NOT_CONNECTED);
            return false;
        }
        if (!characteristic.supportsReading()) {
            return false;
        }
        BluezGattCharacteristic nativeCharacteristic = this.getBluezGattCharacteristic(characteristic.service.getUuid(), characteristic.getUuid());
        if (nativeCharacteristic == null) {
            this.logger.error(ERROR_NATIVE_CHARACTERISTIC_IS_NULL);
            return false;
        }
        boolean result = this.commandQueue.add(() -> {
            if (this.state == ConnectionState.CONNECTED) {
                try {
                    this.logger.info(String.format("reading characteristic <%s>", nativeCharacteristic.getUuid()));
                    nativeCharacteristic.readValue(new HashMap<String, Object>());
                    this.gattCallback.onCharacteristicRead(characteristic, BluetoothCommandStatus.COMMAND_SUCCESS);
                }
                catch (BluezInProgressException e) {
                    this.gattCallback.onCharacteristicRead(characteristic, BluetoothCommandStatus.BLUEZ_OPERATION_IN_PROGRESS);
                }
                catch (BluezInvalidOffsetException e) {
                    this.gattCallback.onCharacteristicRead(characteristic, BluetoothCommandStatus.INVALID_OFFSET);
                }
                catch (BluezFailedException e) {
                    this.gattCallback.onCharacteristicRead(characteristic, BluetoothCommandStatus.BLUEZ_OPERATION_FAILED);
                }
                catch (BluezNotPermittedException e) {
                    this.gattCallback.onCharacteristicRead(characteristic, BluetoothCommandStatus.READ_NOT_PERMITTED);
                }
                catch (BluezNotAuthorizedException e) {
                    this.gattCallback.onCharacteristicRead(characteristic, BluetoothCommandStatus.INSUFFICIENT_AUTHENTICATION);
                }
                catch (BluezNotSupportedException e) {
                    this.gattCallback.onCharacteristicRead(characteristic, BluetoothCommandStatus.REQUEST_NOT_SUPPORTED);
                }
                catch (DBusExecutionException e) {
                    this.gattCallback.onCharacteristicRead(characteristic, BluetoothCommandStatus.DBUS_EXECUTION_EXCEPTION);
                    this.logger.error(e.toString());
                }
                catch (Exception e) {
                    this.gattCallback.onCharacteristicRead(characteristic, BluetoothCommandStatus.BLUEZ_OPERATION_FAILED);
                    this.logger.error(e.toString());
                }
            }
        });
        if (result) {
            this.nextCommand();
        } else {
            this.logger.error("ERROR: Could not enqueue read characteristic command");
        }
        return result;
    }

    public boolean writeCharacteristic(@NotNull UUID serviceUUID, @NotNull UUID characteristicUUID, @NotNull byte[] value, @NotNull BluetoothGattCharacteristic.WriteType writeType) {
        Objects.requireNonNull(serviceUUID, NO_VALID_SERVICE_UUID_PROVIDED);
        Objects.requireNonNull(characteristicUUID, NO_VALID_CHARACTERISTIC_UUID_PROVIDED);
        Objects.requireNonNull(value, NO_VALID_VALUE_PROVIDED);
        Objects.requireNonNull(writeType, NO_VALID_WRITE_TYPE_PROVIDED);
        BluetoothGattCharacteristic characteristic = this.getCharacteristic(serviceUUID, characteristicUUID);
        if (characteristic != null) {
            return this.writeCharacteristic(characteristic, value, writeType);
        }
        return false;
    }

    public boolean writeCharacteristic(@NotNull BluetoothGattCharacteristic characteristic, @NotNull byte[] value, @NotNull BluetoothGattCharacteristic.WriteType writeType) {
        Objects.requireNonNull(characteristic, NO_VALID_CHARACTERISTIC_PROVIDED);
        Objects.requireNonNull(value, NO_VALID_VALUE_PROVIDED);
        Objects.requireNonNull(writeType, NO_VALID_WRITE_TYPE_PROVIDED);
        if (this.state != ConnectionState.CONNECTED) {
            return false;
        }
        byte[] bytesToWrite = this.copyOf(value);
        if (bytesToWrite.length == 0) {
            this.logger.error("value byte array is empty, ignoring write request");
            return false;
        }
        BluezGattCharacteristic nativeCharacteristic = this.getBluezGattCharacteristic(characteristic.service.getUuid(), characteristic.getUuid());
        if (nativeCharacteristic == null) {
            this.logger.error(ERROR_NATIVE_CHARACTERISTIC_IS_NULL);
            return false;
        }
        if (!characteristic.supportsWriteType(writeType)) {
            this.logger.error(String.format(Locale.ENGLISH, "characteristic cannot be written with this writeType : %s", new Object[]{writeType}));
            return false;
        }
        boolean result = this.commandQueue.add(() -> {
            if (this.state == ConnectionState.CONNECTED) {
                try {
                    this.currentWriteBytes = bytesToWrite;
                    this.logger.info(String.format("writing %s <%s> to characteristic <%s>", new Object[]{writeType, BluetoothBytesParser.bytes2String(bytesToWrite), nativeCharacteristic.getUuid()}));
                    HashMap<String, Object> options = new HashMap<String, Object>();
                    options.put("type", writeType == BluetoothGattCharacteristic.WriteType.WITH_RESPONSE ? "request" : "command");
                    nativeCharacteristic.writeValue(bytesToWrite, options);
                    this.gattCallback.onCharacteristicWrite(characteristic, BluetoothCommandStatus.COMMAND_SUCCESS);
                }
                catch (BluezInProgressException e) {
                    this.gattCallback.onCharacteristicWrite(characteristic, BluetoothCommandStatus.BLUEZ_OPERATION_IN_PROGRESS);
                }
                catch (BluezNotPermittedException e) {
                    this.gattCallback.onCharacteristicWrite(characteristic, BluetoothCommandStatus.WRITE_NOT_PERMITTED);
                }
                catch (BluezNotAuthorizedException e) {
                    this.gattCallback.onCharacteristicWrite(characteristic, BluetoothCommandStatus.INSUFFICIENT_AUTHORIZATION);
                }
                catch (DBusExecutionException e) {
                    this.gattCallback.onCharacteristicWrite(characteristic, BluetoothCommandStatus.DBUS_EXECUTION_EXCEPTION);
                }
                catch (BluezNotSupportedException e) {
                    this.gattCallback.onCharacteristicWrite(characteristic, BluetoothCommandStatus.REQUEST_NOT_SUPPORTED);
                }
                catch (BluezFailedException e) {
                    this.gattCallback.onCharacteristicWrite(characteristic, BluetoothCommandStatus.BLUEZ_OPERATION_FAILED);
                }
                catch (BluezInvalidValueLengthException e) {
                    this.gattCallback.onCharacteristicWrite(characteristic, BluetoothCommandStatus.INVALID_ATTRIBUTE_VALUE_LENGTH);
                }
                catch (Exception e) {
                    this.gattCallback.onCharacteristicWrite(characteristic, BluetoothCommandStatus.BLUEZ_OPERATION_FAILED);
                    this.logger.error(e.getMessage());
                }
            }
        });
        if (result) {
            this.nextCommand();
        } else {
            this.logger.error("ERROR: Could not enqueue write characteristic command");
        }
        return result;
    }

    public boolean setNotify(@NotNull UUID serviceUUID, @NotNull UUID characteristicUUID, boolean enable) {
        Objects.requireNonNull(serviceUUID, NO_VALID_SERVICE_UUID_PROVIDED);
        Objects.requireNonNull(characteristicUUID, NO_VALID_CHARACTERISTIC_PROVIDED);
        BluetoothGattCharacteristic characteristic = this.getCharacteristic(serviceUUID, characteristicUUID);
        if (characteristic != null) {
            return this.setNotify(characteristic, enable);
        }
        return false;
    }

    public boolean setNotify(@NotNull BluetoothGattCharacteristic characteristic, boolean enable) {
        Objects.requireNonNull(characteristic, NO_VALID_CHARACTERISTIC_PROVIDED);
        if (this.state != ConnectionState.CONNECTED) {
            this.gattCallback.onNotificationStateUpdate(characteristic, BluetoothCommandStatus.NOT_CONNECTED);
            return false;
        }
        BluezGattCharacteristic nativeCharacteristic = this.getBluezGattCharacteristic(characteristic.service.getUuid(), characteristic.getUuid());
        if (nativeCharacteristic == null) {
            this.logger.error(ERROR_NATIVE_CHARACTERISTIC_IS_NULL);
            return false;
        }
        if (!characteristic.supportsNotifying()) {
            this.logger.info(String.format("characteristic %s does not have notify of indicate property", characteristic.getUuid()));
            return false;
        }
        boolean result = this.commandQueue.add(() -> {
            if (this.state == ConnectionState.CONNECTED) {
                try {
                    if (enable) {
                        this.logger.info(String.format("setNotify for characteristic <%s>", nativeCharacteristic.getUuid()));
                        boolean isNotifying = nativeCharacteristic.isNotifying();
                        if (isNotifying) {
                            this.logger.info("already notifying");
                            this.notifyingCharacteristics.add(characteristic);
                            this.gattCallback.onNotificationStateUpdate(characteristic, BluetoothCommandStatus.COMMAND_SUCCESS);
                        } else {
                            nativeCharacteristic.startNotify();
                        }
                    } else {
                        this.logger.info(String.format("stopNotify for characteristic <%s>", nativeCharacteristic.getUuid()));
                        nativeCharacteristic.stopNotify();
                    }
                }
                catch (BluezNotPermittedException e) {
                    this.gattCallback.onNotificationStateUpdate(characteristic, BluetoothCommandStatus.WRITE_NOT_PERMITTED);
                }
                catch (BluezFailedException e) {
                    this.gattCallback.onNotificationStateUpdate(characteristic, BluetoothCommandStatus.BLUEZ_OPERATION_FAILED);
                }
                catch (BluezInProgressException e) {
                    this.gattCallback.onNotificationStateUpdate(characteristic, BluetoothCommandStatus.BLUEZ_OPERATION_IN_PROGRESS);
                }
                catch (BluezNotSupportedException e) {
                    this.gattCallback.onNotificationStateUpdate(characteristic, BluetoothCommandStatus.REQUEST_NOT_SUPPORTED);
                }
                catch (Exception e) {
                    this.gattCallback.onNotificationStateUpdate(characteristic, BluetoothCommandStatus.BLUEZ_OPERATION_FAILED);
                    this.logger.error(e.getMessage());
                }
            }
        });
        if (result) {
            this.nextCommand();
        } else {
            this.logger.error("ERROR: Could not enqueue set notify characteristic command");
        }
        return result;
    }

    public void readRemoteRssi() {
        try {
            this.logger.info(String.format("reading rssi for '%s'", this.deviceName));
            Short rssi = Objects.requireNonNull(this.device).getRssi();
            if (rssi != null) {
                this.callBackHandler.post(() -> this.peripheralCallback.onReadRemoteRssi(this, rssi.shortValue(), BluetoothCommandStatus.COMMAND_SUCCESS));
            }
            this.completedCommand();
        }
        catch (DBusExecutionException e) {
            if (e.getMessage().equalsIgnoreCase("No such property 'RSSI'")) {
                this.logger.error("rssi not available when not scanning");
            }
            this.logger.error(String.format("reading rssi failed: %s", e.getMessage()));
        }
    }

    private void servicesResolved() {
        if (this.state != ConnectionState.CONNECTED) {
            this.logger.error("Services resolved but not connected");
            return;
        }
        if (this.device != null) {
            this.clearMaps();
            List<BluezGattService> gattServices = this.device.getGattServices();
            gattServices.forEach(service -> this.services.add(this.mapBluezGattServiceToBluetoothGattService((BluezGattService)service)));
            this.gattCallback.onServicesDiscovered(Collections.unmodifiableList(this.services));
        }
    }

    private void clearMaps() {
        this.services.clear();
        this.serviceMap.clear();
        this.characteristicMap.clear();
        this.descriptorMap.clear();
    }

    void handleSignal(@NotNull Properties.PropertiesChanged propertiesChanged) {
        if (this.signalHandler != null) {
            this.signalHandler.post(() -> this.propertiesChangedHandler.handle(propertiesChanged));
        }
    }

    private void completedCommand() {
        this.isRetrying = false;
        this.commandQueue.poll();
        this.commandQueueBusy = false;
        this.nextCommand();
    }

    private void retryCommand() {
        this.commandQueueBusy = false;
        Runnable currentCommand = this.commandQueue.peek();
        if (currentCommand != null) {
            if (this.nrTries >= 2) {
                this.logger.warn("max number of tries reached, not retrying operation anymore ");
                this.commandQueue.poll();
            } else {
                this.isRetrying = true;
            }
        }
        this.nextCommand();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextCommand() {
        BluetoothPeripheral bluetoothPeripheral = this;
        synchronized (bluetoothPeripheral) {
            if (this.state != ConnectionState.CONNECTED) {
                this.logger.info(String.format("device %s is not connected, clearing command queue", this.getAddress()));
                this.commandQueue.clear();
                this.commandQueueBusy = false;
                return;
            }
            if (this.commandQueueBusy) {
                return;
            }
            Runnable bluetoothCommand = this.commandQueue.peek();
            if (bluetoothCommand != null) {
                this.commandQueueBusy = true;
                if (!this.isRetrying) {
                    this.nrTries = 0;
                }
                if (this.queueHandler != null) {
                    this.queueHandler.post(() -> {
                        try {
                            bluetoothCommand.run();
                        }
                        catch (Exception ex) {
                            this.logger.warn(String.format("ERROR: Command exception for device '%s'", this.getName()));
                            ex.printStackTrace();
                            this.completedCommand();
                        }
                    });
                }
            }
        }
    }

    @Nullable
    private BluezGattCharacteristic getBluezGattCharacteristic(@NotNull UUID serviceUUID, @NotNull UUID characteristicUUID) {
        Objects.requireNonNull(serviceUUID, NO_VALID_SERVICE_UUID_PROVIDED);
        Objects.requireNonNull(characteristicUUID, NO_VALID_CHARACTERISTIC_UUID_PROVIDED);
        BluezGattCharacteristic characteristic = null;
        for (BluezGattCharacteristic gattCharacteristic : this.characteristicMap.values()) {
            if (!characteristicUUID.equals(gattCharacteristic.getUuid()) || !gattCharacteristic.getService().getUuid().equals(serviceUUID)) continue;
            characteristic = gattCharacteristic;
        }
        return characteristic;
    }

    @Nullable
    private BluetoothGattCharacteristic getBluetoothGattCharacteristic(@NotNull BluezGattCharacteristic bluezGattCharacteristic) {
        Objects.requireNonNull(bluezGattCharacteristic, NO_VALID_CHARACTERISTIC_PROVIDED);
        UUID characteristicUUID = bluezGattCharacteristic.getUuid();
        UUID serviceUUID = bluezGattCharacteristic.getService().getUuid();
        return this.getCharacteristic(serviceUUID, characteristicUUID);
    }

    @NotNull
    public List<BluetoothGattService> getServices() {
        return Collections.unmodifiableList(this.services);
    }

    @Nullable
    public BluetoothGattService getService(@NotNull UUID serviceUUID) {
        Objects.requireNonNull(serviceUUID, NO_VALID_SERVICE_UUID_PROVIDED);
        for (BluetoothGattService service : this.services) {
            if (!service.getUuid().equals(serviceUUID)) continue;
            return service;
        }
        return null;
    }

    @Nullable
    public BluetoothGattCharacteristic getCharacteristic(@NotNull UUID serviceUUID, @NotNull UUID characteristicUUID) {
        Objects.requireNonNull(serviceUUID, NO_VALID_SERVICE_UUID_PROVIDED);
        Objects.requireNonNull(characteristicUUID, NO_VALID_CHARACTERISTIC_PROVIDED);
        BluetoothGattService service = this.getService(serviceUUID);
        if (service != null) {
            return service.getCharacteristic(characteristicUUID);
        }
        return null;
    }

    @NotNull
    public String getName() {
        return this.deviceName;
    }

    void setName(@Nullable String name) {
        this.deviceName = name == null ? "" : name;
    }

    @NotNull
    public String getAddress() {
        return this.deviceAddress;
    }

    @NotNull
    public ConnectionState getState() {
        return this.state;
    }

    boolean isPaired() {
        boolean result = this.isBonded;
        try {
            result = this.isBonded = this.device.isPaired().booleanValue();
        }
        catch (Exception e) {
            this.logger.error(e.toString());
        }
        return result;
    }

    @NotNull
    public BondState getBondState() {
        if (this.isPaired()) {
            return BondState.BONDED;
        }
        return BondState.NONE;
    }

    public boolean isNotifying(@NotNull BluetoothGattCharacteristic characteristic) {
        Objects.requireNonNull(characteristic, NO_VALID_CHARACTERISTIC_PROVIDED);
        BluezGattCharacteristic nativeCharacteristic = this.getBluezGattCharacteristic(characteristic.service.getUuid(), characteristic.getUuid());
        if (nativeCharacteristic == null) {
            this.logger.error(ERROR_NATIVE_CHARACTERISTIC_IS_NULL);
            return false;
        }
        return nativeCharacteristic.isNotifying();
    }

    @NotNull
    public Set<BluetoothGattCharacteristic> getNotifyingCharacteristics() {
        return Collections.unmodifiableSet(this.notifyingCharacteristics);
    }

    public boolean createBond(@NotNull BluetoothPeripheralCallback peripheralCallback) {
        BluetoothCommandStatus status;
        Objects.requireNonNull(peripheralCallback, "peripheral callback not valid");
        Objects.requireNonNull(this.device, "device is null");
        this.setPeripheralCallback(peripheralCallback);
        boolean result = false;
        try {
            if (this.state == ConnectionState.DISCONNECTED) {
                BluezSignalHandler.getInstance().addPeripheral(this.deviceAddress, this);
                this.queueHandler = new Handler(this.deviceAddress + "-queue");
            }
            if (this.device.isPaired().booleanValue()) {
                this.logger.error("device already bonded, connecting instead");
                this.connect();
            } else {
                this.manualBonding = true;
                this.logger.info(String.format("pairing with '%s' (%s)", this.deviceName, this.deviceAddress));
                this.connectTimestamp = System.currentTimeMillis();
                this.device.pair();
            }
            return true;
        }
        catch (BluezInvalidArgumentsException e) {
            this.logger.error("Pair exception: invalid argument");
            status = BluetoothCommandStatus.INVALID_COMMAND_PARAMETERS;
        }
        catch (BluezFailedException e) {
            this.logger.error("Pair exception: failed");
            status = BluetoothCommandStatus.BLUEZ_OPERATION_FAILED;
        }
        catch (BluezAuthenticationFailedException e) {
            this.logger.error("Pair exception: authentication failed");
            status = BluetoothCommandStatus.AUTHENTICATION_FAILURE;
        }
        catch (BluezAlreadyExistsException e) {
            this.logger.error("Pair exception: already exists");
            status = BluetoothCommandStatus.CONNECTION_ALREADY_EXISTS;
        }
        catch (BluezAuthenticationCanceledException e) {
            this.logger.error("Pair exception: authentication canceled");
            status = BluetoothCommandStatus.CONNECTION_REJECTED_SECURITY_REASONS;
        }
        catch (BluezAuthenticationRejectedException e) {
            this.logger.error("Pair exception: authentication rejected");
            status = BluetoothCommandStatus.CONNECTION_REJECTED_SECURITY_REASONS;
        }
        catch (BluezAuthenticationTimeoutException e) {
            this.logger.error("Pair exception: authentication timeout");
            status = BluetoothCommandStatus.CONNECTION_REJECTED_SECURITY_REASONS;
        }
        catch (BluezConnectionAttemptFailedException e) {
            this.logger.error("Pair exception: connection attempt failed");
            status = BluetoothCommandStatus.CONNECTION_FAILED_ESTABLISHMENT;
        }
        catch (DBusExecutionException e) {
            status = BluetoothCommandStatus.DBUS_EXECUTION_EXCEPTION;
            if (e.getMessage().equalsIgnoreCase("No reply within specified time")) {
                this.logger.error("Pairing timeout");
            } else {
                this.logger.error(e.getMessage());
            }
        }
        catch (BluezInProgressException e) {
            status = BluetoothCommandStatus.BLUEZ_OPERATION_IN_PROGRESS;
            e.printStackTrace();
        }
        if (this.device.isConnected().booleanValue()) {
            this.device.disconnect();
        } else {
            this.gattCallback.onConnectionStateChanged(ConnectionState.DISCONNECTED, status);
        }
        return result;
    }

    @Nullable
    private BluetoothGattCharacteristic getCharacteristicFromPath(@NotNull String path) {
        Objects.requireNonNull(path, "no valid path provided");
        BluezGattCharacteristic characteristic = this.characteristicMap.get(path);
        if (characteristic == null) {
            return null;
        }
        BluetoothGattCharacteristic bluetoothGattCharacteristic = this.getBluetoothGattCharacteristic(characteristic);
        if (bluetoothGattCharacteristic == null) {
            this.logger.error(String.format("can't find characteristic with path %s", path));
        }
        return bluetoothGattCharacteristic;
    }

    private void startServiceDiscoveryTimer() {
        this.cancelServiceDiscoveryTimer();
        Runnable timeoutRunnable = () -> {
            String deviceName = this.device != null ? this.device.getName() : this.deviceAddress;
            this.logger.error(String.format("Service Discovery timeout, disconnecting '%s'", deviceName));
            this.cancelServiceDiscoveryTimer();
            this.gattCallback.onConnectionStateChanged(ConnectionState.DISCONNECTED, BluetoothCommandStatus.CONNECTION_FAILED_ESTABLISHMENT);
        };
        if (this.queueHandler != null) {
            this.timeoutFuture = this.queueHandler.postDelayed(timeoutRunnable, 10000L);
        }
    }

    private void cancelServiceDiscoveryTimer() {
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(false);
            this.timeoutFuture = null;
        }
    }

    private BluetoothGattDescriptor mapBluezGattDescriptorToHBDescriptor(BluezGattDescriptor descriptor) {
        return new BluetoothGattDescriptor(descriptor.getUuid(), 0);
    }

    private int mapFlagsToProperty(@NotNull List<String> flags) {
        Objects.requireNonNull(flags, "flags list not valid");
        int result = 0;
        if (flags.contains("read")) {
            result += 2;
        }
        if (flags.contains("write-without-response")) {
            result += 4;
        }
        if (flags.contains("write")) {
            result += 8;
        }
        if (flags.contains("notify")) {
            result += 16;
        }
        if (flags.contains("indicate")) {
            result += 32;
        }
        if (flags.contains("authenticated-signed-writes")) {
            result += 64;
        }
        return result;
    }

    private BluetoothGattCharacteristic mapBluezGattCharacteristicToBluetoothGattCharacteristic(BluezGattCharacteristic bluezGattCharacteristic) {
        int properties = this.mapFlagsToProperty(bluezGattCharacteristic.getFlags());
        BluetoothGattCharacteristic bluetoothGattCharacteristic = new BluetoothGattCharacteristic(bluezGattCharacteristic.getUuid(), properties);
        List<BluezGattDescriptor> descriptors = bluezGattCharacteristic.getGattDescriptors();
        descriptors.forEach(descriptor -> {
            this.descriptorMap.put(descriptor.getDbusPath(), (BluezGattDescriptor)descriptor);
            bluetoothGattCharacteristic.addDescriptor(this.mapBluezGattDescriptorToHBDescriptor((BluezGattDescriptor)descriptor));
        });
        return bluetoothGattCharacteristic;
    }

    private BluetoothGattService mapBluezGattServiceToBluetoothGattService(@NotNull BluezGattService service) {
        this.serviceMap.put(service.getDbusPath(), service);
        BluetoothGattService bluetoothGattService = new BluetoothGattService(service.getUuid());
        bluetoothGattService.setPeripheral(this);
        List<BluezGattCharacteristic> characteristics = service.getGattCharacteristics();
        characteristics.forEach(bluetoothGattCharacteristic -> {
            this.characteristicMap.put(bluetoothGattCharacteristic.getDbusPath(), (BluezGattCharacteristic)bluetoothGattCharacteristic);
            BluetoothGattCharacteristic characteristic = this.mapBluezGattCharacteristicToBluetoothGattCharacteristic((BluezGattCharacteristic)bluetoothGattCharacteristic);
            characteristic.setService(bluetoothGattService);
            bluetoothGattService.addCharacteristic(characteristic);
        });
        return bluetoothGattService;
    }

    @NotNull
    private byte[] copyOf(@Nullable byte[] source) {
        return source == null ? new byte[]{} : Arrays.copyOf(source, source.length);
    }

    @Nullable
    public BluezDevice getDevice() {
        return this.device;
    }

    public void setDevice(@NotNull BluezDevice device) {
        this.device = Objects.requireNonNull(device, "no valid device supplied");
    }
}

