/*
 * Decompiled with CFR 0.152.
 */
package checkers.flow;

import checkers.types.AnnotatedTypeMirror;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Pair;
import java.util.Map;
import java.util.Set;
import javacutils.trees.TreeBuilder;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.AnnotationValueVisitor;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;

public class CFTreeBuilder
extends TreeBuilder {
    public CFTreeBuilder(ProcessingEnvironment env) {
        super(env);
    }

    public Tree buildAnnotatedType(AnnotatedTypeMirror annotatedType) {
        return this.AnnotatedType(annotatedType);
    }

    private Tree AnnotatedType(AnnotatedTypeMirror annotatedType) {
        JCTree.JCExpression underlyingTypeTree;
        Set<AnnotationMirror> annotations = annotatedType.getAnnotations();
        List<JCTree.JCAnnotation> annotationTrees = List.nil();
        for (AnnotationMirror am : annotations) {
            if (AnnotatedTypeMirror.isUnqualified(am)) continue;
            Attribute.TypeCompound typeCompound = this.attributeFromAnnotationMirror(am);
            JCTree.JCAnnotation annotationTree = this.maker.Annotation(typeCompound);
            JCTree.JCAnnotation typeAnnotationTree = this.maker.TypeAnnotation(annotationTree.getAnnotationType(), (List<JCTree.JCExpression>)annotationTree.getArguments());
            typeAnnotationTree.attribute = typeCompound;
            annotationTrees = annotationTrees.append(typeAnnotationTree);
        }
        switch (annotatedType.getKind()) {
            case BYTE: {
                underlyingTypeTree = this.maker.TypeIdent(TypeTag.BYTE);
                break;
            }
            case CHAR: {
                underlyingTypeTree = this.maker.TypeIdent(TypeTag.BYTE);
                break;
            }
            case SHORT: {
                underlyingTypeTree = this.maker.TypeIdent(TypeTag.SHORT);
                break;
            }
            case INT: {
                underlyingTypeTree = this.maker.TypeIdent(TypeTag.INT);
                break;
            }
            case LONG: {
                underlyingTypeTree = this.maker.TypeIdent(TypeTag.LONG);
                break;
            }
            case FLOAT: {
                underlyingTypeTree = this.maker.TypeIdent(TypeTag.FLOAT);
                break;
            }
            case DOUBLE: {
                underlyingTypeTree = this.maker.TypeIdent(TypeTag.DOUBLE);
                break;
            }
            case BOOLEAN: {
                underlyingTypeTree = this.maker.TypeIdent(TypeTag.BOOLEAN);
                break;
            }
            case VOID: {
                underlyingTypeTree = this.maker.TypeIdent(TypeTag.VOID);
                break;
            }
            case TYPEVAR: {
                AnnotatedTypeMirror.AnnotatedTypeVariable variable = (AnnotatedTypeMirror.AnnotatedTypeVariable)annotatedType;
                TypeVariable underlyingTypeVar = variable.getUnderlyingType();
                underlyingTypeTree = this.maker.Ident((Symbol.TypeSymbol)underlyingTypeVar.asElement());
                break;
            }
            case WILDCARD: {
                AnnotatedTypeMirror.AnnotatedWildcardType wildcard = (AnnotatedTypeMirror.AnnotatedWildcardType)annotatedType;
                if (wildcard.getExtendsBound() != null) {
                    Tree annotatedExtendsBound = this.AnnotatedType(wildcard.getExtendsBound());
                    underlyingTypeTree = this.maker.Wildcard(this.maker.TypeBoundKind(BoundKind.EXTENDS), (JCTree)annotatedExtendsBound);
                    break;
                }
                if (wildcard.getSuperBound() != null) {
                    Tree annotatedSuperBound = this.AnnotatedType(wildcard.getSuperBound());
                    underlyingTypeTree = this.maker.Wildcard(this.maker.TypeBoundKind(BoundKind.SUPER), (JCTree)annotatedSuperBound);
                    break;
                }
                underlyingTypeTree = this.maker.Wildcard(this.maker.TypeBoundKind(BoundKind.UNBOUND), this.maker.TypeIdent(TypeTag.VOID));
                break;
            }
            case DECLARED: {
                underlyingTypeTree = this.maker.Type((Type)annotatedType.getUnderlyingType());
                if (!(underlyingTypeTree instanceof JCTree.JCTypeApply)) break;
                AnnotatedTypeMirror.AnnotatedDeclaredType annotatedDeclaredType = (AnnotatedTypeMirror.AnnotatedDeclaredType)annotatedType;
                List<JCTree.JCExpression> typeArgTrees = List.nil();
                for (AnnotatedTypeMirror arg : annotatedDeclaredType.getTypeArguments()) {
                    typeArgTrees = typeArgTrees.append((JCTree.JCExpression)this.AnnotatedType(arg));
                }
                JCTree.JCExpression clazz = (JCTree.JCExpression)((JCTree.JCTypeApply)underlyingTypeTree).getType();
                underlyingTypeTree = this.maker.TypeApply(clazz, typeArgTrees);
                break;
            }
            case ARRAY: {
                AnnotatedTypeMirror.AnnotatedArrayType annotatedArrayType = (AnnotatedTypeMirror.AnnotatedArrayType)annotatedType;
                Tree annotatedComponentTree = this.AnnotatedType(annotatedArrayType.getComponentType());
                underlyingTypeTree = this.maker.TypeArray((JCTree.JCExpression)annotatedComponentTree);
                break;
            }
            case ERROR: {
                underlyingTypeTree = this.maker.TypeIdent(TypeTag.ERROR);
                break;
            }
            default: {
                assert (false) : "unexpected type: " + annotatedType;
                underlyingTypeTree = null;
            }
        }
        ((JCTree)underlyingTypeTree).setType((Type)annotatedType.getUnderlyingType());
        if (annotationTrees.isEmpty()) {
            return underlyingTypeTree;
        }
        JCTree.JCAnnotatedType annotatedTypeTree = this.maker.AnnotatedType(annotationTrees, underlyingTypeTree);
        annotatedTypeTree.setType((Type)annotatedType.getUnderlyingType());
        return annotatedTypeTree;
    }

    private Attribute.TypeCompound attributeFromAnnotationMirror(AnnotationMirror am) {
        List<Pair<Symbol.MethodSymbol, Attribute>> values = List.nil();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : am.getElementValues().entrySet()) {
            Attribute attribute = this.attributeFromAnnotationValue(entry.getValue());
            values = values.append(new Pair<Symbol.MethodSymbol, Attribute>((Symbol.MethodSymbol)entry.getKey(), attribute));
        }
        Attribute.Compound compound = new Attribute.Compound((Type.ClassType)am.getAnnotationType(), values);
        return new Attribute.TypeCompound(compound, new TypeAnnotationPosition());
    }

    private Attribute attributeFromAnnotationValue(AnnotationValue av) {
        return av.accept(new AttributeCreator(), null);
    }

    class AttributeCreator
    implements AnnotationValueVisitor<Attribute, Void> {
        AttributeCreator() {
        }

        @Override
        public Attribute visit(AnnotationValue av, Void p) {
            return av.accept(this, p);
        }

        @Override
        public Attribute visit(AnnotationValue av) {
            return this.visit(av, null);
        }

        @Override
        public Attribute visitBoolean(boolean b, Void p) {
            PrimitiveType booleanType = CFTreeBuilder.this.modelTypes.getPrimitiveType(TypeKind.BOOLEAN);
            return new Attribute.Constant((Type)((Object)booleanType), b);
        }

        @Override
        public Attribute visitByte(byte b, Void p) {
            PrimitiveType byteType = CFTreeBuilder.this.modelTypes.getPrimitiveType(TypeKind.BYTE);
            return new Attribute.Constant((Type)((Object)byteType), b);
        }

        @Override
        public Attribute visitChar(char c, Void p) {
            PrimitiveType charType = CFTreeBuilder.this.modelTypes.getPrimitiveType(TypeKind.CHAR);
            return new Attribute.Constant((Type)((Object)charType), Character.valueOf(c));
        }

        @Override
        public Attribute visitDouble(double d, Void p) {
            PrimitiveType doubleType = CFTreeBuilder.this.modelTypes.getPrimitiveType(TypeKind.DOUBLE);
            return new Attribute.Constant((Type)((Object)doubleType), d);
        }

        @Override
        public Attribute visitFloat(float f, Void p) {
            PrimitiveType floatType = CFTreeBuilder.this.modelTypes.getPrimitiveType(TypeKind.FLOAT);
            return new Attribute.Constant((Type)((Object)floatType), Float.valueOf(f));
        }

        @Override
        public Attribute visitInt(int i, Void p) {
            PrimitiveType intType = CFTreeBuilder.this.modelTypes.getPrimitiveType(TypeKind.INT);
            return new Attribute.Constant((Type)((Object)intType), i);
        }

        @Override
        public Attribute visitLong(long i, Void p) {
            PrimitiveType longType = CFTreeBuilder.this.modelTypes.getPrimitiveType(TypeKind.LONG);
            return new Attribute.Constant((Type)((Object)longType), i);
        }

        @Override
        public Attribute visitShort(short s2, Void p) {
            PrimitiveType shortType = CFTreeBuilder.this.modelTypes.getPrimitiveType(TypeKind.SHORT);
            return new Attribute.Constant((Type)((Object)shortType), s2);
        }

        @Override
        public Attribute visitString(String s2, Void p) {
            TypeMirror stringType = CFTreeBuilder.this.elements.getTypeElement("java.lang.String").asType();
            return new Attribute.Constant((Type)stringType, s2);
        }

        @Override
        public Attribute visitType(TypeMirror t, Void p) {
            if (t instanceof Type) {
                return new Attribute.Class(CFTreeBuilder.this.javacTypes, (Type)t);
            }
            assert (false) : "Unexpected type of TypeMirror: " + t.getClass();
            return null;
        }

        @Override
        public Attribute visitEnumConstant(VariableElement c, Void p) {
            Symbol.VarSymbol sym;
            if (c instanceof Symbol.VarSymbol && (sym = (Symbol.VarSymbol)c).getKind() == ElementKind.ENUM_CONSTANT) {
                return new Attribute.Enum(sym.type, sym);
            }
            assert (false) : "Unexpected type of VariableElement: " + c.getClass();
            return null;
        }

        @Override
        public Attribute visitAnnotation(AnnotationMirror a, Void p) {
            return CFTreeBuilder.this.attributeFromAnnotationMirror(a);
        }

        @Override
        public Attribute visitArray(java.util.List<? extends AnnotationValue> vals, Void p) {
            List<Attribute> valAttrs = List.nil();
            for (AnnotationValue annotationValue : vals) {
                valAttrs = valAttrs.append(annotationValue.accept(this, p));
            }
            ArrayType arrayType = CFTreeBuilder.this.modelTypes.getArrayType(((Attribute)valAttrs.get((int)0)).type);
            return new Attribute.Array((Type)((Object)arrayType), valAttrs);
        }

        @Override
        public Attribute visitUnknown(AnnotationValue av, Void p) {
            assert (false) : "Unexpected type of AnnotationValue: " + av.getClass();
            return null;
        }
    }
}

