/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.iconeditor;

import com.github.weisj.darklaf.LafManager;
import com.github.weisj.darklaf.components.CloseButton;
import com.github.weisj.darklaf.components.ComponentHelper;
import com.github.weisj.darklaf.components.DynamicUI;
import com.github.weisj.darklaf.components.OverlayScrollPane;
import com.github.weisj.darklaf.components.border.DarkBorders;
import com.github.weisj.darklaf.components.button.JSplitButton;
import com.github.weisj.darklaf.components.iconeditor.IconEditorPanel;
import com.github.weisj.darklaf.components.renderer.SimpleListCellRenderer;
import com.github.weisj.darklaf.icons.CustomThemedIcon;
import com.github.weisj.darklaf.icons.DarkSVGIcon;
import com.github.weisj.darklaf.icons.DerivableIcon;
import com.github.weisj.darklaf.icons.ThemedIcon;
import com.github.weisj.darklaf.icons.ThemedSVGIcon;
import com.github.weisj.darklaf.layout.HorizontalLayout;
import com.github.weisj.darklaf.layout.LayoutHelper;
import com.github.weisj.darklaf.theme.Theme;
import com.github.weisj.darklaf.util.Actions;
import com.github.weisj.darklaf.util.Alignment;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.Pair;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class IconEditor
extends JPanel {
    private final Map<IconEditorPanel, JButton> editors = new HashMap<IconEditorPanel, JButton>();
    private final Map<Theme, Action> newEditorActions = new HashMap<Theme, Action>();
    private final Map<Theme, IconEditorPanel> editorMap = new HashMap<Theme, IconEditorPanel>();
    private final JComponent editorPanel;
    private final JComponent plusComp;
    private Icon selectedIcon;
    private boolean showEditorAddRemoveControls = true;

    public IconEditor(List<Pair<String, ? extends Icon>> icons) {
        this(icons, 100);
    }

    public IconEditor(List<Pair<String, ? extends Icon>> icons, int displayIconSize) {
        this.setLayout(new BorderLayout());
        this.editorPanel = Box.createHorizontalBox();
        JComboBox<Object> iconCombo = new JComboBox<Object>();
        iconCombo.setMaximumSize(iconCombo.getPreferredSize());
        List themedIcons = icons.stream().filter(p -> p.getSecond() instanceof ThemedIcon).map(p -> new Pair((Object)((String)p.getFirst()), (Object)((ThemedIcon)p.getSecond()))).collect(Collectors.toList());
        DefaultComboBoxModel model = new DefaultComboBoxModel(new Vector(themedIcons));
        iconCombo.setModel(model);
        iconCombo.setRenderer(SimpleListCellRenderer.create((c, p) -> {
            c.setText((String)p.getFirst());
            c.setIcon((Icon)p.getSecond());
        }));
        iconCombo.addItemListener(e -> {
            Pair pair = (Pair)model.getElementAt(iconCombo.getSelectedIndex());
            if (pair == null) {
                return;
            }
            ThemedIcon icon = (ThemedIcon)((Pair)model.getElementAt(iconCombo.getSelectedIndex())).getSecond();
            if (icon instanceof DerivableIcon) {
                icon = (ThemedIcon)((DerivableIcon)icon).derive(displayIconSize, displayIconSize);
            }
            this.selectedIcon = icon;
            ThemedIcon finalIcon = icon;
            this.editors.forEach((ed, cb) -> ed.setIcon((Icon)finalIcon));
        });
        iconCombo.setSelectedIndex(-1);
        Box north = Box.createHorizontalBox();
        north.setBorder(DarkBorders.createBottomBorderWithSpacing());
        north.add(Box.createHorizontalGlue());
        north.add(iconCombo);
        north.add(Box.createHorizontalGlue());
        this.plusComp = new JPanel(new GridBagLayout());
        int addIconSize = Math.min(Math.max(32, displayIconSize / 2), 50);
        JSplitButton addEditorButton = ComponentHelper.createIconOnlySplitButton(DarkUIUtil.ICON_LOADER.getIcon("navigation/add.svg", addIconSize, addIconSize, true));
        int overlaySize = 2 * addIconSize / 3;
        addEditorButton.setOverlayDropDownIcon(DarkUIUtil.ICON_LOADER.getIcon("indicator/dropDown.svg", overlaySize, overlaySize, true));
        addEditorButton.setOverlayDropDownDisabledIcon(DarkUIUtil.ICON_LOADER.getIcon("indicator/dropDownDisabled.svg", overlaySize, overlaySize, true));
        addEditorButton.putClientProperty("JButton.arcMultiplier", 3);
        JPopupMenu menu = addEditorButton.getActionMenu();
        for (Theme theme : LafManager.getRegisteredThemes()) {
            Action a = Actions.create((String)theme.getDisplayName(), e -> this.addEditor(theme, this.selectedIcon));
            this.newEditorActions.put(theme, a);
            menu.add(a);
        }
        this.plusComp.setBorder(LayoutHelper.createEmptyContainerBorder());
        this.plusComp.add(addEditorButton);
        this.plusComp.setVisible(this.showEditorAddRemoveControls);
        this.plusComp.setEnabled(this.showEditorAddRemoveControls);
        JPanel holder = new JPanel(new HorizontalLayout());
        holder.add(this.editorPanel);
        holder.add(this.plusComp);
        OverlayScrollPane sp = new OverlayScrollPane(holder);
        sp.setAddVerticalScrollBarSize(true);
        this.add((Component)north, "North");
        this.add((Component)sp, "Center");
        this.addEditor(LafManager.getTheme());
        iconCombo.setSelectedIndex(0);
    }

    public IconEditorPanel addEditor(Theme theme) {
        return this.addEditor(theme, this.selectedIcon);
    }

    private IconEditorPanel addEditor(Theme theme, Icon icon) {
        Theme t = Theme.baseThemeOf((Theme)theme);
        IconEditorPanel prevEditor = this.editorMap.get(t);
        if (prevEditor != null) {
            return prevEditor;
        }
        IconEditorPanel editor = new IconEditorPanel(icon, theme);
        editor.setBorder(DarkBorders.createRightBorder());
        this.newEditorActions.get(t).setEnabled(false);
        this.editorMap.put(t, editor);
        CloseButton closeButton = new CloseButton();
        DynamicUI.withLocalizedTooltip(closeButton, "Actions.close");
        closeButton.setIcon(this.changeIconTheme((ThemedSVGIcon)closeButton.getIcon(), theme));
        closeButton.setDisabledIcon(this.changeIconTheme((ThemedSVGIcon)closeButton.getDisabledIcon(), theme));
        closeButton.setRolloverIcon(this.changeIconTheme((ThemedSVGIcon)closeButton.getRolloverIcon(), theme));
        closeButton.addActionListener(e -> this.removeEditor(editor));
        closeButton.setEnabled(this.showEditorAddRemoveControls);
        closeButton.setVisible(this.showEditorAddRemoveControls);
        if (this.newEditorActions.size() == this.editorMap.size()) {
            this.plusComp.setEnabled(false);
            this.plusComp.setVisible(false);
        }
        JComponent editorHolder = LayoutHelper.createPanelWithOverlay(editor, closeButton, Alignment.NORTH_WEST, LayoutHelper.createEmptyContainerInsets());
        this.editors.put(editor, closeButton);
        this.editorPanel.add(editorHolder);
        this.updateLayout();
        return editor;
    }

    private Icon changeIconTheme(ThemedSVGIcon icon, Theme theme) {
        if (icon == null) {
            return null;
        }
        return new CustomThemedIcon((DarkSVGIcon)icon, (Map)IconEditorPanel.IconValues.getIconDefaults(theme).getDefaults(), CustomThemedIcon.MergeMode.REMOVE_REFERENCES);
    }

    public void removeEditor(IconEditorPanel editor) {
        if (this.editors.remove(editor) == null) {
            return;
        }
        Theme t = Theme.baseThemeOf((Theme)editor.getTheme());
        this.editorMap.remove(t);
        this.newEditorActions.get(t).setEnabled(true);
        this.plusComp.setVisible(true);
        this.plusComp.setEnabled(true);
        this.editorPanel.remove(editor.getParent());
        this.updateLayout();
    }

    private void updateLayout() {
        this.editorPanel.getParent().doLayout();
        this.editorPanel.getParent().repaint();
    }

    public boolean isShowEditorAddRemoveControls() {
        return this.showEditorAddRemoveControls;
    }

    public void setShowEditorAddRemoveControls(boolean showEditorAddRemoveControls) {
        if (this.showEditorAddRemoveControls != showEditorAddRemoveControls) {
            if (!showEditorAddRemoveControls) {
                this.plusComp.setVisible(false);
                this.plusComp.setEnabled(false);
            } else if (this.editorMap.size() < this.newEditorActions.size()) {
                this.plusComp.setVisible(true);
                this.plusComp.setEnabled(true);
            }
            this.editors.forEach((k, b) -> {
                b.setVisible(showEditorAddRemoveControls);
                b.setEnabled(showEditorAddRemoveControls);
            });
            this.updateLayout();
        }
        this.showEditorAddRemoveControls = showEditorAddRemoveControls;
    }

    public List<Pair<Theme, Map<String, Object>>> exportProperties() {
        return this.editors.keySet().stream().map(e -> new Pair((Object)e.getTheme(), e.exportProperties())).collect(Collectors.toList());
    }
}

