/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.service.ecommercesubsidy;

import com.wechat.pay.java.core.Config;
import com.wechat.pay.java.core.http.DefaultHttpClientBuilder;
import com.wechat.pay.java.core.http.HostName;
import com.wechat.pay.java.core.http.HttpClient;
import com.wechat.pay.java.core.http.HttpHeaders;
import com.wechat.pay.java.core.http.HttpMethod;
import com.wechat.pay.java.core.http.HttpRequest;
import com.wechat.pay.java.core.http.HttpResponse;
import com.wechat.pay.java.core.http.JsonRequestBody;
import com.wechat.pay.java.core.http.MediaType;
import com.wechat.pay.java.core.http.RequestBody;
import com.wechat.pay.java.core.util.GsonUtil;
import com.wechat.pay.java.service.ecommercesubsidy.model.SubsidiesCancelEntity;
import com.wechat.pay.java.service.ecommercesubsidy.model.SubsidiesCancelRequest;
import com.wechat.pay.java.service.ecommercesubsidy.model.SubsidiesCreateEntity;
import com.wechat.pay.java.service.ecommercesubsidy.model.SubsidiesCreateRequest;
import com.wechat.pay.java.service.ecommercesubsidy.model.SubsidiesReturnEntity;
import com.wechat.pay.java.service.ecommercesubsidy.model.SubsidiesReturnRequest;
import java.util.Objects;

public class EcommerceSubsidyService {
    private final HttpClient httpClient;
    private final HostName hostName;

    private EcommerceSubsidyService(HttpClient httpClient, HostName hostName) {
        this.httpClient = Objects.requireNonNull(httpClient);
        this.hostName = hostName;
    }

    public SubsidiesCancelEntity cancelSubsidy(SubsidiesCancelRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/ecommerce/subsidies/cancel";
        SubsidiesCancelRequest realRequest = request;
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, SubsidiesCancelEntity.class);
        return (SubsidiesCancelEntity)httpResponse.getServiceResponse();
    }

    public SubsidiesCreateEntity createSubsidy(SubsidiesCreateRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/ecommerce/subsidies/create";
        SubsidiesCreateRequest realRequest = request;
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, SubsidiesCreateEntity.class);
        return (SubsidiesCreateEntity)httpResponse.getServiceResponse();
    }

    public SubsidiesReturnEntity returnSubsidy(SubsidiesReturnRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/ecommerce/subsidies/return";
        SubsidiesReturnRequest realRequest = request;
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, SubsidiesReturnEntity.class);
        return (SubsidiesReturnEntity)httpResponse.getServiceResponse();
    }

    private RequestBody createRequestBody(Object request) {
        return new JsonRequestBody.Builder().body(GsonUtil.toJson((Object)request)).build();
    }

    public static class Builder {
        private HttpClient httpClient;
        private HostName hostName;

        public Builder config(Config config) {
            this.httpClient = new DefaultHttpClientBuilder().config(config).build();
            return this;
        }

        public Builder hostName(HostName hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public EcommerceSubsidyService build() {
            return new EcommerceSubsidyService(this.httpClient, this.hostName);
        }
    }
}

