/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.core.certificate;

import com.wechat.pay.java.core.certificate.CertificateDownloader;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoCertificateService {
    private static final Logger log = LoggerFactory.getLogger(AutoCertificateService.class);
    protected static final int UPDATE_INTERVAL_MINUTE = 60;
    private static final Duration defaultUpdateInterval = Duration.ofMinutes(60L);
    private static final ConcurrentHashMap<String, Map<String, X509Certificate>> certificateMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Runnable> downloadWorkerMap = new ConcurrentHashMap();
    private static final ScheduledThreadPoolExecutor serviceExecutor = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){
        private final AtomicInteger threadCount = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "auto-certificate-service-daemon-" + this.threadCount.incrementAndGet());
            t.setDaemon(true);
            return t;
        }
    });
    private static ScheduledFuture<?> future;
    private static int updateCount;

    private AutoCertificateService() {
        throw new IllegalStateException("this class cannot be instantiated");
    }

    public static void register(String merchantId, String type, CertificateDownloader downloader) {
        String key = AutoCertificateService.calculateDownloadWorkerMapKey(merchantId, type);
        Runnable worker = () -> {
            Map<String, X509Certificate> result = downloader.download();
            certificateMap.put(key, result);
        };
        worker.run();
        downloadWorkerMap.put(key, worker);
        AutoCertificateService.start(defaultUpdateInterval);
    }

    public static void unregister(String merchantId, String type) {
        String key = AutoCertificateService.calculateDownloadWorkerMapKey(merchantId, type);
        downloadWorkerMap.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        downloadWorkerMap.clear();
        certificateMap.clear();
        Class<AutoCertificateService> clazz = AutoCertificateService.class;
        synchronized (AutoCertificateService.class) {
            if (future != null) {
                future.cancel(false);
                future = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start(Duration updateInterval) {
        Class<AutoCertificateService> clazz = AutoCertificateService.class;
        synchronized (AutoCertificateService.class) {
            if (future == null) {
                future = serviceExecutor.scheduleAtFixedRate(AutoCertificateService::update, updateInterval.toMillis() / TimeUnit.SECONDS.toMillis(1L), updateInterval.toMillis() / TimeUnit.SECONDS.toMillis(1L), TimeUnit.SECONDS);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static void update() {
        log.info("Begin update Certificates. total updates: {}", (Object)updateCount);
        downloadWorkerMap.forEach((k, v) -> {
            try {
                v.run();
                log.info("update wechatpay certificate {} done", k);
            }
            catch (Exception e) {
                log.error("Download and update wechatpay certificate {} failed", k);
            }
        });
        ++updateCount;
    }

    private static String calculateDownloadWorkerMapKey(String merchantId, String type) {
        return merchantId + "-" + type;
    }

    private static X509Certificate getAvailableCertificate(Map<String, X509Certificate> certificateMap) {
        X509Certificate longest = null;
        for (X509Certificate item : certificateMap.values()) {
            if (longest != null && !item.getNotAfter().after(longest.getNotAfter())) continue;
            longest = item;
        }
        return longest;
    }

    public static X509Certificate getCertificate(String merchantId, String type, String serialNumber) {
        String key = AutoCertificateService.calculateDownloadWorkerMapKey(merchantId, type);
        return certificateMap.get(key).get(serialNumber);
    }

    public static X509Certificate getAvailableCertificate(String merchantId, String type) {
        String key = AutoCertificateService.calculateDownloadWorkerMapKey(merchantId, type);
        return AutoCertificateService.getAvailableCertificate(certificateMap.get(key));
    }

    static {
        serviceExecutor.setRemoveOnCancelPolicy(true);
    }
}

