/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.core.auth;

import com.wechat.pay.java.core.auth.Credential;
import com.wechat.pay.java.core.cipher.SignatureResult;
import com.wechat.pay.java.core.cipher.Signer;
import com.wechat.pay.java.core.util.NonceUtil;
import java.net.URI;
import java.time.Instant;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WechatPay2Credential
implements Credential {
    private static final Logger logger = LoggerFactory.getLogger(WechatPay2Credential.class);
    private static final int NONCE_LENGTH = 32;
    public static final String SCHEMA_PREFIX = "WECHATPAY2-";
    private final String merchantId;
    private final Signer signer;

    public WechatPay2Credential(String merchantId, Signer signer) {
        this.merchantId = Objects.requireNonNull(merchantId);
        this.signer = Objects.requireNonNull(signer);
    }

    @Override
    public String getMerchantId() {
        return this.merchantId;
    }

    @Override
    public String getSchema() {
        return SCHEMA_PREFIX + this.signer.getAlgorithm();
    }

    @Override
    public String getAuthorization(URI uri, String httpMethod, String signBody) {
        Objects.requireNonNull(uri);
        Objects.requireNonNull(httpMethod);
        return this.getSchema() + " " + this.getToken(uri, httpMethod, signBody);
    }

    private String getToken(URI uri, String httpMethod, String signBody) {
        String nonceStr = NonceUtil.createNonce(32);
        long timestamp = Instant.now().getEpochSecond();
        String message = this.buildMessage(nonceStr, timestamp, uri, httpMethod, signBody);
        logger.debug("authorization message[{}]", (Object)message);
        SignatureResult signature = this.signer.sign(message);
        String token = "mchid=\"" + this.getMerchantId() + "\",nonce_str=\"" + nonceStr + "\",timestamp=\"" + timestamp + "\",serial_no=\"" + signature.getCertificateSerialNumber() + "\",signature=\"" + signature.getSign() + "\"";
        logger.debug("The generated request signature information is[{}]", (Object)token);
        return token;
    }

    private String buildMessage(String nonce, long timestamp, URI uri, String httpMethod, String signBody) {
        String canonicalUrl = uri.getRawPath();
        if (uri.getQuery() != null) {
            canonicalUrl = canonicalUrl + "?" + uri.getRawQuery();
        }
        return httpMethod + "\n" + canonicalUrl + "\n" + timestamp + "\n" + nonce + "\n" + (signBody == null ? "" : signBody) + "\n";
    }
}

