/*
 * Decompiled with CFR 0.152.
 */
package cn.mrlong.basicframework.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.annotation.NonNull;
import android.telephony.TelephonyManager;
import android.util.Log;
import java.lang.reflect.Method;

public class NetworkUtil {
    private static final int NETWORKTYPE_WIFI = 1;
    private static final int NETWORKTYPE_4G = 4;
    private static final int NETWORKTYPE_2G = 2;
    private static final int NETWORKTYPE_3G = 3;
    private static final int NETWORKTYPE_NONE = -1;
    private static final String TAG = NetworkUtil.class.getSimpleName();

    @NonNull
    public static String getNetType(Context context) {
        int netWorkType = NetworkUtil.getNetWorkClass(context);
        String netType = "";
        if (NetworkUtil.isWifi(context)) {
            netType = "WIFI";
            return "WIFI";
        }
        switch (netWorkType) {
            case 1: {
                netType = "WIFI";
                break;
            }
            case 2: {
                netType = "2G";
                break;
            }
            case 3: {
                netType = "3G";
                break;
            }
            case 4: {
                netType = "4G";
                break;
            }
            case -1: {
                netType = "NO";
            }
        }
        return netType;
    }

    public static ConnectivityManager getConnectivityManager(Context context) {
        return (ConnectivityManager)context.getSystemService("connectivity");
    }

    public static TelephonyManager getTelephonyManager(Context context) {
        return (TelephonyManager)context.getSystemService("phone");
    }

    public static boolean isConnected(Context context) {
        NetworkInfo net = NetworkUtil.getConnectivityManager(context).getActiveNetworkInfo();
        return net != null && net.isConnected();
    }

    public static boolean isConnectedOrConnecting(Context context) {
        NetworkInfo[] nets = NetworkUtil.getConnectivityManager(context).getAllNetworkInfo();
        if (nets != null) {
            for (NetworkInfo net : nets) {
                if (!net.isConnectedOrConnecting()) continue;
                return true;
            }
        }
        return false;
    }

    public static NetType getConnectedType(Context context) {
        NetworkInfo net = NetworkUtil.getConnectivityManager(context).getActiveNetworkInfo();
        if (net != null) {
            switch (net.getType()) {
                case 1: {
                    return NetType.WIFI;
                }
                case 0: {
                    return NetType.MOBILE;
                }
            }
            return NetType.OTHER;
        }
        return NetType.NONE;
    }

    public static boolean isWifi(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetInfo != null && activeNetInfo.getType() == 1;
    }

    public static boolean isWifiConnected(Context context) {
        NetworkInfo net = NetworkUtil.getConnectivityManager(context).getActiveNetworkInfo();
        return net != null && net.getType() == 1 && net.isConnected();
    }

    public static boolean isMobileConnected(Context context) {
        NetworkInfo net = NetworkUtil.getConnectivityManager(context).getActiveNetworkInfo();
        return net != null && net.getType() == 0 && net.isConnected();
    }

    public static boolean isAvailable(Context context) {
        return NetworkUtil.isWifiAvailable(context) || NetworkUtil.isMobileAvailable(context) && NetworkUtil.isMobileEnabled(context);
    }

    public static boolean isWifiAvailable(Context context) {
        NetworkInfo[] nets = NetworkUtil.getConnectivityManager(context).getAllNetworkInfo();
        if (nets != null) {
            for (NetworkInfo net : nets) {
                if (net.getType() != 1) continue;
                return net.isAvailable();
            }
        }
        return false;
    }

    public static boolean isMobileAvailable(Context context) {
        NetworkInfo[] nets = NetworkUtil.getConnectivityManager(context).getAllNetworkInfo();
        if (nets != null) {
            for (NetworkInfo net : nets) {
                if (net.getType() != 0) continue;
                return net.isAvailable();
            }
        }
        return false;
    }

    public static boolean isMobileEnabled(Context context) {
        try {
            Method getMobileDataEnabledMethod = ConnectivityManager.class.getDeclaredMethod("getMobileDataEnabled", new Class[0]);
            getMobileDataEnabledMethod.setAccessible(true);
            return (Boolean)getMobileDataEnabledMethod.invoke((Object)NetworkUtil.getConnectivityManager(context), new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    public static boolean printNetworkInfo(Context context) {
        ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivity != null) {
            NetworkInfo in = connectivity.getActiveNetworkInfo();
            Log.i((String)TAG, (String)"-------------$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$-------------");
            Log.i((String)TAG, (String)("getActiveNetworkInfo: " + in));
            NetworkInfo[] info = connectivity.getAllNetworkInfo();
            if (info != null) {
                for (int i = 0; i < info.length; ++i) {
                    Log.i((String)TAG, (String)("NetworkInfo[" + i + "]isAvailable : " + info[i].isAvailable()));
                    Log.i((String)TAG, (String)("NetworkInfo[" + i + "]isConnected : " + info[i].isConnected()));
                    Log.i((String)TAG, (String)("NetworkInfo[" + i + "]isConnectedOrConnecting : " + info[i].isConnectedOrConnecting()));
                    Log.i((String)TAG, (String)("NetworkInfo[" + i + "]: " + info[i]));
                }
                Log.i((String)TAG, (String)"\n");
            } else {
                Log.i((String)TAG, (String)"getAllNetworkInfo is null");
            }
        }
        return false;
    }

    public static int getConnectedTypeINT(Context context) {
        NetworkInfo net = NetworkUtil.getConnectivityManager(context).getActiveNetworkInfo();
        if (net != null) {
            return net.getType();
        }
        return -1;
    }

    public static int getTelNetworkTypeINT(Context context) {
        return NetworkUtil.getTelephonyManager(context).getNetworkType();
    }

    public static NetWorkType getNetworkType(Context context) {
        int type = NetworkUtil.getConnectedTypeINT(context);
        Log.e((String)"type===", (String)("" + type));
        switch (type) {
            case 1: {
                return NetWorkType.WIFI;
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                int teleType = NetworkUtil.getNetWorkClass(context);
                switch (teleType) {
                    case 2: {
                        return NetWorkType.NET_2_G;
                    }
                    case 3: {
                        return NetWorkType.NET_3_G;
                    }
                    case 4: {
                        return NetWorkType.NET_4_G;
                    }
                    case -1: {
                        return NetWorkType.UN_KNOWN;
                    }
                }
            }
        }
        return NetWorkType.UN_KNOWN;
    }

    public static int getNetWorkClass(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        switch (telephonyManager.getNetworkType()) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return 2;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return 3;
            }
            case 13: {
                return 4;
            }
        }
        return -1;
    }

    public static enum NetWorkType {
        UN_KNOWN(-1),
        WIFI(1),
        NET_2_G(2),
        NET_3_G(3),
        NET_4_G(4);

        public int value;

        private NetWorkType(int value) {
            this.value = value;
        }
    }

    public static enum NetType {
        NONE(1),
        MOBILE(2),
        WIFI(4),
        OTHER(8);

        public int value;

        private NetType(int value) {
            this.value = value;
        }
    }
}

