/*
 * Decompiled with CFR 0.152.
 */
package cn.mrlong.basicframework.utils;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.os.Handler;
import android.widget.Toast;
import cn.mrlong.basicframework.utils.AppUtils;
import java.net.URISyntaxException;

public class MapUtils {
    private final double EARTH_RADIUS = 6378137.0;

    public static void toGaoDeMap(final Context context, final String poiName, final double la, final double lo) {
        if (AppUtils.isAvilible(context, "com.autonavi.amapautolite")) {
            int startTime = 1000;
            try {
                Intent launchIntent = new Intent();
                launchIntent.setFlags(0x10000000);
                launchIntent.setComponent(new ComponentName("com.autonavi.amapautolite", "com.autonavi.auto.remote.fill.UsbFillActivity"));
                context.startActivity(launchIntent);
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        Intent intent = new Intent();
                        intent.setAction("AUTONAVI_STANDARD_BROADCAST_RECV");
                        intent.putExtra("KEY_TYPE", 10038);
                        intent.putExtra("POINAME", poiName);
                        intent.putExtra("LAT", la);
                        intent.putExtra("LON", lo);
                        intent.putExtra("DEV", 0);
                        intent.putExtra("STYLE", 0);
                        intent.putExtra("SOURCE_APP", AppUtils.getAppName(context));
                        context.sendBroadcast(intent);
                    }
                }, (long)startTime);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (AppUtils.isAvilible(context, "com.autonavi.minimap")) {
            try {
                Intent intent = Intent.getIntent((String)("androidamap://navi?sourceApplication=" + AppUtils.getAppName(context) + "&poiname=" + poiName + "&lat=" + la + "&lon=" + lo + "&dev=0"));
                context.startActivity(intent);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        } else {
            Toast.makeText((Context)context, (CharSequence)"\u4f60\u5c1a\u672a\u5b89\u88c5\u9ad8\u5fb7\u5730\u56fe!", (int)1).show();
        }
    }

    public static void offGaoDeMap(Context context) {
        Intent intents = new Intent();
        intents.setAction("AUTONAVI_STANDARD_BROADCAST_RECV");
        intents.putExtra("KEY_TYPE", 10021);
        context.sendBroadcast(intents);
    }

    public static void toBaiDuMap(Context context, Location location) {
        if (AppUtils.isAvilible(context, "com.baidu.BaiduMap")) {
            try {
                Intent intent = Intent.getIntent((String)("intent://map/direction?destination=latlng:" + location.getLatitude() + "," + location.getLongitude() + "|name:\u6211\u7684\u76ee\u7684\u5730&mode=driving&region=\u5317\u4eac&src=\u6167\u533b#Intent;scheme=bdapp;package=com.baidu.BaiduMap;end"));
                context.startActivity(intent);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        } else {
            Toast.makeText((Context)context, (CharSequence)"\u60a8\u5c1a\u672a\u5b89\u88c5\u767e\u5ea6\u5730\u56fe", (int)1).show();
        }
    }

    private double gps2d(double lat_a, double lng_a, double lat_b, double lng_b) {
        double d = 0.0;
        lat_a = lat_a * Math.PI / 180.0;
        lng_a = lng_a * Math.PI / 180.0;
        lat_b = lat_b * Math.PI / 180.0;
        lng_b = lng_b * Math.PI / 180.0;
        d = Math.sin(lat_a) * Math.sin(lat_b) + Math.cos(lat_a) * Math.cos(lat_b) * Math.cos(lng_b - lng_a);
        d = Math.sqrt(1.0 - d * d);
        d = Math.cos(lat_b) * Math.sin(lng_b - lng_a) / d;
        d = Math.asin(d) * 180.0 / Math.PI;
        return d;
    }

    private double gps2m(double lat_a, double lng_a, double lat_b, double lng_b) {
        double radLat1 = lat_a * Math.PI / 180.0;
        double radLat2 = lat_b * Math.PI / 180.0;
        double a = radLat1 - radLat2;
        double b = (lng_a - lng_b) * Math.PI / 180.0;
        double s = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        s *= 6378137.0;
        s = Math.round(s * 10000.0) / 10000L;
        return s;
    }
}

