/*
 * Decompiled with CFR 0.152.
 */
package waffle.mock.http;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleHttpResponse
extends HttpServletResponseWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleHttpResponse.class);
    private int status = 500;
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    final ByteArrayOutputStream bytes = new ByteArrayOutputStream();
    private final ServletOutputStream out = new ServletOutputStream(){

        public void write(int b) throws IOException {
            SimpleHttpResponse.this.bytes.write(b);
        }

        public boolean isReady() {
            return false;
        }

        public void setWriteListener(WriteListener writeListener) {
        }
    };
    private final PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)this.bytes, StandardCharsets.UTF_8), true);

    public SimpleHttpResponse() {
        super((HttpServletResponse)Mockito.mock(HttpServletResponse.class));
    }

    public int getStatus() {
        return this.status;
    }

    public void addHeader(String headerName, String headerValue) {
        List<String> current = this.headers.get(headerName);
        if (current == null) {
            current = new ArrayList<String>();
        }
        current.add(headerValue);
        this.headers.put(headerName, current);
    }

    public void setHeader(String headerName, String headerValue) {
        List<String> current = this.headers.get(headerName);
        if (current == null) {
            current = new ArrayList<String>();
        } else {
            current.clear();
        }
        current.add(headerValue);
        this.headers.put(headerName, current);
    }

    public void setStatus(int value) {
        this.status = value;
    }

    public String getStatusString() {
        if (this.status == 401) {
            return "Unauthorized";
        }
        return "Unknown";
    }

    public void flushBuffer() {
        LOGGER.info("{}: {}", (Object)this.status, (Object)this.getStatusString());
        for (Map.Entry<String, List<String>> header : this.headers.entrySet()) {
            for (String headerValue : header.getValue()) {
                LOGGER.info("{}: {}", header, (Object)headerValue);
            }
        }
    }

    public int getHeaderNamesSize() {
        return this.headers.size();
    }

    public String[] getHeaderValues(String headerName) {
        List<String> headerValues = this.headers.get(headerName);
        return headerValues == null ? null : headerValues.toArray(new String[0]);
    }

    public String getHeader(String headerName) {
        List<String> headerValues = this.headers.get(headerName);
        return headerValues == null ? null : String.join((CharSequence)", ", headerValues);
    }

    public void sendError(int rc, String message) {
        this.status = rc;
    }

    public void sendError(int rc) {
        this.status = rc;
    }

    public PrintWriter getWriter() {
        return this.writer;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.out;
    }

    public String getOutputText() {
        this.writer.flush();
        try {
            return this.bytes.toString(StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("", (Throwable)e);
            return null;
        }
    }
}

