/*
 * Decompiled with CFR 0.152.
 */
package waffle.spring;

import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import waffle.spring.GrantedAuthorityFactory;
import waffle.windows.auth.WindowsAccount;

public class FqnGrantedAuthorityFactory
implements GrantedAuthorityFactory {
    private final String prefix;
    private final boolean convertToUpperCase;

    public FqnGrantedAuthorityFactory(String newPrefix, boolean newConvertToUpperCase) {
        this.prefix = newPrefix;
        this.convertToUpperCase = newConvertToUpperCase;
    }

    @Override
    public GrantedAuthority createGrantedAuthority(WindowsAccount windowsAccount) {
        String grantedAuthorityString = windowsAccount.getFqn();
        if (this.prefix != null) {
            grantedAuthorityString = this.prefix + grantedAuthorityString;
        }
        if (this.convertToUpperCase) {
            grantedAuthorityString = grantedAuthorityString.toUpperCase();
        }
        return new SimpleGrantedAuthority(grantedAuthorityString);
    }
}

