/*
 * Decompiled with CFR 0.152.
 */
package waffle.shiro.negotiate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.authc.AuthenticatingFilter;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import waffle.shiro.negotiate.AuthenticationInProgressException;
import waffle.shiro.negotiate.NegotiateToken;
import waffle.util.AuthorizationHeader;
import waffle.util.NtlmServletRequest;

public class NegotiateAuthenticationFilter
extends AuthenticatingFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(NegotiateAuthenticationFilter.class);
    private static final List<String> PROTOCOLS = new ArrayList<String>();
    private String failureKeyAttribute = "shiroLoginFailure";
    private String rememberMeParam = "rememberMe";

    public NegotiateAuthenticationFilter() {
        PROTOCOLS.add("Negotiate");
        PROTOCOLS.add("NTLM");
    }

    public String getRememberMeParam() {
        return this.rememberMeParam;
    }

    public void setRememberMeParam(String value) {
        this.rememberMeParam = value;
    }

    protected boolean isRememberMe(ServletRequest request) {
        return WebUtils.isTrue((ServletRequest)request, (String)this.getRememberMeParam());
    }

    protected AuthenticationToken createToken(ServletRequest request, ServletResponse response) {
        String authorization = this.getAuthzHeader(request);
        String[] elements = authorization.split(" ", -1);
        byte[] inToken = Base64.getDecoder().decode(elements[1]);
        String connectionId = NtlmServletRequest.getConnectionId((HttpServletRequest)((HttpServletRequest)request));
        String securityPackage = elements[0];
        AuthorizationHeader authorizationHeader = new AuthorizationHeader((HttpServletRequest)request);
        boolean ntlmPost = authorizationHeader.isNtlmType1PostAuthorizationHeader();
        LOGGER.debug("security package: {}, connection id: {}, ntlmPost: {}", new Object[]{securityPackage, connectionId, ntlmPost});
        boolean rememberMe = this.isRememberMe(request);
        String host = this.getHost(request);
        return new NegotiateToken(inToken, new byte[0], connectionId, securityPackage, ntlmPost, rememberMe, host);
    }

    protected boolean onLoginSuccess(AuthenticationToken token, Subject subject, ServletRequest request, ServletResponse response) throws Exception {
        request.setAttribute("MY_SUBJECT", (Object)((NegotiateToken)token).getSubject());
        return true;
    }

    protected boolean onLoginFailure(AuthenticationToken token, AuthenticationException e, ServletRequest request, ServletResponse response) {
        if (e instanceof AuthenticationInProgressException) {
            String protocol = this.getAuthzHeaderProtocol(request);
            LOGGER.debug("Negotiation in progress for protocol: {}", (Object)protocol);
            this.sendChallengeDuringNegotiate(protocol, response, ((NegotiateToken)token).getOut());
            return false;
        }
        LOGGER.warn("login exception: {}", (Object)e.getMessage());
        this.sendChallengeOnFailure(response);
        this.setFailureAttribute(request, e);
        return true;
    }

    protected void setFailureAttribute(ServletRequest request, AuthenticationException ae) {
        String className = ae.getClass().getName();
        request.setAttribute(this.getFailureKeyAttribute(), (Object)className);
    }

    public String getFailureKeyAttribute() {
        return this.failureKeyAttribute;
    }

    public void setFailureKeyAttribute(String value) {
        this.failureKeyAttribute = value;
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        boolean loggedIn = false;
        if (this.isLoginAttempt(request)) {
            loggedIn = this.executeLogin(request, response);
        } else {
            LOGGER.debug("authorization required, supported protocols: {}", PROTOCOLS);
            this.sendChallengeInitiateNegotiate(response);
        }
        return loggedIn;
    }

    private String getAuthzHeader(ServletRequest request) {
        HttpServletRequest httpRequest = WebUtils.toHttp((ServletRequest)request);
        return httpRequest.getHeader("Authorization");
    }

    private String getAuthzHeaderProtocol(ServletRequest request) {
        String authzHeader = this.getAuthzHeader(request);
        return authzHeader.substring(0, authzHeader.indexOf(32));
    }

    private boolean isLoginAttempt(ServletRequest request) {
        String authzHeader = this.getAuthzHeader(request);
        return authzHeader != null && this.isLoginAttempt(authzHeader);
    }

    boolean isLoginAttempt(String authzHeader) {
        for (String protocol : PROTOCOLS) {
            if (!authzHeader.toLowerCase(Locale.ENGLISH).startsWith(protocol.toLowerCase(Locale.ENGLISH))) continue;
            return true;
        }
        return false;
    }

    private void sendChallenge(List<String> protocols, ServletResponse response, byte[] out) {
        HttpServletResponse httpResponse = WebUtils.toHttp((ServletResponse)response);
        this.sendAuthenticateHeader(protocols, out, httpResponse);
        httpResponse.setStatus(401);
    }

    void sendChallengeInitiateNegotiate(ServletResponse response) {
        this.sendChallenge(PROTOCOLS, response, null);
    }

    void sendChallengeDuringNegotiate(String protocol, ServletResponse response, byte[] out) {
        ArrayList<String> protocolsList = new ArrayList<String>();
        protocolsList.add(protocol);
        this.sendChallenge(protocolsList, response, out);
    }

    void sendChallengeOnFailure(ServletResponse response) {
        HttpServletResponse httpResponse = WebUtils.toHttp((ServletResponse)response);
        this.sendUnauthorized(PROTOCOLS, null, httpResponse);
        httpResponse.setHeader("Connection", "close");
        try {
            httpResponse.sendError(401);
            httpResponse.flushBuffer();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void sendAuthenticateHeader(List<String> protocolsList, byte[] out, HttpServletResponse httpResponse) {
        this.sendUnauthorized(protocolsList, out, httpResponse);
        httpResponse.setHeader("Connection", "keep-alive");
    }

    private void sendUnauthorized(List<String> protocols, byte[] out, HttpServletResponse response) {
        for (String protocol : protocols) {
            if (out == null || out.length == 0) {
                response.addHeader("WWW-Authenticate", protocol);
                continue;
            }
            response.setHeader("WWW-Authenticate", protocol + " " + Base64.getEncoder().encodeToString(out));
        }
    }
}

