/*
 * Decompiled with CFR 0.152.
 */
package waffle.shiro.dynamic;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.authc.FormAuthenticationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import waffle.shiro.negotiate.NegotiateAuthenticationFilter;

public class DynamicAuthenticationFilter
extends FormAuthenticationFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicAuthenticationFilter.class);
    public static final String PARAM_NAME_AUTHTYPE = "authType";
    public static final String PARAM_VAL_AUTHTYPE_NEGOTIATE = "j_negotiate";
    private final WrapNegotiateAuthenticationFilter filterNegotiate = new WrapNegotiateAuthenticationFilter(this);
    private final WrapFormAuthenticationFilter filterFormAuthc = new WrapFormAuthenticationFilter(this);

    protected boolean executeLogin(ServletRequest request, ServletResponse response) throws Exception {
        if (this.isAuthTypeNegotiate(request)) {
            LOGGER.debug("using filterNegotiate");
            return this.filterNegotiate.onAccessDenied(request, response);
        }
        LOGGER.debug("using filterFormAuthc");
        return this.filterFormAuthc.onAccessDenied(request, response);
    }

    boolean isAuthTypeNegotiate(ServletRequest request) {
        String authType = request.getParameter(PARAM_NAME_AUTHTYPE);
        return authType != null && PARAM_VAL_AUTHTYPE_NEGOTIATE.equalsIgnoreCase(authType);
    }

    private static final class WrapNegotiateAuthenticationFilter
    extends NegotiateAuthenticationFilter {
        private final DynamicAuthenticationFilter parent;

        WrapNegotiateAuthenticationFilter(DynamicAuthenticationFilter newParent) {
            this.parent = newParent;
        }

        @Override
        public boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
            return super.onAccessDenied(request, response);
        }

        @Override
        protected boolean onLoginSuccess(AuthenticationToken token, Subject subject, ServletRequest request, ServletResponse response) throws Exception {
            return this.parent.onLoginSuccess(token, subject, request, response);
        }
    }

    private static final class WrapFormAuthenticationFilter
    extends FormAuthenticationFilter {
        private final DynamicAuthenticationFilter parent;

        WrapFormAuthenticationFilter(DynamicAuthenticationFilter newParent) {
            this.parent = newParent;
        }

        public boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
            return super.onAccessDenied(request, response);
        }

        protected boolean onLoginSuccess(AuthenticationToken token, Subject subject, ServletRequest request, ServletResponse response) throws Exception {
            return this.parent.onLoginSuccess(token, subject, request, response);
        }
    }
}

