/*
 * Decompiled with CFR 0.152.
 */
package waffle.shiro;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import waffle.windows.auth.IWindowsAccount;
import waffle.windows.auth.IWindowsIdentity;

public class WaffleFqnPrincipal
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String fqn;
    private final Set<String> groupFqns = new HashSet<String>();

    WaffleFqnPrincipal(IWindowsIdentity identity) {
        this.fqn = identity.getFqn();
        for (IWindowsAccount group : identity.getGroups()) {
            this.groupFqns.add(group.getFqn());
        }
    }

    public String getFqn() {
        return this.fqn;
    }

    public Set<String> getGroupFqns() {
        return Collections.unmodifiableSet(this.groupFqns);
    }

    public boolean equals(Object obj) {
        if (obj instanceof WaffleFqnPrincipal) {
            return this.fqn.equals(((WaffleFqnPrincipal)obj).fqn);
        }
        return false;
    }

    public int hashCode() {
        return this.fqn.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(":");
        stringBuilder.append(this.fqn);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

