/*
 * Decompiled with CFR 0.152.
 */
package waffle.shiro;

import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.HashingPasswordService;
import org.apache.shiro.authc.credential.PasswordMatcher;
import org.apache.shiro.authc.credential.PasswordService;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.crypto.hash.Hash;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.util.ByteSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import waffle.shiro.WaffleFqnPrincipal;
import waffle.windows.auth.IWindowsAuthProvider;
import waffle.windows.auth.IWindowsIdentity;
import waffle.windows.auth.impl.WindowsAuthProviderImpl;

public abstract class AbstractWaffleRealm
extends AuthorizingRealm {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractWaffleRealm.class);
    private static final String REALM_NAME = "WAFFLE";
    private IWindowsAuthProvider provider = new WindowsAuthProviderImpl();

    protected final AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authToken) {
        AuthenticationInfo authenticationInfo = null;
        if (authToken instanceof UsernamePasswordToken) {
            UsernamePasswordToken token = (UsernamePasswordToken)authToken;
            String username = token.getUsername();
            IWindowsIdentity identity = null;
            try {
                LOGGER.debug("Attempting login for user {}", (Object)username);
                identity = this.provider.logonUser(username, new String(token.getPassword()));
                if (identity.isGuest()) {
                    LOGGER.debug("Guest identity for user {}; denying access", (Object)username);
                    throw new AuthenticationException("Guest identities are not allowed access");
                }
                WaffleFqnPrincipal principal = new WaffleFqnPrincipal(identity);
                authenticationInfo = this.buildAuthenticationInfo(token, principal);
                LOGGER.debug("Successful login for user {}", (Object)username);
            }
            catch (RuntimeException e) {
                LOGGER.debug("Failed login for user {}: {}", (Object)username, (Object)e.getMessage());
                LOGGER.trace("", (Throwable)e);
                throw new AuthenticationException("Login failed", (Throwable)e);
            }
            finally {
                if (identity != null) {
                    identity.dispose();
                }
            }
        }
        return authenticationInfo;
    }

    private AuthenticationInfo buildAuthenticationInfo(UsernamePasswordToken token, Object principal) {
        SimpleAuthenticationInfo authenticationInfo;
        HashingPasswordService hashService = this.getHashService();
        if (hashService != null) {
            Hash hash = hashService.hashPassword((Object)token.getPassword());
            ByteSource salt = hash.getSalt();
            authenticationInfo = new SimpleAuthenticationInfo(principal, (Object)hash, salt, REALM_NAME);
        } else {
            Object creds = token.getCredentials();
            authenticationInfo = new SimpleAuthenticationInfo(principal, creds, REALM_NAME);
        }
        return authenticationInfo;
    }

    protected final AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        WaffleFqnPrincipal principal = (WaffleFqnPrincipal)principals.oneByType(WaffleFqnPrincipal.class);
        return principal == null ? null : this.buildAuthorizationInfo(principal);
    }

    protected abstract AuthorizationInfo buildAuthorizationInfo(WaffleFqnPrincipal var1);

    void setProvider(IWindowsAuthProvider value) {
        this.provider = value;
    }

    private HashingPasswordService getHashService() {
        PasswordMatcher passwordMatcher;
        PasswordService passwordService;
        CredentialsMatcher matcher = this.getCredentialsMatcher();
        if (matcher instanceof PasswordMatcher && (passwordService = (passwordMatcher = (PasswordMatcher)matcher).getPasswordService()) instanceof HashingPasswordService) {
            return (HashingPasswordService)passwordService;
        }
        return null;
    }
}

