/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.analysis;

import com.mxgraph.analysis.StructuralException;
import com.mxgraph.analysis.mxAnalysisGraph;
import com.mxgraph.analysis.mxGraphProperties;
import com.mxgraph.analysis.mxGraphStructure;
import com.mxgraph.costfunction.mxCostFunction;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class mxTraversal {
    public static void dfs(mxAnalysisGraph aGraph, Object startVertex, mxGraph.mxICellVisitor visitor) {
        mxTraversal.dfsRec(aGraph, startVertex, null, new HashSet<Object>(), visitor);
    }

    private static void dfsRec(mxAnalysisGraph aGraph, Object cell, Object edge, Set<Object> seen, mxGraph.mxICellVisitor visitor) {
        if (cell != null && !seen.contains(cell)) {
            visitor.visit(cell, edge);
            seen.add(cell);
            Object[] edges = aGraph.getEdges(cell, null, false, true);
            Object[] opposites = aGraph.getOpposites(edges, cell);
            for (int i = 0; i < opposites.length; ++i) {
                mxTraversal.dfsRec(aGraph, opposites[i], edges[i], seen, visitor);
            }
        }
    }

    public static void bfs(mxAnalysisGraph aGraph, Object startVertex, mxGraph.mxICellVisitor visitor) {
        if (aGraph != null && startVertex != null && visitor != null) {
            HashSet<Object> queued = new HashSet<Object>();
            LinkedList<Object[]> queue = new LinkedList<Object[]>();
            Object[] q = new Object[]{startVertex, null};
            queue.addLast(q);
            queued.add(startVertex);
            mxTraversal.bfsRec(aGraph, queued, queue, visitor);
        }
    }

    private static void bfsRec(mxAnalysisGraph aGraph, Set<Object> queued, LinkedList<Object[]> queue, mxGraph.mxICellVisitor visitor) {
        if (queue.size() > 0) {
            Object[] q = queue.removeFirst();
            Object cell = q[0];
            Object incomingEdge = q[1];
            visitor.visit(cell, incomingEdge);
            Object[] edges = aGraph.getEdges(cell, null, false, false);
            for (int i = 0; i < edges.length; ++i) {
                Object[] currEdge = new Object[]{edges[i]};
                Object opposite = aGraph.getOpposites(currEdge, cell)[0];
                if (queued.contains(opposite)) continue;
                Object[] current = new Object[]{opposite, edges[i]};
                queue.addLast(current);
                queued.add(opposite);
            }
            mxTraversal.bfsRec(aGraph, queued, queue, visitor);
        }
    }

    public static void dijkstra(mxAnalysisGraph aGraph, Object startVertex, Object endVertex, mxGraph.mxICellVisitor visitor) throws StructuralException {
        if (!mxGraphStructure.isConnected(aGraph)) {
            throw new StructuralException("The current Dijkstra algorithm only works for connected graphs and this graph isn't connected");
        }
        Object parent = aGraph.getGraph().getDefaultParent();
        Object[] vertexes = aGraph.getChildVertices(parent);
        int vertexCount = vertexes.length;
        double[] distances = new double[vertexCount];
        Object[][] parents = new Object[vertexCount][2];
        ArrayList<Object> vertexList = new ArrayList<Object>();
        ArrayList<Object> vertexListStatic = new ArrayList<Object>();
        for (int i = 0; i < vertexCount; ++i) {
            distances[i] = 2.147483647E9;
            vertexList.add(vertexes[i]);
            vertexListStatic.add(vertexes[i]);
        }
        distances[vertexListStatic.indexOf((Object)startVertex)] = 0.0;
        mxCostFunction costFunction = aGraph.getGenerator().getCostFunction();
        mxGraphView view = aGraph.getGraph().getView();
        while (vertexList.size() > 0) {
            double currDistance;
            Object currVertex = vertexList.get(0);
            int currIndex = vertexListStatic.indexOf(currVertex);
            double minDistance = currDistance = distances[currIndex];
            Object closestVertex = currVertex;
            if (vertexList.size() > 1) {
                for (int i = 1; i < vertexList.size(); ++i) {
                    currVertex = vertexList.get(i);
                    currIndex = vertexListStatic.indexOf(currVertex);
                    currDistance = distances[currIndex];
                    if (!(currDistance < minDistance)) continue;
                    minDistance = currDistance;
                    closestVertex = currVertex;
                }
            }
            vertexList.remove(closestVertex);
            Object currEdge = new Object();
            Object[] neighborVertices = aGraph.getOpposites(aGraph.getEdges(closestVertex, null, true, true, false, true), closestVertex, true, true);
            for (int j = 0; j < neighborVertices.length; ++j) {
                Object currNeighbor = neighborVertices[j];
                if (!vertexList.contains(currNeighbor)) continue;
                Object[] neighborEdges = aGraph.getEdges(currNeighbor, null, true, true, false, true);
                Object connectingEdge = null;
                for (int k = 0; k < neighborEdges.length; ++k) {
                    currEdge = neighborEdges[k];
                    if (!aGraph.getTerminal(currEdge, true).equals(closestVertex) && !aGraph.getTerminal(currEdge, false).equals(closestVertex)) continue;
                    connectingEdge = currEdge;
                }
                int neighborIndex = vertexListStatic.indexOf(currNeighbor);
                double oldDistance = distances[neighborIndex];
                double currEdgeWeight = costFunction.getCost(new mxCellState(view, connectingEdge, null));
                double newDistance = minDistance + currEdgeWeight;
                if (!(newDistance < oldDistance)) continue;
                distances[neighborIndex] = newDistance;
                parents[neighborIndex][0] = closestVertex;
                parents[neighborIndex][1] = connectingEdge;
            }
        }
        ArrayList<Object[]> resultList = new ArrayList<Object[]>();
        Object currVertex = endVertex;
        while (currVertex != startVertex) {
            int currIndex = vertexListStatic.indexOf(currVertex);
            currVertex = parents[currIndex][0];
            resultList.add(0, parents[currIndex]);
        }
        resultList.add(resultList.size(), new Object[]{endVertex, null});
        for (int i = 0; i < resultList.size(); ++i) {
            visitor.visit(((Object[])resultList.get(i))[0], ((Object[])resultList.get(i))[1]);
        }
    }

    public static List<Map<Object, Object>> bellmanFord(mxAnalysisGraph aGraph, Object startVertex) throws StructuralException {
        int i;
        mxGraph graph = aGraph.getGraph();
        Object[] vertices = aGraph.getChildVertices(graph.getDefaultParent());
        Object[] edges = aGraph.getChildEdges(graph.getDefaultParent());
        int vertexNum = vertices.length;
        int edgeNum = edges.length;
        HashMap<Object, Double> distanceMap = new HashMap<Object, Double>();
        HashMap<Object, Object> parentMap = new HashMap<Object, Object>();
        mxCostFunction costFunction = aGraph.getGenerator().getCostFunction();
        mxGraphView view = graph.getView();
        for (i = 0; i < vertexNum; ++i) {
            Object currVertex = vertices[i];
            distanceMap.put(currVertex, (Double)Double.MAX_VALUE);
        }
        distanceMap.put(startVertex, 0.0);
        parentMap.put(startVertex, startVertex);
        for (i = 0; i < vertexNum; ++i) {
            for (int j = 0; j < edgeNum; ++j) {
                Object currEdge = edges[j];
                Object source = aGraph.getTerminal(currEdge, true);
                Object target = aGraph.getTerminal(currEdge, false);
                double dist = (Double)distanceMap.get(source) + costFunction.getCost(new mxCellState(view, currEdge, null));
                if (dist < (Double)distanceMap.get(target)) {
                    distanceMap.put(target, dist);
                    parentMap.put(target, source);
                }
                if (mxGraphProperties.isDirected(aGraph.getProperties(), mxGraphProperties.DEFAULT_DIRECTED) || !((dist = (Double)distanceMap.get(target) + costFunction.getCost(new mxCellState(view, currEdge, null))) < (Double)distanceMap.get(source))) continue;
                distanceMap.put(source, dist);
                parentMap.put(source, target);
            }
        }
        for (i = 0; i < edgeNum; ++i) {
            Object currEdge = edges[i];
            Object source = aGraph.getTerminal(currEdge, true);
            Object target = aGraph.getTerminal(currEdge, false);
            double dist = (Double)distanceMap.get(source) + costFunction.getCost(new mxCellState(view, currEdge, null));
            if (!(dist < (Double)distanceMap.get(target))) continue;
            throw new StructuralException("The graph contains a negative cycle, so Bellman-Ford can't be completed.");
        }
        ArrayList<Map<Object, Object>> result = new ArrayList<Map<Object, Object>>();
        result.add(distanceMap);
        result.add(parentMap);
        return result;
    }

    public static ArrayList<Object[][]> floydRoyWarshall(mxAnalysisGraph aGraph) throws StructuralException {
        Object[] vertices = aGraph.getChildVertices(aGraph.getGraph().getDefaultParent());
        Double[][] dist = new Double[vertices.length][vertices.length];
        Object[][] paths = new Object[vertices.length][vertices.length];
        HashMap<Object, Integer> indexMap = new HashMap<Object, Integer>();
        for (int i = 0; i < vertices.length; ++i) {
            indexMap.put(vertices[i], i);
        }
        Object[] edges = aGraph.getChildEdges(aGraph.getGraph().getDefaultParent());
        dist = mxTraversal.initializeWeight(aGraph, vertices, edges, indexMap);
        for (int k = 0; k < vertices.length; ++k) {
            for (int i = 0; i < vertices.length; ++i) {
                for (int j = 0; j < vertices.length; ++j) {
                    if (!(dist[i][j] > dist[i][k] + dist[k][j])) continue;
                    paths[i][j] = mxGraphStructure.getVertexWithValue(aGraph, k);
                    dist[i][j] = dist[i][k] + dist[k][j];
                }
            }
        }
        for (int i = 0; i < dist[0].length; ++i) {
            if (!(dist[i][i] < 0.0)) continue;
            throw new StructuralException("The graph has negative cycles");
        }
        ArrayList<Object[][]> result = new ArrayList<Object[][]>();
        result.add(dist);
        result.add(paths);
        return result;
    }

    private static Double[][] initializeWeight(mxAnalysisGraph aGraph, Object[] nodes, Object[] edges, Map<Object, Integer> indexMap) {
        Double[][] weight = new Double[nodes.length][nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            Arrays.fill(weight[i], (Object)Double.MAX_VALUE);
        }
        boolean isDirected = mxGraphProperties.isDirected(aGraph.getProperties(), mxGraphProperties.DEFAULT_DIRECTED);
        mxCostFunction costFunction = aGraph.getGenerator().getCostFunction();
        mxGraphView view = aGraph.getGraph().getView();
        for (Object currEdge : edges) {
            Object source = aGraph.getTerminal(currEdge, true);
            Object target = aGraph.getTerminal(currEdge, false);
            weight[indexMap.get((Object)source).intValue()][indexMap.get((Object)target).intValue()] = costFunction.getCost(view.getState(currEdge));
            if (isDirected) continue;
            weight[indexMap.get((Object)target).intValue()][indexMap.get((Object)source).intValue()] = costFunction.getCost(view.getState(currEdge));
        }
        for (int i = 0; i < nodes.length; ++i) {
            weight[i][i] = 0.0;
        }
        return weight;
    }

    public static Object[] getWFIPath(mxAnalysisGraph aGraph, ArrayList<Object[][]> FWIresult, Object startVertex, Object targetVertex) throws StructuralException {
        Object[][] dist = FWIresult.get(0);
        Object[][] paths = FWIresult.get(1);
        ArrayList<Object> result = null;
        if (aGraph == null || paths == null || startVertex == null || targetVertex == null) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < dist[0].length; ++i) {
            if (!((Double)dist[i][i] < 0.0)) continue;
            throw new StructuralException("The graph has negative cycles");
        }
        if (startVertex != targetVertex) {
            mxCostFunction cf = aGraph.getGenerator().getCostFunction();
            mxGraphView view = aGraph.getGraph().getView();
            ArrayList<Object> currPath = new ArrayList<Object>();
            currPath.add(startVertex);
            while (startVertex != targetVertex) {
                result = mxTraversal.getWFIPathRec(aGraph, paths, startVertex, targetVertex, currPath, cf, view);
                startVertex = result.get(result.size() - 1);
            }
        }
        if (result == null) {
            result = new ArrayList();
        }
        return result.toArray();
    }

    private static ArrayList<Object> getWFIPathRec(mxAnalysisGraph aGraph, Object[][] paths, Object startVertex, Object targetVertex, ArrayList<Object> currPath, mxCostFunction cf, mxGraphView view) throws StructuralException {
        Double targetIndexD;
        int tIndex;
        Double sourceIndexD = cf.getCost(view.getState(startVertex));
        Object[] parents = paths[sourceIndexD.intValue()];
        if (parents[tIndex = (targetIndexD = Double.valueOf(cf.getCost(view.getState(targetVertex)))).intValue()] != null) {
            currPath = mxTraversal.getWFIPathRec(aGraph, paths, startVertex, parents[tIndex], currPath, cf, view);
        } else if (mxGraphStructure.areConnected(aGraph, startVertex, targetVertex) || startVertex == targetVertex) {
            currPath.add(targetVertex);
        } else {
            throw new StructuralException("The two vertices aren't connected");
        }
        return currPath;
    }
}

