/*
 * Decompiled with CFR 0.152.
 */
package com.github.vlsi.compactmap;

import com.github.andrewoma.dexx.collection.DerivedKeyHashMap;
import com.github.andrewoma.dexx.collection.KeyFunction;
import com.github.andrewoma.dexx.collection.Map;
import com.github.krukow.clj_ds.PersistentMap;
import com.github.krukow.clj_lang.PersistentHashMap;
import com.github.krukow.clj_lang.PersistentTreeMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;
import org.pcollections.HashTreePMap;
import org.pcollections.PMap;

@State(value=Scope.Thread)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class MyBenchmark {
    @Param(value={"5", "10", "25", "50", "75", "100", "150", "500", "1000"})
    int n = 100;
    List<Value> data;
    java.util.Map<Integer, Integer> hashMap;
    java.util.Map<Integer, Integer> treeMap;
    PMap<Integer, Integer> pcollHashMap;
    Map<Integer, Integer> dexxTreeMap;
    Map<Integer, Value> dexxSmartMap;
    Map<Integer, Value> hashDexx;
    Map<Integer, Value> hashDexxSmart;
    PersistentMap<Integer, Integer> cljHashMap;
    PersistentMap<Integer, Integer> cljTreeMap;

    @Setup
    public void init() {
        this.data = new ArrayList<Value>(this.n);
        for (int i = 0; i < this.n; ++i) {
            this.data.add(new Value(i * 1001, i));
        }
        Collections.shuffle(this.data);
        this.pcollHashMap = HashTreePMap.empty();
        this.dexxTreeMap = new com.github.andrewoma.dexx.collection.TreeMap();
        KeyFunction<Integer, Value> keyFunction = new KeyFunction<Integer, Value>(){

            public Integer key(Value value) {
                return value.key;
            }
        };
        this.dexxSmartMap = new com.github.andrewoma.dexx.collection.TreeMap(null, (KeyFunction)keyFunction);
        this.hashDexx = com.github.andrewoma.dexx.collection.HashMap.empty();
        this.hashDexxSmart = new DerivedKeyHashMap((KeyFunction)keyFunction);
        this.cljHashMap = PersistentHashMap.emptyMap();
        this.cljTreeMap = PersistentTreeMap.EMPTY;
        this.hashMap = new HashMap<Integer, Integer>();
        this.treeMap = new TreeMap<Integer, Integer>();
        for (Value value : this.data) {
            this.pcollHashMap = this.pcollHashMap.plus((Object)value.key, (Object)value.value);
            this.dexxTreeMap = this.dexxTreeMap.put((Object)value.key, (Object)value.value);
            this.dexxSmartMap = this.dexxSmartMap.put((Object)value.key, (Object)value);
            this.hashDexx = this.hashDexx.put((Object)value.key, (Object)value);
            this.hashDexxSmart = this.hashDexxSmart.put((Object)value.key, (Object)value);
            this.cljHashMap = this.cljHashMap.plus((Object)value.key, (Object)value.value);
            this.cljTreeMap = this.cljTreeMap.plus((Object)value.key, (Object)value.value);
            this.hashMap.put(value.key, value.value);
            this.treeMap.put(value.key, value.value);
        }
    }

    @Benchmark
    public void hashPcoll(Blackhole b) {
        List<Value> data = this.data;
        for (int i = 0; i < data.size(); ++i) {
            Value value = data.get(i);
            b.consume(this.pcollHashMap.get((Object)value.key));
        }
    }

    @Benchmark
    public void treeDexx(Blackhole b) {
        List<Value> data = this.data;
        for (int i = 0; i < data.size(); ++i) {
            Value value = data.get(i);
            b.consume(this.dexxTreeMap.get((Object)value.key));
        }
    }

    @Benchmark
    public void treeDexxSmart(Blackhole b) {
        List<Value> data = this.data;
        for (int i = 0; i < data.size(); ++i) {
            Value value = data.get(i);
            b.consume(this.dexxSmartMap.get((Object)value.key));
        }
    }

    @Benchmark
    public void hashDexx(Blackhole b) {
        List<Value> data = this.data;
        for (int i = 0; i < data.size(); ++i) {
            Value value = data.get(i);
            b.consume(this.hashDexx.get((Object)value.key));
        }
    }

    @Benchmark
    public void hashDexxSmart(Blackhole b) {
        List<Value> data = this.data;
        for (int i = 0; i < data.size(); ++i) {
            Value value = data.get(i);
            b.consume(this.hashDexxSmart.get((Object)value.key));
        }
    }

    @Benchmark
    public void hashClj(Blackhole b) {
        List<Value> data = this.data;
        for (int i = 0; i < data.size(); ++i) {
            Value value = data.get(i);
            b.consume(this.cljHashMap.get((Object)value.key));
        }
    }

    @Benchmark
    public void treeClj(Blackhole b) {
        List<Value> data = this.data;
        for (int i = 0; i < data.size(); ++i) {
            Value value = data.get(i);
            b.consume(this.cljTreeMap.get((Object)value.key));
        }
    }

    @Benchmark
    public void hashBase(Blackhole b) {
        List<Value> data = this.data;
        for (int i = 0; i < data.size(); ++i) {
            Value value = data.get(i);
            b.consume((Object)this.hashMap.get(value.key));
        }
    }

    @Benchmark
    public void treeBase(Blackhole b) {
        List<Value> data = this.data;
        for (int i = 0; i < data.size(); ++i) {
            Value value = data.get(i);
            b.consume((Object)this.treeMap.get(value.key));
        }
    }

    public static class Value {
        int key;
        int value;

        public Value(int key, int value) {
            this.key = key;
            this.value = value;
        }
    }
}

