/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.grid.jcache;

import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import javax.cache.Cache;
import javax.cache.processor.EntryProcessor;

public class CompatibilityTest {
    final Cache<String, Integer> cache;

    public CompatibilityTest(Cache<String, Integer> cache) {
        this.cache = cache;
    }

    public void test() throws InterruptedException {
        String key = "42";
        int threads = 4;
        int iterations = 1000;
        this.cache.put((Object)key, (Object)0);
        CountDownLatch latch = new CountDownLatch(threads);
        for (int i = 0; i < threads; ++i) {
            new Thread(() -> {
                try {
                    for (int j = 0; j < iterations; ++j) {
                        EntryProcessor processor = (EntryProcessor & Serializable)(mutableEntry, objects) -> {
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException e1) {
                                throw new IllegalStateException(e1);
                            }
                            int value = (Integer)mutableEntry.getValue();
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException e) {
                                throw new IllegalStateException(e);
                            }
                            mutableEntry.setValue((Object)(value + 1));
                            return null;
                        };
                        this.cache.invoke((Object)key, processor, new Object[0]);
                    }
                }
                finally {
                    latch.countDown();
                }
            }).start();
        }
        latch.await();
        int value = (Integer)this.cache.get((Object)key);
        if (value != threads * iterations) {
            String msg = "Implementation which you use is not compatible with Bucket4j";
            msg = msg + ", " + (threads * iterations - value) + " writes are missed";
            throw new IllegalStateException(msg);
        }
        System.out.println("Implementation which you use is compatible with Bucket4j");
    }
}

