/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.grid.jcache;

import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.Nothing;
import io.github.bucket4j.grid.CommandResult;
import io.github.bucket4j.grid.GridBucketState;
import io.github.bucket4j.grid.GridCommand;
import io.github.bucket4j.grid.jcache.ExecuteProcessor;
import io.github.bucket4j.grid.jcache.InitStateAndExecuteProcessor;
import io.github.bucket4j.grid.jcache.InitStateProcessor;
import java.io.Serializable;
import javax.cache.processor.EntryProcessor;

public interface JCacheEntryProcessor<K extends Serializable, T extends Serializable>
extends Serializable,
EntryProcessor<K, GridBucketState, CommandResult<T>> {
    public static <K extends Serializable> JCacheEntryProcessor<K, Nothing> initStateProcessor(BucketConfiguration configuration) {
        return new InitStateProcessor(configuration);
    }

    public static <K extends Serializable, T extends Serializable> JCacheEntryProcessor<K, T> executeProcessor(GridCommand<T> targetCommand) {
        return new ExecuteProcessor(targetCommand);
    }

    public static <K extends Serializable, T extends Serializable> JCacheEntryProcessor<K, T> initStateAndExecuteProcessor(GridCommand<T> targetCommand, BucketConfiguration configuration) {
        return new InitStateAndExecuteProcessor(targetCommand, configuration);
    }

    default public long currentTimeNanos() {
        return System.currentTimeMillis() * 1000000L;
    }
}

