/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.grid.jcache;

import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketState;
import io.github.bucket4j.grid.CommandResult;
import io.github.bucket4j.grid.GridBucketState;
import io.github.bucket4j.grid.GridCommand;
import io.github.bucket4j.grid.jcache.JCacheEntryProcessor;
import io.github.bucket4j.serialization.DeserializationAdapter;
import io.github.bucket4j.serialization.SerializationAdapter;
import io.github.bucket4j.serialization.SerializationHandle;
import java.io.IOException;
import java.io.Serializable;
import javax.cache.processor.MutableEntry;

public class InitStateAndExecuteProcessor<K extends Serializable, T extends Serializable>
implements JCacheEntryProcessor<K, T> {
    private static final long serialVersionUID = 1L;
    private GridCommand<T> targetCommand;
    private BucketConfiguration configuration;
    public static SerializationHandle<InitStateAndExecuteProcessor<?, ?>> SERIALIZATION_HANDLE = new SerializationHandle<InitStateAndExecuteProcessor<?, ?>>(){

        public <S> InitStateAndExecuteProcessor<?, ?> deserialize(DeserializationAdapter<S> adapter, S input) throws IOException {
            GridCommand targetCommand = (GridCommand)adapter.readObject(input);
            BucketConfiguration configuration = (BucketConfiguration)adapter.readObject(input, BucketConfiguration.class);
            return new InitStateAndExecuteProcessor(targetCommand, configuration);
        }

        public <O> void serialize(SerializationAdapter<O> adapter, O output, InitStateAndExecuteProcessor<?, ?> processor) throws IOException {
            adapter.writeObject(output, (Object)((InitStateAndExecuteProcessor)processor).targetCommand);
            adapter.writeObject(output, (Object)((InitStateAndExecuteProcessor)processor).configuration);
        }

        public int getTypeId() {
            return 19;
        }

        public Class<InitStateAndExecuteProcessor<?, ?>> getSerializedType() {
            return InitStateAndExecuteProcessor.class;
        }
    };

    public InitStateAndExecuteProcessor(GridCommand<T> targetCommand, BucketConfiguration configuration) {
        this.configuration = configuration;
        this.targetCommand = targetCommand;
    }

    public CommandResult<T> process(MutableEntry<K, GridBucketState> mutableEntry, Object ... arguments) {
        GridBucketState gridBucketState;
        boolean newStateCreated = false;
        long currentTimeNanos = this.currentTimeNanos();
        if (mutableEntry.exists()) {
            gridBucketState = (GridBucketState)mutableEntry.getValue();
        } else {
            BucketState bucketState = BucketState.createInitialState((BucketConfiguration)this.configuration, (long)currentTimeNanos);
            gridBucketState = new GridBucketState(this.configuration, bucketState);
            newStateCreated = true;
        }
        Serializable result = this.targetCommand.execute(gridBucketState, currentTimeNanos);
        if (newStateCreated || this.targetCommand.isBucketStateModified()) {
            mutableEntry.setValue((Object)gridBucketState);
        }
        return CommandResult.success((Serializable)result);
    }

    public GridCommand<T> getTargetCommand() {
        return this.targetCommand;
    }

    public BucketConfiguration getConfiguration() {
        return this.configuration;
    }
}

