/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.grid.jcache;

import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketState;
import io.github.bucket4j.Nothing;
import io.github.bucket4j.grid.CommandResult;
import io.github.bucket4j.grid.GridBucketState;
import io.github.bucket4j.grid.jcache.JCacheEntryProcessor;
import java.io.Serializable;
import javax.cache.processor.MutableEntry;

public class InitStateProcessor<K extends Serializable>
implements JCacheEntryProcessor<K, Nothing> {
    private static final long serialVersionUID = 1L;
    private BucketConfiguration configuration;

    public InitStateProcessor(BucketConfiguration configuration) {
        this.configuration = configuration;
    }

    public CommandResult<Nothing> process(MutableEntry<K, GridBucketState> mutableEntry, Object ... arguments) {
        if (mutableEntry.exists()) {
            return CommandResult.success(null);
        }
        long currentTimeNanos = this.currentTimeNanos();
        BucketState bucketState = BucketState.createInitialState((BucketConfiguration)this.configuration, (long)currentTimeNanos);
        GridBucketState gridBucketState = new GridBucketState(this.configuration, bucketState);
        mutableEntry.setValue((Object)gridBucketState);
        return CommandResult.success(null);
    }
}

