/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.grid.jcache;

import io.github.bucket4j.grid.CommandResult;
import io.github.bucket4j.grid.GridBucketState;
import io.github.bucket4j.grid.GridCommand;
import io.github.bucket4j.grid.GridProxy;
import io.github.bucket4j.grid.jcache.JCacheCommand;
import java.io.Serializable;
import java.util.Objects;
import javax.cache.Cache;

public class JCacheProxy<K extends Serializable>
implements GridProxy<K> {
    private final Cache<K, GridBucketState> cache;

    public JCacheProxy(Cache<K, GridBucketState> cache) {
        this.cache = Objects.requireNonNull(cache);
    }

    public <T extends Serializable> CommandResult<T> execute(K key, GridCommand<T> command) {
        return (CommandResult)this.cache.invoke(key, new JCacheCommand(), new Object[]{command});
    }

    public void setInitialState(K key, GridBucketState initialState) {
        this.cache.putIfAbsent(key, (Object)initialState);
    }
}

