/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.remote;

import io.github.bucket4j.distributed.remote.CommandError;
import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationHandle;
import io.github.bucket4j.distributed.versioning.UsageOfUnsupportedApiException;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;
import io.github.bucket4j.util.ComparableByContent;
import java.io.IOException;

public class UsageOfUnsupportedApiError
implements CommandError,
ComparableByContent<UsageOfUnsupportedApiError> {
    private final int requestedFormatNumber;
    private final int maxSupportedFormatNumber;
    public static SerializationHandle<UsageOfUnsupportedApiError> SERIALIZATION_HANDLE = new SerializationHandle<UsageOfUnsupportedApiError>(){

        @Override
        public <S> UsageOfUnsupportedApiError deserialize(DeserializationAdapter<S> adapter, S input, Version backwardCompatibilityVersion) throws IOException {
            int formatNumber = adapter.readInt(input);
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            int requestedFormatNumber = adapter.readInt(input);
            int minSupportedFormatNumber = adapter.readInt(input);
            return new UsageOfUnsupportedApiError(requestedFormatNumber, minSupportedFormatNumber);
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter, O output, UsageOfUnsupportedApiError error, Version backwardCompatibilityVersion) throws IOException {
            adapter.writeInt(output, Versions.v_7_0_0.getNumber());
            adapter.writeInt(output, error.requestedFormatNumber);
            adapter.writeInt(output, error.maxSupportedFormatNumber);
        }

        @Override
        public int getTypeId() {
            return 18;
        }

        @Override
        public Class<UsageOfUnsupportedApiError> getSerializedType() {
            return UsageOfUnsupportedApiError.class;
        }
    };

    public UsageOfUnsupportedApiError(int requestedFormatNumber, int maxSupportedFormatNumber) {
        this.requestedFormatNumber = requestedFormatNumber;
        this.maxSupportedFormatNumber = maxSupportedFormatNumber;
    }

    public int getRequestedFormatNumber() {
        return this.requestedFormatNumber;
    }

    public int getMaxSupportedFormatNumber() {
        return this.maxSupportedFormatNumber;
    }

    @Override
    public RuntimeException asException() {
        return new UsageOfUnsupportedApiException(this.requestedFormatNumber, this.maxSupportedFormatNumber);
    }

    @Override
    public boolean equalsByContent(UsageOfUnsupportedApiError other) {
        return this.requestedFormatNumber == other.requestedFormatNumber && this.maxSupportedFormatNumber == other.maxSupportedFormatNumber;
    }
}

