/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.local;

import io.github.bucket4j.AbstractBucket;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketState;
import io.github.bucket4j.ConsumptionProbe;
import io.github.bucket4j.IncompatibleConfigurationException;
import io.github.bucket4j.TimeMeter;
import io.github.bucket4j.local.LocalBucket;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class LockFreeBucket
extends AbstractBucket
implements LocalBucket {
    private final TimeMeter timeMeter;
    private static final AtomicReferenceFieldUpdater<LockFreeBucket, StateWithConfiguration> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(LockFreeBucket.class, StateWithConfiguration.class, "state");
    private volatile StateWithConfiguration state;

    public LockFreeBucket(BucketConfiguration configuration, TimeMeter timeMeter) {
        this.timeMeter = timeMeter;
        BucketState initialState = BucketState.createInitialState(configuration, timeMeter.currentTimeNanos());
        STATE_UPDATER.set(this, new StateWithConfiguration(configuration, initialState));
    }

    @Override
    public boolean isAsyncModeSupported() {
        return true;
    }

    @Override
    protected long consumeAsMuchAsPossibleImpl(long limit) {
        StateWithConfiguration previousState = STATE_UPDATER.get(this);
        StateWithConfiguration newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        while (true) {
            newState.refillAllBandwidth(currentTimeNanos);
            long availableToConsume = newState.getAvailableTokens();
            long toConsume = Math.min(limit, availableToConsume);
            if (toConsume == 0L) {
                return 0L;
            }
            newState.consume(toConsume);
            if (STATE_UPDATER.compareAndSet(this, previousState, newState)) {
                return toConsume;
            }
            previousState = STATE_UPDATER.get(this);
            newState.copyStateFrom(previousState);
        }
    }

    @Override
    protected boolean tryConsumeImpl(long tokensToConsume) {
        StateWithConfiguration previousState = STATE_UPDATER.get(this);
        StateWithConfiguration newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        while (true) {
            newState.refillAllBandwidth(currentTimeNanos);
            long availableToConsume = newState.getAvailableTokens();
            if (tokensToConsume > availableToConsume) {
                return false;
            }
            newState.consume(tokensToConsume);
            if (STATE_UPDATER.compareAndSet(this, previousState, newState)) {
                return true;
            }
            previousState = STATE_UPDATER.get(this);
            newState.copyStateFrom(previousState);
        }
    }

    @Override
    protected ConsumptionProbe tryConsumeAndReturnRemainingTokensImpl(long tokensToConsume) {
        StateWithConfiguration previousState = STATE_UPDATER.get(this);
        StateWithConfiguration newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        while (true) {
            newState.refillAllBandwidth(currentTimeNanos);
            long availableToConsume = newState.getAvailableTokens();
            if (tokensToConsume > availableToConsume) {
                long nanosToWaitForRefill = newState.delayNanosAfterWillBePossibleToConsume(tokensToConsume);
                return ConsumptionProbe.rejected(availableToConsume, nanosToWaitForRefill);
            }
            newState.consume(tokensToConsume);
            if (STATE_UPDATER.compareAndSet(this, previousState, newState)) {
                return ConsumptionProbe.consumed(availableToConsume - tokensToConsume);
            }
            previousState = STATE_UPDATER.get(this);
            newState.copyStateFrom(previousState);
        }
    }

    @Override
    protected long reserveAndCalculateTimeToSleepImpl(long tokensToConsume, long waitIfBusyNanosLimit) {
        StateWithConfiguration previousState = STATE_UPDATER.get(this);
        StateWithConfiguration newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        while (true) {
            newState.refillAllBandwidth(currentTimeNanos);
            long nanosToCloseDeficit = newState.delayNanosAfterWillBePossibleToConsume(tokensToConsume);
            if (nanosToCloseDeficit == 0L) {
                newState.consume(tokensToConsume);
                if (STATE_UPDATER.compareAndSet(this, previousState, newState)) {
                    return 0L;
                }
                previousState = STATE_UPDATER.get(this);
                newState.copyStateFrom(previousState);
                continue;
            }
            if (nanosToCloseDeficit == Long.MAX_VALUE || nanosToCloseDeficit > waitIfBusyNanosLimit) {
                return Long.MAX_VALUE;
            }
            newState.consume(tokensToConsume);
            if (STATE_UPDATER.compareAndSet(this, previousState, newState)) {
                return nanosToCloseDeficit;
            }
            previousState = STATE_UPDATER.get(this);
            newState.copyStateFrom(previousState);
        }
    }

    @Override
    protected void addTokensImpl(long tokensToAdd) {
        StateWithConfiguration previousState = STATE_UPDATER.get(this);
        StateWithConfiguration newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        while (true) {
            newState.refillAllBandwidth(currentTimeNanos);
            newState.state.addTokens(newState.configuration.getBandwidths(), tokensToAdd);
            if (STATE_UPDATER.compareAndSet(this, previousState, newState)) {
                return;
            }
            previousState = STATE_UPDATER.get(this);
            newState.copyStateFrom(previousState);
        }
    }

    @Override
    protected void replaceConfigurationImpl(BucketConfiguration newConfiguration) {
        StateWithConfiguration previousState = STATE_UPDATER.get(this);
        StateWithConfiguration newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        while (true) {
            previousState.configuration.checkCompatibility(newConfiguration);
            newState.refillAllBandwidth(currentTimeNanos);
            newState.configuration = newConfiguration;
            if (STATE_UPDATER.compareAndSet(this, previousState, newState)) {
                return;
            }
            previousState = STATE_UPDATER.get(this);
            newState.copyStateFrom(previousState);
        }
    }

    @Override
    public long getAvailableTokens() {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        StateWithConfiguration snapshot = STATE_UPDATER.get(this).copy();
        snapshot.refillAllBandwidth(currentTimeNanos);
        return snapshot.getAvailableTokens();
    }

    @Override
    protected CompletableFuture<Boolean> tryConsumeAsyncImpl(long tokensToConsume) {
        boolean result = this.tryConsumeImpl(tokensToConsume);
        return CompletableFuture.completedFuture(result);
    }

    @Override
    protected CompletableFuture<Void> addTokensAsyncImpl(long tokensToAdd) {
        this.addTokensImpl(tokensToAdd);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    protected CompletableFuture<Void> replaceConfigurationAsyncImpl(BucketConfiguration newConfiguration) {
        try {
            this.replaceConfigurationImpl(newConfiguration);
            return CompletableFuture.completedFuture(null);
        }
        catch (IncompatibleConfigurationException e) {
            CompletableFuture<Void> fail = new CompletableFuture<Void>();
            fail.completeExceptionally(e);
            return fail;
        }
    }

    @Override
    protected CompletableFuture<ConsumptionProbe> tryConsumeAndReturnRemainingTokensAsyncImpl(long tokensToConsume) {
        ConsumptionProbe result = this.tryConsumeAndReturnRemainingTokensImpl(tokensToConsume);
        return CompletableFuture.completedFuture(result);
    }

    @Override
    protected CompletableFuture<Long> tryConsumeAsMuchAsPossibleAsyncImpl(long limit) {
        long result = this.tryConsumeAsMuchAsPossible(limit);
        return CompletableFuture.completedFuture(result);
    }

    @Override
    protected CompletableFuture<Long> reserveAndCalculateTimeToSleepAsyncImpl(long tokensToConsume, long maxWaitTimeNanos) {
        long result = this.reserveAndCalculateTimeToSleepImpl(tokensToConsume, maxWaitTimeNanos);
        return CompletableFuture.completedFuture(result);
    }

    @Override
    public BucketState createSnapshot() {
        return LockFreeBucket.STATE_UPDATER.get((LockFreeBucket)this).state.copy();
    }

    @Override
    public BucketConfiguration getConfiguration() {
        return LockFreeBucket.STATE_UPDATER.get((LockFreeBucket)this).configuration;
    }

    public String toString() {
        return "LockFreeBucket{state=" + STATE_UPDATER.get(this) + ", configuration=" + this.getConfiguration() + '}';
    }

    private static class StateWithConfiguration {
        BucketConfiguration configuration;
        BucketState state;

        StateWithConfiguration(BucketConfiguration configuration, BucketState state) {
            this.configuration = configuration;
            this.state = state;
        }

        StateWithConfiguration copy() {
            return new StateWithConfiguration(this.configuration, this.state.copy());
        }

        void copyStateFrom(StateWithConfiguration other) {
            this.configuration = other.configuration;
            this.state.copyStateFrom(other.state);
        }

        void refillAllBandwidth(long currentTimeNanos) {
            this.state.refillAllBandwidth(this.configuration.getBandwidths(), currentTimeNanos);
        }

        long getAvailableTokens() {
            return this.state.getAvailableTokens(this.configuration.getBandwidths());
        }

        void consume(long tokensToConsume) {
            this.state.consume(this.configuration.getBandwidths(), tokensToConsume);
        }

        long delayNanosAfterWillBePossibleToConsume(long tokensToConsume) {
            return this.state.delayNanosAfterWillBePossibleToConsume(this.configuration.getBandwidths(), tokensToConsume);
        }
    }
}

