/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j;

import io.github.bucket4j.BucketExceptions;
import io.github.bucket4j.Refill;
import java.io.Serializable;
import java.time.Duration;

public class Bandwidth
implements Serializable {
    private static final long serialVersionUID = 42L;
    final long capacity;
    final Refill refill;

    private Bandwidth(long capacity, Refill refill) {
        if (capacity <= 0L) {
            throw BucketExceptions.nonPositiveCapacity(capacity);
        }
        if (refill == null) {
            throw BucketExceptions.nullBandwidthRefill();
        }
        this.capacity = capacity;
        this.refill = refill;
    }

    public static Bandwidth simple(long capacity, Duration period) {
        Refill refill = Refill.smooth(capacity, period);
        return Bandwidth.classic(capacity, refill);
    }

    public static Bandwidth classic(long capacity, Refill refill) {
        return new Bandwidth(capacity, refill);
    }

    public long getCapacity() {
        return this.capacity;
    }

    public Refill getRefill() {
        return this.refill;
    }

    public String toString() {
        return "Bandwidth{capacity=" + this.capacity + ", refill=" + this.refill + '}';
    }
}

