/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j;

import io.github.bucket4j.AsyncBucket;
import io.github.bucket4j.BlockingStrategy;
import io.github.bucket4j.Bucket;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketExceptions;
import io.github.bucket4j.ConsumptionProbe;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public abstract class AbstractBucket
implements Bucket {
    private final AsyncBucket asyncView = new AsyncBucket(){

        @Override
        public CompletableFuture<Boolean> tryConsume(long tokensToConsume) {
            AbstractBucket.checkTokensToConsume(tokensToConsume);
            return AbstractBucket.this.tryConsumeAsyncImpl(tokensToConsume);
        }

        @Override
        public CompletableFuture<ConsumptionProbe> tryConsumeAndReturnRemaining(long tokensToConsume) {
            AbstractBucket.checkTokensToConsume(tokensToConsume);
            return AbstractBucket.this.tryConsumeAndReturnRemainingTokensAsyncImpl(tokensToConsume);
        }

        @Override
        public CompletableFuture<Long> tryConsumeAsMuchAsPossible() {
            return AbstractBucket.this.tryConsumeAsMuchAsPossibleAsyncImpl(Long.MAX_VALUE);
        }

        @Override
        public CompletableFuture<Long> tryConsumeAsMuchAsPossible(long limit) {
            AbstractBucket.checkTokensToConsume(limit);
            return AbstractBucket.this.tryConsumeAsMuchAsPossibleAsyncImpl(limit);
        }

        @Override
        public CompletableFuture<Boolean> tryConsume(long tokensToConsume, long maxWaitTimeNanos, ScheduledExecutorService scheduler) {
            AbstractBucket.checkMaxWaitTime(maxWaitTimeNanos);
            AbstractBucket.checkTokensToConsume(tokensToConsume);
            AbstractBucket.checkScheduler(scheduler);
            CompletableFuture<Boolean> resultFuture = new CompletableFuture<Boolean>();
            CompletableFuture<Long> reservationFuture = AbstractBucket.this.reserveAndCalculateTimeToSleepAsyncImpl(tokensToConsume, maxWaitTimeNanos);
            reservationFuture.whenComplete((nanosToSleep, exception) -> {
                if (exception != null) {
                    resultFuture.completeExceptionally((Throwable)exception);
                    return;
                }
                if (nanosToSleep == Long.MAX_VALUE) {
                    resultFuture.complete(false);
                    return;
                }
                if (nanosToSleep == 0L) {
                    resultFuture.complete(true);
                    return;
                }
                try {
                    Runnable delayedCompletion = () -> resultFuture.complete(true);
                    scheduler.schedule(delayedCompletion, (long)nanosToSleep, TimeUnit.NANOSECONDS);
                }
                catch (Throwable t) {
                    resultFuture.completeExceptionally(t);
                }
            });
            return resultFuture;
        }

        @Override
        public CompletableFuture<Void> replaceConfiguration(BucketConfiguration newConfiguration) {
            AbstractBucket.checkConfiguration(newConfiguration);
            return AbstractBucket.this.replaceConfigurationAsyncImpl(newConfiguration);
        }

        @Override
        public CompletableFuture<Void> addTokens(long tokensToAdd) {
            AbstractBucket.checkTokensToAdd(tokensToAdd);
            return AbstractBucket.this.addTokensAsyncImpl(tokensToAdd);
        }
    };

    protected abstract long consumeAsMuchAsPossibleImpl(long var1);

    protected abstract boolean tryConsumeImpl(long var1);

    protected abstract ConsumptionProbe tryConsumeAndReturnRemainingTokensImpl(long var1);

    protected abstract long reserveAndCalculateTimeToSleepImpl(long var1, long var3);

    protected abstract void addTokensImpl(long var1);

    protected abstract CompletableFuture<Long> tryConsumeAsMuchAsPossibleAsyncImpl(long var1);

    protected abstract CompletableFuture<Boolean> tryConsumeAsyncImpl(long var1);

    protected abstract CompletableFuture<ConsumptionProbe> tryConsumeAndReturnRemainingTokensAsyncImpl(long var1);

    protected abstract CompletableFuture<Long> reserveAndCalculateTimeToSleepAsyncImpl(long var1, long var3);

    protected abstract CompletableFuture<Void> addTokensAsyncImpl(long var1);

    protected abstract void replaceConfigurationImpl(BucketConfiguration var1);

    protected abstract CompletableFuture<Void> replaceConfigurationAsyncImpl(BucketConfiguration var1);

    @Override
    public AsyncBucket asAsync() {
        if (!this.isAsyncModeSupported()) {
            throw new UnsupportedOperationException();
        }
        return this.asyncView;
    }

    @Override
    public boolean tryConsume(long tokensToConsume) {
        AbstractBucket.checkTokensToConsume(tokensToConsume);
        return this.tryConsumeImpl(tokensToConsume);
    }

    @Override
    public boolean tryConsume(long tokensToConsume, long maxWaitTimeNanos, BlockingStrategy blockingStrategy) throws InterruptedException {
        AbstractBucket.checkTokensToConsume(tokensToConsume);
        AbstractBucket.checkMaxWaitTime(maxWaitTimeNanos);
        long nanosToSleep = this.reserveAndCalculateTimeToSleepImpl(tokensToConsume, maxWaitTimeNanos);
        if (nanosToSleep == Long.MAX_VALUE) {
            return false;
        }
        if (nanosToSleep > 0L) {
            blockingStrategy.park(nanosToSleep);
        }
        return true;
    }

    @Override
    public boolean tryConsumeUninterruptibly(long tokensToConsume, long maxWaitTimeNanos, BlockingStrategy blockingStrategy) {
        AbstractBucket.checkTokensToConsume(tokensToConsume);
        AbstractBucket.checkMaxWaitTime(maxWaitTimeNanos);
        long nanosToSleep = this.reserveAndCalculateTimeToSleepImpl(tokensToConsume, maxWaitTimeNanos);
        if (nanosToSleep == Long.MAX_VALUE) {
            return false;
        }
        if (nanosToSleep > 0L) {
            blockingStrategy.parkUninterruptibly(nanosToSleep);
        }
        return true;
    }

    @Override
    public long tryConsumeAsMuchAsPossible(long limit) {
        AbstractBucket.checkTokensToConsume(limit);
        return this.consumeAsMuchAsPossibleImpl(limit);
    }

    @Override
    public long tryConsumeAsMuchAsPossible() {
        return this.consumeAsMuchAsPossibleImpl(Long.MAX_VALUE);
    }

    @Override
    public ConsumptionProbe tryConsumeAndReturnRemaining(long tokensToConsume) {
        AbstractBucket.checkTokensToConsume(tokensToConsume);
        return this.tryConsumeAndReturnRemainingTokensImpl(tokensToConsume);
    }

    @Override
    public void addTokens(long tokensToAdd) {
        AbstractBucket.checkTokensToAdd(tokensToAdd);
        this.addTokensImpl(tokensToAdd);
    }

    @Override
    public void replaceConfiguration(BucketConfiguration newConfiguration) {
        AbstractBucket.checkConfiguration(newConfiguration);
        this.replaceConfigurationImpl(newConfiguration);
    }

    private static void checkTokensToAdd(long tokensToAdd) {
        if (tokensToAdd <= 0L) {
            throw new IllegalArgumentException("tokensToAdd should be >= 0");
        }
    }

    private static void checkTokensToConsume(long tokensToConsume) {
        if (tokensToConsume <= 0L) {
            throw BucketExceptions.nonPositiveTokensToConsume(tokensToConsume);
        }
    }

    private static void checkMaxWaitTime(long maxWaitTimeNanos) {
        if (maxWaitTimeNanos <= 0L) {
            throw BucketExceptions.nonPositiveNanosToWait(maxWaitTimeNanos);
        }
    }

    private static void checkScheduler(ScheduledExecutorService scheduler) {
        if (scheduler == null) {
            throw BucketExceptions.nullScheduler();
        }
    }

    private static void checkConfiguration(BucketConfiguration newConfiguration) {
        if (newConfiguration == null) {
            throw BucketExceptions.nullConfiguration();
        }
    }
}

