/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j;

import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.BucketConfiguration;
import java.io.Serializable;
import java.util.Arrays;

public class BucketState
implements Serializable {
    private static final int LAST_REFILL_TIME_OFFSET = 0;
    final long[] stateData;

    BucketState(long[] stateData) {
        this.stateData = stateData;
    }

    public BucketState(BucketConfiguration configuration) {
        Bandwidth[] bandwidths = configuration.getBandwidths();
        long[] bandwidthsInitialTokens = configuration.getBandwidthsInitialTokens();
        this.stateData = new long[1 + bandwidths.length * 2];
        long currentTimeNanos = configuration.getTimeMeter().currentTimeNanos();
        for (int i = 0; i < bandwidths.length; ++i) {
            Bandwidth bandwidth = bandwidths[i];
            long initialTokens = bandwidthsInitialTokens[i];
            if (initialTokens == -1L) {
                initialTokens = bandwidth.capacity;
            }
            this.setCurrentSize(i, initialTokens);
        }
        this.setLastRefillTimeNanos(currentTimeNanos);
    }

    public BucketState copy() {
        return new BucketState((long[])this.stateData.clone());
    }

    public void copyStateFrom(BucketState sourceState) {
        System.arraycopy(sourceState.stateData, 0, this.stateData, 0, this.stateData.length);
    }

    public static BucketState createInitialState(BucketConfiguration configuration) {
        return new BucketState(configuration);
    }

    public long getAvailableTokens(Bandwidth[] bandwidths) {
        long availableTokens = this.getCurrentSize(0);
        for (int i = 1; i < bandwidths.length; ++i) {
            availableTokens = Math.min(availableTokens, this.getCurrentSize(i));
        }
        return availableTokens;
    }

    public void consume(Bandwidth[] bandwidths, long toConsume) {
        for (int i = 0; i < bandwidths.length; ++i) {
            this.consume(i, toConsume);
        }
    }

    public long delayNanosAfterWillBePossibleToConsume(Bandwidth[] bandwidths, long tokensToConsume) {
        long delayAfterWillBePossibleToConsume = this.delayNanosAfterWillBePossibleToConsume(0, bandwidths[0], tokensToConsume);
        for (int i = 1; i < bandwidths.length; ++i) {
            Bandwidth bandwidth = bandwidths[i];
            long delay = this.delayNanosAfterWillBePossibleToConsume(i, bandwidth, tokensToConsume);
            if (delay <= (delayAfterWillBePossibleToConsume = Math.max(delayAfterWillBePossibleToConsume, delay))) continue;
            delayAfterWillBePossibleToConsume = delay;
        }
        return delayAfterWillBePossibleToConsume;
    }

    public void refillAllBandwidth(Bandwidth[] limits, long currentTimeNanos) {
        long lastRefillTimeNanos = this.getLastRefillTimeNanos();
        if (currentTimeNanos <= lastRefillTimeNanos) {
            return;
        }
        for (int i = 0; i < limits.length; ++i) {
            this.refill(i, limits[i], lastRefillTimeNanos, currentTimeNanos);
        }
        this.setLastRefillTimeNanos(currentTimeNanos);
    }

    public void addTokens(Bandwidth[] limits, long tokensToAdd) {
        for (int i = 0; i < limits.length; ++i) {
            this.addTokens(i, limits[i], tokensToAdd);
        }
    }

    private void addTokens(int bandwidthIndex, Bandwidth bandwidth, long tokensToAdd) {
        long currentSize = this.getCurrentSize(bandwidthIndex);
        long newSize = currentSize + tokensToAdd;
        if (newSize >= bandwidth.capacity) {
            this.resetBandwidth(bandwidthIndex, bandwidth.capacity);
        } else if (newSize < currentSize) {
            this.resetBandwidth(bandwidthIndex, bandwidth.capacity);
        } else {
            this.setCurrentSize(bandwidthIndex, newSize);
        }
    }

    private void consume(int bandwidth, long tokens) {
        int n = 1 + bandwidth * 2;
        this.stateData[n] = this.stateData[n] - tokens;
    }

    private void refill(int bandwidthIndex, Bandwidth bandwidth, long previousRefillNanos, long currentTimeNanos) {
        long capacity = bandwidth.capacity;
        long refillPeriodNanos = bandwidth.refill.getPeriodNanos();
        long refillTokens = bandwidth.refill.getTokens();
        long currentSize = this.getCurrentSize(bandwidthIndex);
        long durationSinceLastRefillNanos = currentTimeNanos - previousRefillNanos;
        long newSize = currentSize;
        if (durationSinceLastRefillNanos > refillPeriodNanos) {
            long elapsedPeriods = durationSinceLastRefillNanos / refillPeriodNanos;
            long calculatedRefill = elapsedPeriods * refillTokens;
            if ((newSize += calculatedRefill) > capacity) {
                this.resetBandwidth(bandwidthIndex, capacity);
                return;
            }
            if (newSize < currentSize) {
                this.resetBandwidth(bandwidthIndex, capacity);
                return;
            }
            durationSinceLastRefillNanos %= refillPeriodNanos;
        }
        long roundingError = this.getRoundingError(bandwidthIndex);
        long dividedWithoutError = BucketState.multiplyExactOrReturnMaxValue(refillTokens, durationSinceLastRefillNanos);
        long divided = dividedWithoutError + roundingError;
        if (divided < 0L || dividedWithoutError == Long.MAX_VALUE) {
            long calculatedRefill = (long)((double)durationSinceLastRefillNanos / (double)refillPeriodNanos * (double)refillTokens);
            newSize += calculatedRefill;
            roundingError = 0L;
        } else {
            long calculatedRefill = divided / refillPeriodNanos;
            if (calculatedRefill == 0L) {
                roundingError = divided;
            } else {
                newSize += calculatedRefill;
                roundingError = divided % refillPeriodNanos;
            }
        }
        if (newSize >= capacity) {
            this.resetBandwidth(bandwidthIndex, capacity);
            return;
        }
        if (newSize < currentSize) {
            this.resetBandwidth(bandwidthIndex, capacity);
            return;
        }
        this.setCurrentSize(bandwidthIndex, newSize);
        this.setRoundingError(bandwidthIndex, roundingError);
    }

    private void resetBandwidth(int bandwidthIndex, long capacity) {
        this.setCurrentSize(bandwidthIndex, capacity);
        this.setRoundingError(bandwidthIndex, 0L);
    }

    private long delayNanosAfterWillBePossibleToConsume(int bandwidthIndex, Bandwidth bandwidth, long tokens) {
        long currentSize = this.getCurrentSize(bandwidthIndex);
        if (tokens <= currentSize) {
            return 0L;
        }
        long deficit = tokens - currentSize;
        if (deficit <= 0L) {
            return Long.MAX_VALUE;
        }
        long refillPeriodNanos = bandwidth.refill.getPeriodNanos();
        long refillPeriodTokens = bandwidth.refill.getTokens();
        long divided = BucketState.multiplyExactOrReturnMaxValue(refillPeriodNanos, deficit);
        if (divided == Long.MAX_VALUE) {
            return (long)((double)deficit / (double)refillPeriodTokens * (double)refillPeriodNanos);
        }
        return divided / refillPeriodTokens;
    }

    long getCurrentSize(int bandwidth) {
        return this.stateData[1 + bandwidth * 2];
    }

    long getRoundingError(int bandwidth) {
        return this.stateData[2 + bandwidth * 2];
    }

    private void setCurrentSize(int bandwidth, long currentSize) {
        this.stateData[1 + bandwidth * 2] = currentSize;
    }

    private void setRoundingError(int bandwidth, long roundingError) {
        this.stateData[2 + bandwidth * 2] = roundingError;
    }

    private long getLastRefillTimeNanos() {
        return this.stateData[0];
    }

    private void setLastRefillTimeNanos(long nanos) {
        this.stateData[0] = nanos;
    }

    public String toString() {
        return "BucketState{, bandwidthStates=" + Arrays.toString(this.stateData) + '}';
    }

    private static long multiplyExactOrReturnMaxValue(long x, long y) {
        long ay;
        long r = x * y;
        long ax = Math.abs(x);
        if ((ax | (ay = Math.abs(y))) >>> 31 != 0L && (y != 0L && r / y != x || x == Long.MIN_VALUE && y == -1L)) {
            return Long.MAX_VALUE;
        }
        return r;
    }
}

