/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.grid;

import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketState;
import io.github.bucket4j.grid.GridBucketState;
import io.github.bucket4j.grid.GridCommand;

public class ReserveAndCalculateTimeToSleepCommand
implements GridCommand<Long> {
    private long tokensToConsume;
    private long waitIfBusyNanosLimit;
    private boolean bucketStateModified;

    public ReserveAndCalculateTimeToSleepCommand(long tokensToConsume, long waitIfBusyNanosLimit) {
        this.tokensToConsume = tokensToConsume;
        this.waitIfBusyNanosLimit = waitIfBusyNanosLimit;
    }

    @Override
    public Long execute(GridBucketState gridState) {
        BucketConfiguration configuration = gridState.getBucketConfiguration();
        BucketState state = gridState.getBucketState();
        long currentTimeNanos = configuration.getTimeMeter().currentTimeNanos();
        Bandwidth[] bandwidths = configuration.getBandwidths();
        state.refillAllBandwidth(bandwidths, currentTimeNanos);
        long nanosToCloseDeficit = state.delayNanosAfterWillBePossibleToConsume(bandwidths, this.tokensToConsume);
        if (this.waitIfBusyNanosLimit > 0L && nanosToCloseDeficit > this.waitIfBusyNanosLimit) {
            return Long.MAX_VALUE;
        }
        state.consume(bandwidths, this.tokensToConsume);
        this.bucketStateModified = true;
        return nanosToCloseDeficit;
    }

    @Override
    public boolean isBucketStateModified() {
        return this.bucketStateModified;
    }
}

