/*
 * Decompiled with CFR 0.152.
 */
package com.github.vipulasri.timelineview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import com.github.vipulasri.timelineview.R;
import com.github.vipulasri.timelineview.Utils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class TimelineView
extends View {
    public static final String TAG = TimelineView.class.getSimpleName();
    private Drawable mMarker;
    private int mMarkerSize;
    private int mMarkerPaddingLeft;
    private int mMarkerPaddingTop;
    private int mMarkerPaddingRight;
    private int mMarkerPaddingBottom;
    private boolean mMarkerInCenter;
    private Paint mLinePaint = new Paint();
    private boolean mDrawStartLine = false;
    private boolean mDrawEndLine = false;
    private float mStartLineStartX;
    private float mStartLineStartY;
    private float mStartLineStopX;
    private float mStartLineStopY;
    private float mEndLineStartX;
    private float mEndLineStartY;
    private float mEndLineStopX;
    private float mEndLineStopY;
    private int mStartLineColor;
    private int mEndLineColor;
    private int mLineWidth;
    private int mLineOrientation;
    private int mLineStyle;
    private int mLineStyleDashLength;
    private int mLineStyleDashGap;
    private int mLinePadding;
    private Rect mBounds;

    public TimelineView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.TimelineView);
        this.mMarker = typedArray.getDrawable(R.styleable.TimelineView_marker);
        this.mMarkerSize = typedArray.getDimensionPixelSize(R.styleable.TimelineView_markerSize, Utils.dpToPx(20.0f, this.getContext()));
        this.mMarkerPaddingLeft = typedArray.getDimensionPixelSize(R.styleable.TimelineView_markerPaddingLeft, 0);
        this.mMarkerPaddingTop = typedArray.getDimensionPixelSize(R.styleable.TimelineView_markerPaddingTop, 0);
        this.mMarkerPaddingRight = typedArray.getDimensionPixelSize(R.styleable.TimelineView_markerPaddingRight, 0);
        this.mMarkerPaddingBottom = typedArray.getDimensionPixelSize(R.styleable.TimelineView_markerPaddingBottom, 0);
        this.mMarkerInCenter = typedArray.getBoolean(R.styleable.TimelineView_markerInCenter, true);
        this.mStartLineColor = typedArray.getColor(R.styleable.TimelineView_startLineColor, this.getResources().getColor(0x1060000));
        this.mEndLineColor = typedArray.getColor(R.styleable.TimelineView_endLineColor, this.getResources().getColor(0x1060000));
        this.mLineWidth = typedArray.getDimensionPixelSize(R.styleable.TimelineView_lineWidth, Utils.dpToPx(2.0f, this.getContext()));
        this.mLineOrientation = typedArray.getInt(R.styleable.TimelineView_lineOrientation, 1);
        this.mLinePadding = typedArray.getDimensionPixelSize(R.styleable.TimelineView_linePadding, 0);
        this.mLineStyle = typedArray.getInt(R.styleable.TimelineView_lineStyle, 0);
        this.mLineStyleDashLength = typedArray.getDimensionPixelSize(R.styleable.TimelineView_lineStyleDashLength, Utils.dpToPx(8.0f, this.getContext()));
        this.mLineStyleDashGap = typedArray.getDimensionPixelSize(R.styleable.TimelineView_lineStyleDashGap, Utils.dpToPx(4.0f, this.getContext()));
        typedArray.recycle();
        if (this.isInEditMode()) {
            this.mDrawStartLine = true;
            this.mDrawEndLine = true;
        }
        if (this.mMarker == null) {
            this.mMarker = this.getResources().getDrawable(R.drawable.marker);
        }
        this.initTimeline();
        this.initLinePaint();
        this.setLayerType(1, null);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int w = this.mMarkerSize + this.getPaddingLeft() + this.getPaddingRight();
        int h = this.mMarkerSize + this.getPaddingTop() + this.getPaddingBottom();
        int widthSize = TimelineView.resolveSizeAndState((int)w, (int)widthMeasureSpec, (int)0);
        int heightSize = TimelineView.resolveSizeAndState((int)h, (int)heightMeasureSpec, (int)0);
        this.setMeasuredDimension(widthSize, heightSize);
        this.initTimeline();
    }

    protected void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        super.onSizeChanged(width, height, oldWidth, oldHeight);
        this.initTimeline();
    }

    private void initTimeline() {
        int pLeft = this.getPaddingLeft();
        int pRight = this.getPaddingRight();
        int pTop = this.getPaddingTop();
        int pBottom = this.getPaddingBottom();
        int width = this.getWidth();
        int height = this.getHeight();
        int cWidth = width - pLeft - pRight;
        int cHeight = height - pTop - pBottom;
        int markSize = Math.min(this.mMarkerSize, Math.min(cWidth, cHeight));
        if (this.mMarkerInCenter) {
            int left = width / 2 - markSize / 2;
            int top = height / 2 - markSize / 2;
            int right = width / 2 + markSize / 2;
            int bottom = height / 2 + markSize / 2;
            switch (this.mLineOrientation) {
                case 0: {
                    left += this.mMarkerPaddingLeft - this.mMarkerPaddingRight;
                    right += this.mMarkerPaddingLeft - this.mMarkerPaddingRight;
                    break;
                }
                case 1: {
                    top += this.mMarkerPaddingTop - this.mMarkerPaddingBottom;
                    bottom += this.mMarkerPaddingTop - this.mMarkerPaddingBottom;
                }
            }
            if (this.mMarker != null) {
                this.mMarker.setBounds(left, top, right, bottom);
                this.mBounds = this.mMarker.getBounds();
            }
        } else {
            int left = pLeft;
            int top = pTop;
            int right = pLeft + markSize;
            int bottom = pTop;
            switch (this.mLineOrientation) {
                case 0: {
                    top = height / 2 - markSize / 2;
                    bottom = height / 2 + markSize / 2;
                    left += this.mMarkerPaddingLeft - this.mMarkerPaddingRight;
                    right += this.mMarkerPaddingLeft - this.mMarkerPaddingRight;
                    break;
                }
                case 1: {
                    top += this.mMarkerPaddingTop - this.mMarkerPaddingBottom;
                    bottom += markSize + this.mMarkerPaddingTop - this.mMarkerPaddingBottom;
                }
            }
            if (this.mMarker != null) {
                this.mMarker.setBounds(left, top, right, bottom);
                this.mBounds = this.mMarker.getBounds();
            }
        }
        if (this.mLineOrientation == 0) {
            if (this.mDrawStartLine) {
                this.mStartLineStartX = pLeft;
                this.mStartLineStartY = this.mBounds.centerY();
                this.mStartLineStopX = this.mBounds.left - this.mLinePadding;
                this.mStartLineStopY = this.mBounds.centerY();
            }
            if (this.mDrawEndLine) {
                if (this.mLineStyle == 1) {
                    this.mEndLineStartX = this.getWidth() - this.mLineStyleDashGap;
                    this.mEndLineStartY = this.mBounds.centerY();
                    this.mEndLineStopX = this.mBounds.right + this.mLinePadding;
                    this.mEndLineStopY = this.mBounds.centerY();
                } else {
                    this.mEndLineStartX = this.mBounds.right + this.mLinePadding;
                    this.mEndLineStartY = this.mBounds.centerY();
                    this.mEndLineStopX = this.getWidth();
                    this.mEndLineStopY = this.mBounds.centerY();
                }
            }
        } else {
            if (this.mDrawStartLine) {
                this.mStartLineStartX = this.mBounds.centerX();
                this.mStartLineStartY = pTop;
                this.mStartLineStopX = this.mBounds.centerX();
                this.mStartLineStopY = this.mBounds.top - this.mLinePadding;
            }
            if (this.mDrawEndLine) {
                if (this.mLineStyle == 1) {
                    this.mEndLineStartX = this.mBounds.centerX();
                    this.mEndLineStartY = this.getHeight() - this.mLineStyleDashGap;
                    this.mEndLineStopX = this.mBounds.centerX();
                    this.mEndLineStopY = this.mBounds.bottom + this.mLinePadding;
                } else {
                    this.mEndLineStartX = this.mBounds.centerX();
                    this.mEndLineStartY = this.mBounds.bottom + this.mLinePadding;
                    this.mEndLineStopX = this.mBounds.centerX();
                    this.mEndLineStopY = this.getHeight();
                }
            }
        }
        this.invalidate();
    }

    private void initLinePaint() {
        this.mLinePaint.setAlpha(0);
        this.mLinePaint.setAntiAlias(true);
        this.mLinePaint.setColor(this.mStartLineColor);
        this.mLinePaint.setStyle(Paint.Style.STROKE);
        this.mLinePaint.setStrokeWidth((float)this.mLineWidth);
        if (this.mLineStyle == 1) {
            this.mLinePaint.setPathEffect((PathEffect)new DashPathEffect(new float[]{this.mLineStyleDashLength, this.mLineStyleDashGap}, 0.0f));
        } else {
            this.mLinePaint.setPathEffect(new PathEffect());
        }
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mMarker != null) {
            this.mMarker.draw(canvas);
        }
        if (this.mDrawStartLine) {
            this.mLinePaint.setColor(this.mStartLineColor);
            canvas.drawLine(this.mStartLineStartX, this.mStartLineStartY, this.mStartLineStopX, this.mStartLineStopY, this.mLinePaint);
        }
        if (this.mDrawEndLine) {
            this.mLinePaint.setColor(this.mEndLineColor);
            canvas.drawLine(this.mEndLineStartX, this.mEndLineStartY, this.mEndLineStopX, this.mEndLineStopY, this.mLinePaint);
        }
    }

    public void setMarker(Drawable marker) {
        this.mMarker = marker;
        this.initTimeline();
    }

    public Drawable getMarker() {
        return this.mMarker;
    }

    public void setMarker(Drawable marker, int color2) {
        this.mMarker = marker;
        this.mMarker.setColorFilter(color2, PorterDuff.Mode.SRC_ATOP);
        this.initTimeline();
    }

    public void setMarkerColor(int color2) {
        this.mMarker.setColorFilter(color2, PorterDuff.Mode.SRC_ATOP);
        this.initTimeline();
    }

    public void setStartLineColor(int color2, int viewType) {
        this.mStartLineColor = color2;
        this.initLine(viewType);
    }

    public int getStartLineColor() {
        return this.mStartLineColor;
    }

    public void setEndLineColor(int color2, int viewType) {
        this.mEndLineColor = color2;
        this.initLine(viewType);
    }

    public int getEndLineColor() {
        return this.mEndLineColor;
    }

    public void setMarkerSize(int markerSize) {
        this.mMarkerSize = markerSize;
        this.initTimeline();
    }

    public int getMarkerSize() {
        return this.mMarkerSize;
    }

    public void setMarkerPaddingLeft(int markerPaddingLeft) {
        this.mMarkerPaddingLeft = markerPaddingLeft;
        this.initTimeline();
    }

    public int getMarkerPaddingLeft() {
        return this.mMarkerPaddingLeft;
    }

    public void setMarkerPaddingTop(int markerPaddingTop) {
        this.mMarkerPaddingTop = markerPaddingTop;
        this.initTimeline();
    }

    public int getMarkerPaddingTop() {
        return this.mMarkerPaddingTop;
    }

    public void setMarkerPaddingRight(int markerPaddingRight) {
        this.mMarkerPaddingRight = markerPaddingRight;
        this.initTimeline();
    }

    public int getMarkerPaddingRight() {
        return this.mMarkerPaddingRight;
    }

    public void setMarkerPaddingBottom(int markerPaddingBottom) {
        this.mMarkerPaddingBottom = markerPaddingBottom;
        this.initTimeline();
    }

    public int getMarkerPaddingBottom() {
        return this.mMarkerPaddingBottom;
    }

    public boolean isMarkerInCenter() {
        return this.mMarkerInCenter;
    }

    public void setMarkerInCenter(boolean markerInCenter) {
        this.mMarkerInCenter = markerInCenter;
        this.initTimeline();
    }

    public void setLineWidth(int lineWidth) {
        this.mLineWidth = lineWidth;
        this.initTimeline();
    }

    public int getLineWidth() {
        return this.mLineWidth;
    }

    public void setLinePadding(int padding) {
        this.mLinePadding = padding;
        this.initTimeline();
    }

    public int getLineOrientation() {
        return this.mLineOrientation;
    }

    public void setLineOrientation(int lineOrientation) {
        this.mLineOrientation = lineOrientation;
    }

    public int getLineStyle() {
        return this.mLineStyle;
    }

    public void setLineStyle(int lineStyle) {
        this.mLineStyle = lineStyle;
        this.initLinePaint();
    }

    public int getLineStyleDashLength() {
        return this.mLineStyleDashLength;
    }

    public void setLineStyleDashLength(int lineStyleDashLength) {
        this.mLineStyleDashLength = lineStyleDashLength;
        this.initLinePaint();
    }

    public int getLineStyleDashGap() {
        return this.mLineStyleDashGap;
    }

    public void setLineStyleDashGap(int lineStyleDashGap) {
        this.mLineStyleDashGap = lineStyleDashGap;
        this.initLinePaint();
    }

    public int getLinePadding() {
        return this.mLinePadding;
    }

    private void showStartLine(boolean show) {
        this.mDrawStartLine = show;
    }

    private void showEndLine(boolean show) {
        this.mDrawEndLine = show;
    }

    public void initLine(int viewType) {
        if (viewType == 1) {
            this.showStartLine(false);
            this.showEndLine(true);
        } else if (viewType == 2) {
            this.showStartLine(true);
            this.showEndLine(false);
        } else if (viewType == 3) {
            this.showStartLine(false);
            this.showEndLine(false);
        } else {
            this.showStartLine(true);
            this.showEndLine(true);
        }
        this.initTimeline();
    }

    public static int getTimeLineViewType(int position, int totalSize) {
        if (totalSize == 1) {
            return 3;
        }
        if (position == 0) {
            return 1;
        }
        if (position == totalSize - 1) {
            return 2;
        }
        return 0;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LineStyle {
        public static final int NORMAL = 0;
        public static final int DASHED = 1;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LineOrientation {
        public static final int HORIZONTAL = 0;
        public static final int VERTICAL = 1;
    }
}

