/*
 * Decompiled with CFR 0.152.
 */
package com.vimeo.networking2.internal;

import com.vimeo.networking2.Authenticator;
import com.vimeo.networking2.GrantType;
import com.vimeo.networking2.NoOpVimeoRequest;
import com.vimeo.networking2.PinCodeInfo;
import com.vimeo.networking2.SsoDomain;
import com.vimeo.networking2.VimeoAccount;
import com.vimeo.networking2.VimeoCallback;
import com.vimeo.networking2.VimeoRequest;
import com.vimeo.networking2.account.AccountStore;
import com.vimeo.networking2.account.CachingAccountStore;
import com.vimeo.networking2.config.AuthenticationMethod;
import com.vimeo.networking2.internal.AccountStoringVimeoCallback;
import com.vimeo.networking2.internal.AuthService;
import com.vimeo.networking2.internal.LocalVimeoCallAdapter;
import com.vimeo.networking2.internal.VimeoCall;
import com.vimeo.networking2.internal.params.ApiParameter;
import com.vimeo.networking2.internal.params.ApiParameterKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 62\u00020\u0001:\u00016B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014H\u0016J\u001e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00072\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014H\u0016J6\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014H\u0016J&\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00072\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014H\u0016J.\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014H\u0016J.\u0010!\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014H\u0016J\u001e\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020$2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014H\u0016J&\u0010%\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014H\u0016J\u0010\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u0007H\u0016J\u001a\u0010(\u001a\u0004\u0018\u00010\u00072\u0006\u0010)\u001a\u00020*2\u0006\u0010'\u001a\u00020\u0007H\u0016J\u001e\u0010+\u001a\u00020\u00122\u0006\u0010,\u001a\u00020\u00072\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014H\u0016J&\u0010-\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u00072\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014H\u0016J\u0016\u0010/\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020$0\u0014H\u0016J\u001e\u00100\u001a\u00020\u00122\u0006\u00101\u001a\u00020\u00072\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020*0\u0014H\u0016J\u0016\u00102\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002030\u0014H\u0016J \u00104\u001a\u00020\u0012*\b\u0012\u0004\u0012\u00020\u000e052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/vimeo/networking2/internal/AuthenticatorImpl;", "Lcom/vimeo/networking2/Authenticator;", "authService", "Lcom/vimeo/networking2/internal/AuthService;", "authenticationMethod", "Lcom/vimeo/networking2/config/AuthenticationMethod$ClientCredentials;", "redirectUri", "", "accountStore", "Lcom/vimeo/networking2/account/CachingAccountStore;", "localVimeoCallAdapter", "Lcom/vimeo/networking2/internal/LocalVimeoCallAdapter;", "(Lcom/vimeo/networking2/internal/AuthService;Lcom/vimeo/networking2/config/AuthenticationMethod$ClientCredentials;Ljava/lang/String;Lcom/vimeo/networking2/account/CachingAccountStore;Lcom/vimeo/networking2/internal/LocalVimeoCallAdapter;)V", "currentAccount", "Lcom/vimeo/networking2/VimeoAccount;", "getCurrentAccount", "()Lcom/vimeo/networking2/VimeoAccount;", "authenticateWithClientCredentials", "Lcom/vimeo/networking2/VimeoRequest;", "callback", "Lcom/vimeo/networking2/VimeoCallback;", "authenticateWithCodeGrant", "uri", "authenticateWithEmailJoin", "displayName", "email", "password", "marketingOptIn", "", "authenticateWithEmailLogin", "username", "authenticateWithFacebook", "token", "authenticateWithGoogle", "authenticateWithPinCode", "pinCodeInfo", "Lcom/vimeo/networking2/PinCodeInfo;", "authenticateWithSso", "createCodeGrantAuthorizationUri", "responseCode", "createSsoAuthorizationUri", "ssoDomain", "Lcom/vimeo/networking2/SsoDomain;", "exchangeAccessToken", "accessToken", "exchangeOAuth1Token", "tokenSecret", "fetchPinCodeInfo", "fetchSsoDomain", "domain", "logOut", "", "enqueueWithAccountStore", "Lcom/vimeo/networking2/internal/VimeoCall;", "Companion", "auth"})
public final class AuthenticatorImpl
implements Authenticator {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final AuthService authService;
    @NotNull
    private final AuthenticationMethod.ClientCredentials authenticationMethod;
    @NotNull
    private final String redirectUri;
    @NotNull
    private final CachingAccountStore accountStore;
    @NotNull
    private final LocalVimeoCallAdapter localVimeoCallAdapter;
    @Deprecated
    @NotNull
    private static final String PARAM_CODE = "code";

    public AuthenticatorImpl(@NotNull AuthService authService, @NotNull AuthenticationMethod.ClientCredentials authenticationMethod, @NotNull String redirectUri, @NotNull CachingAccountStore accountStore, @NotNull LocalVimeoCallAdapter localVimeoCallAdapter) {
        Intrinsics.checkNotNullParameter((Object)authService, (String)"authService");
        Intrinsics.checkNotNullParameter((Object)authenticationMethod, (String)"authenticationMethod");
        Intrinsics.checkNotNullParameter((Object)redirectUri, (String)"redirectUri");
        Intrinsics.checkNotNullParameter((Object)accountStore, (String)"accountStore");
        Intrinsics.checkNotNullParameter((Object)localVimeoCallAdapter, (String)"localVimeoCallAdapter");
        this.authService = authService;
        this.authenticationMethod = authenticationMethod;
        this.redirectUri = redirectUri;
        this.accountStore = accountStore;
        this.localVimeoCallAdapter = localVimeoCallAdapter;
    }

    @Override
    @Nullable
    public VimeoAccount getCurrentAccount() {
        return this.accountStore.loadAccount();
    }

    @Override
    @NotNull
    public VimeoRequest authenticateWithClientCredentials(@NotNull VimeoCallback<VimeoAccount> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        return this.enqueueWithAccountStore(this.authService.authorizeWithClientCredentialsGrant(this.authenticationMethod.getBasicAuthHeader(), GrantType.CLIENT_CREDENTIALS, this.authenticationMethod.getScopes()), callback);
    }

    @Override
    @NotNull
    public VimeoRequest authenticateWithGoogle(@NotNull String token, @NotNull String username, boolean marketingOptIn, @NotNull VimeoCallback<VimeoAccount> callback) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        ApiParameter tokenParameter = new ApiParameter("id_token", token, null, 4, null);
        ApiParameter emailParameter = new ApiParameter("username", username, null, 4, null);
        ApiParameter[] apiParameterArray = new ApiParameter[]{tokenParameter, emailParameter};
        VimeoRequest vimeoRequest = ApiParameterKt.validateParameters((LocalVimeoCallAdapter)this.localVimeoCallAdapter, callback, (String)"Google authentication error", (ApiParameter[])apiParameterArray);
        return vimeoRequest == null ? this.enqueueWithAccountStore(this.authService.joinWithGoogle(this.authenticationMethod.getBasicAuthHeader(), emailParameter.getValidatedParameterValue(), tokenParameter.getValidatedParameterValue(), this.authenticationMethod.getScopes(), marketingOptIn), callback) : vimeoRequest;
    }

    @Override
    @NotNull
    public VimeoRequest authenticateWithFacebook(@NotNull String token, @NotNull String username, boolean marketingOptIn, @NotNull VimeoCallback<VimeoAccount> callback) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        ApiParameter tokenParameter = new ApiParameter("token", token, null, 4, null);
        ApiParameter emailParameter = new ApiParameter("username", username, null, 4, null);
        ApiParameter[] apiParameterArray = new ApiParameter[]{tokenParameter, emailParameter};
        VimeoRequest vimeoRequest = ApiParameterKt.validateParameters((LocalVimeoCallAdapter)this.localVimeoCallAdapter, callback, (String)"Facebook authentication error", (ApiParameter[])apiParameterArray);
        return vimeoRequest == null ? this.enqueueWithAccountStore(this.authService.joinWithFacebook(this.authenticationMethod.getBasicAuthHeader(), emailParameter.getValidatedParameterValue(), tokenParameter.getValidatedParameterValue(), this.authenticationMethod.getScopes(), marketingOptIn), callback) : vimeoRequest;
    }

    @Override
    @NotNull
    public VimeoRequest authenticateWithEmailJoin(@NotNull String displayName, @NotNull String email, @NotNull String password, boolean marketingOptIn, @NotNull VimeoCallback<VimeoAccount> callback) {
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        ApiParameter nameParameter = new ApiParameter("name", displayName, null, 4, null);
        ApiParameter emailParameter = new ApiParameter("email", email, null, 4, null);
        ApiParameter passwordParameter = new ApiParameter("password", password, null, 4, null);
        ApiParameter[] apiParameterArray = new ApiParameter[]{nameParameter, emailParameter, passwordParameter};
        VimeoRequest vimeoRequest = ApiParameterKt.validateParameters((LocalVimeoCallAdapter)this.localVimeoCallAdapter, callback, (String)"Email join error", (ApiParameter[])apiParameterArray);
        return vimeoRequest == null ? this.enqueueWithAccountStore(this.authService.joinWithEmail(this.authenticationMethod.getBasicAuthHeader(), nameParameter.getValidatedParameterValue(), emailParameter.getValidatedParameterValue(), passwordParameter.getValidatedParameterValue(), this.authenticationMethod.getScopes(), marketingOptIn), callback) : vimeoRequest;
    }

    @Override
    @NotNull
    public VimeoRequest authenticateWithEmailLogin(@NotNull String username, @NotNull String password, @NotNull VimeoCallback<VimeoAccount> callback) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        ApiParameter emailParameter = new ApiParameter("username", username, null, 4, null);
        ApiParameter passwordParameter = new ApiParameter("password", password, null, 4, null);
        ApiParameter[] apiParameterArray = new ApiParameter[]{emailParameter, passwordParameter};
        VimeoRequest vimeoRequest = ApiParameterKt.validateParameters((LocalVimeoCallAdapter)this.localVimeoCallAdapter, callback, (String)"Email login error", (ApiParameter[])apiParameterArray);
        return vimeoRequest == null ? this.enqueueWithAccountStore(this.authService.logInWithEmail(this.authenticationMethod.getBasicAuthHeader(), emailParameter.getValidatedParameterValue(), passwordParameter.getValidatedParameterValue(), GrantType.PASSWORD, this.authenticationMethod.getScopes()), callback) : vimeoRequest;
    }

    @Override
    @NotNull
    public VimeoRequest exchangeAccessToken(@NotNull String accessToken, @NotNull VimeoCallback<VimeoAccount> callback) {
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        return this.enqueueWithAccountStore(this.authService.exchangeAccessToken(this.authenticationMethod.getBasicAuthHeader(), accessToken, this.authenticationMethod.getScopes()), callback);
    }

    @Override
    @NotNull
    public VimeoRequest exchangeOAuth1Token(@NotNull String token, @NotNull String tokenSecret, @NotNull VimeoCallback<VimeoAccount> callback) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)tokenSecret, (String)"tokenSecret");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        ApiParameter tokenParameter = new ApiParameter("token", token, null, 4, null);
        ApiParameter tokenSecretParameter = new ApiParameter("token_secret", tokenSecret, null, 4, null);
        ApiParameter[] apiParameterArray = new ApiParameter[]{tokenParameter, tokenSecretParameter};
        VimeoRequest vimeoRequest = ApiParameterKt.validateParameters((LocalVimeoCallAdapter)this.localVimeoCallAdapter, callback, (String)"OAuth1 token exchange error", (ApiParameter[])apiParameterArray);
        return vimeoRequest == null ? this.enqueueWithAccountStore(this.authService.exchangeOAuth1Token(this.authenticationMethod.getBasicAuthHeader(), GrantType.OAUTH_ONE, tokenParameter.getValidatedParameterValue(), tokenSecretParameter.getValidatedParameterValue(), this.authenticationMethod.getScopes()), callback) : vimeoRequest;
    }

    @Override
    @NotNull
    public VimeoRequest authenticateWithCodeGrant(@NotNull String uri, @NotNull VimeoCallback<VimeoAccount> callback) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        HttpUrl httpUrl = HttpUrl.parse((String)uri);
        ApiParameter authorizationCode = new ApiParameter(PARAM_CODE, httpUrl == null ? null : httpUrl.queryParameter(PARAM_CODE), "URI was invalid or did not contain a 'code' parameter");
        ApiParameter redirectUri = new ApiParameter("redirect_uri", this.redirectUri, null, 4, null);
        ApiParameter[] apiParameterArray = new ApiParameter[]{authorizationCode, redirectUri};
        VimeoRequest vimeoRequest = ApiParameterKt.validateParameters((LocalVimeoCallAdapter)this.localVimeoCallAdapter, callback, (String)"Code grant authentication error", (ApiParameter[])apiParameterArray);
        return vimeoRequest == null ? this.enqueueWithAccountStore(this.authService.authenticateWithCodeGrant(this.authenticationMethod.getBasicAuthHeader(), redirectUri.getValidatedParameterValue(), authorizationCode.getValidatedParameterValue(), GrantType.AUTHORIZATION_CODE), callback) : vimeoRequest;
    }

    @Override
    @NotNull
    public String createCodeGrantAuthorizationUri(@NotNull String responseCode) {
        Intrinsics.checkNotNullParameter((Object)responseCode, (String)"responseCode");
        return this.authService.createCodeGrantRequest(this.authenticationMethod.getClientId(), this.redirectUri, responseCode, this.authenticationMethod.getScopes()).getUrl();
    }

    @Override
    @NotNull
    public VimeoRequest fetchSsoDomain(@NotNull String domain, @NotNull VimeoCallback<SsoDomain> callback) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        ApiParameter domainParameter = new ApiParameter("domain", domain, null, 4, null);
        ApiParameter[] apiParameterArray = new ApiParameter[]{domainParameter};
        VimeoRequest vimeoRequest = ApiParameterKt.validateParameters((LocalVimeoCallAdapter)this.localVimeoCallAdapter, callback, (String)"SSO domain fetch error", (ApiParameter[])apiParameterArray);
        return vimeoRequest == null ? this.authService.getSsoDomain(this.authenticationMethod.getBasicAuthHeader(), domainParameter.getValidatedParameterValue()).enqueue(callback) : vimeoRequest;
    }

    @Override
    @Nullable
    public String createSsoAuthorizationUri(@NotNull SsoDomain ssoDomain, @NotNull String responseCode) {
        Intrinsics.checkNotNullParameter((Object)ssoDomain, (String)"ssoDomain");
        Intrinsics.checkNotNullParameter((Object)responseCode, (String)"responseCode");
        String string = ssoDomain.getConnectUrl();
        if (string == null) {
            return null;
        }
        String connectUrl = string;
        return this.authService.createSsoGrantRequest(connectUrl, this.redirectUri, responseCode).getUrl();
    }

    @Override
    @NotNull
    public VimeoRequest authenticateWithSso(@NotNull String uri, boolean marketingOptIn, @NotNull VimeoCallback<VimeoAccount> callback) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        HttpUrl httpUrl = HttpUrl.parse((String)uri);
        ApiParameter authorizationCode = new ApiParameter("authorization_code", httpUrl == null ? null : httpUrl.queryParameter(PARAM_CODE), "URI was invalid or did not contain a 'code' parameter");
        ApiParameter redirectUri = new ApiParameter("redirect_uri", this.redirectUri, null, 4, null);
        ApiParameter[] apiParameterArray = new ApiParameter[]{authorizationCode, redirectUri};
        VimeoRequest vimeoRequest = ApiParameterKt.validateParameters((LocalVimeoCallAdapter)this.localVimeoCallAdapter, callback, (String)"SSO authentication error", (ApiParameter[])apiParameterArray);
        return vimeoRequest == null ? this.enqueueWithAccountStore(this.authService.joinWithSsoCodeGrant(this.authenticationMethod.getBasicAuthHeader(), authorizationCode.getValidatedParameterValue(), redirectUri.getValidatedParameterValue(), marketingOptIn), callback) : vimeoRequest;
    }

    @Override
    @NotNull
    public VimeoRequest fetchPinCodeInfo(@NotNull VimeoCallback<PinCodeInfo> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        return this.authService.getPinCodeInfo(this.authenticationMethod.getBasicAuthHeader(), GrantType.DEVICE, this.authenticationMethod.getScopes()).enqueue(callback);
    }

    @Override
    @NotNull
    public VimeoRequest authenticateWithPinCode(@NotNull PinCodeInfo pinCodeInfo, @NotNull VimeoCallback<VimeoAccount> callback) {
        Intrinsics.checkNotNullParameter((Object)pinCodeInfo, (String)"pinCodeInfo");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        ApiParameter userCode = new ApiParameter("user_code", pinCodeInfo.getUserCode(), null, 4, null);
        ApiParameter deviceCode = new ApiParameter("device_code", pinCodeInfo.getDeviceCode(), null, 4, null);
        ApiParameter[] apiParameterArray = new ApiParameter[]{userCode, deviceCode};
        VimeoRequest vimeoRequest = ApiParameterKt.validateParameters((LocalVimeoCallAdapter)this.localVimeoCallAdapter, callback, (String)"Pin code authentication error", (ApiParameter[])apiParameterArray);
        return vimeoRequest == null ? this.enqueueWithAccountStore(this.authService.logInWithPinCode(this.authenticationMethod.getBasicAuthHeader(), GrantType.DEVICE, userCode.getValidatedParameterValue(), deviceCode.getValidatedParameterValue(), this.authenticationMethod.getScopes()), callback) : vimeoRequest;
    }

    @Override
    @NotNull
    public VimeoRequest logOut(@NotNull VimeoCallback<Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Object object = this.getCurrentAccount();
        String accessToken = object == null ? null : object.getAccessToken();
        this.accountStore.removeAccount();
        object = accessToken;
        if (object == null) {
            return (VimeoRequest)NoOpVimeoRequest.INSTANCE;
        }
        return this.authService.logOut(Intrinsics.stringPlus((String)"Bearer ", (Object)accessToken)).enqueue(callback);
    }

    private final VimeoRequest enqueueWithAccountStore(VimeoCall<VimeoAccount> $this$enqueueWithAccountStore, VimeoCallback<VimeoAccount> callback) {
        return $this$enqueueWithAccountStore.enqueue((VimeoCallback)new AccountStoringVimeoCallback((AccountStore)this.accountStore, callback));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/vimeo/networking2/internal/AuthenticatorImpl$Companion;", "", "()V", "PARAM_CODE", "", "auth"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

