/*
 * Decompiled with CFR 0.152.
 */
package viethoa.com.snackbar.animations;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.view.View;

public abstract class BaseEffects {
    private static final int DURATION = 300;
    protected long mDuration = 300L;
    protected AnimationListener listener;
    private AnimatorSet mAnimatorSet = new AnimatorSet();

    protected abstract void setupAnimation(View var1);

    public void start(final View view) {
        this.mAnimatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (BaseEffects.this.listener == null) {
                    return;
                }
                BaseEffects.this.listener.onAnimationEnd(view);
            }
        });
        this.setupAnimation(view);
        this.mAnimatorSet.start();
    }

    public void reset(View view) {
        view.setPivotX((float)view.getMeasuredWidth() / 2.0f);
        view.setPivotY((float)view.getMeasuredHeight() / 2.0f);
    }

    public AnimatorSet getAnimatorSet() {
        return this.mAnimatorSet;
    }

    public void setDuration(long duration) {
        this.mDuration = duration;
    }

    public void setListener(AnimationListener listener) {
        this.listener = listener;
    }

    public static interface AnimationListener {
        public void onAnimationEnd(View var1);
    }
}

