/*
 * Decompiled with CFR 0.152.
 */
package viethoa.com.snackbar;

import android.app.Activity;
import android.support.annotation.ColorRes;
import android.support.annotation.IdRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.StringRes;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

public class SnackBar {
    private View snackbar;
    private View contentMessage;
    private TextView message;
    private View divider;
    private View closeButton;
    private boolean isAnimationFromTop;
    private SnackBarListener listener;

    public SnackBar(Activity activity, @LayoutRes int layoutRes, @IdRes int contentMessageRes, @IdRes int textViewRes, @IdRes int dividerRes, @IdRes int btnCloseRes, boolean isAnimationFromTop) {
        this.isAnimationFromTop = isAnimationFromTop;
        LayoutInflater layoutInflater = (LayoutInflater)activity.getSystemService("layout_inflater");
        this.snackbar = layoutInflater.inflate(layoutRes, null);
        this.contentMessage = this.snackbar.findViewById(contentMessageRes);
        this.message = (TextView)this.snackbar.findViewById(textViewRes);
        this.divider = this.snackbar.findViewById(dividerRes);
        this.closeButton = this.snackbar.findViewById(btnCloseRes);
        this.closeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (SnackBar.this.listener == null) {
                    return;
                }
                SnackBar.this.listener.OnBtnCloseClicked(SnackBar.this.snackbar);
            }
        });
    }

    public void setListener(SnackBarListener listener) {
        this.listener = listener;
    }

    public void init(String messageStr, @ColorRes int colorRes, boolean isCloseable) {
        if (this.message != null) {
            this.message.setText((CharSequence)messageStr);
        }
        this.init(colorRes, isCloseable);
    }

    public void init(@StringRes int messageRes, @ColorRes int colorRes, boolean isCloseable) {
        if (this.message != null) {
            this.message.setText(messageRes);
        }
        this.init(colorRes, isCloseable);
    }

    private void init(@ColorRes int colorRes, boolean isCloseable) {
        if (this.contentMessage != null) {
            this.contentMessage.setBackgroundResource(colorRes);
        }
        if (isCloseable) {
            if (this.divider != null) {
                this.divider.setVisibility(0);
            }
            if (this.closeButton != null) {
                this.closeButton.setVisibility(0);
            }
        } else {
            if (this.divider != null) {
                this.divider.setVisibility(8);
            }
            if (this.closeButton != null) {
                this.closeButton.setVisibility(8);
            }
        }
    }

    public ViewGroup getParent() {
        if (this.snackbar == null || this.snackbar.getParent() == null) {
            return null;
        }
        return (ViewGroup)this.snackbar.getParent();
    }

    public View getView() {
        return this.snackbar;
    }

    public boolean isAnimationFromTop() {
        return this.isAnimationFromTop;
    }

    public boolean isCloseable() {
        return this.closeButton != null && this.closeButton.getVisibility() == 0;
    }

    public static interface SnackBarListener {
        public void OnBtnCloseClicked(View var1);
    }
}

