/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.module.javax.validation;

import com.github.victools.jsonschema.generator.JavaType;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigPart;
import com.github.victools.jsonschema.generator.impl.ReflectionTypeUtils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Negative;
import javax.validation.constraints.NegativeOrZero;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.validation.constraints.Positive;
import javax.validation.constraints.PositiveOrZero;
import javax.validation.constraints.Size;

public class JavaxValidationModule
implements Module {
    public void applyToConfigBuilder(SchemaGeneratorConfigBuilder builder) {
        this.applyToConfigPart((SchemaGeneratorConfigPart<? extends AccessibleObject>)builder.forFields());
        this.applyToConfigPart((SchemaGeneratorConfigPart<? extends AccessibleObject>)builder.forMethods());
    }

    private void applyToConfigPart(SchemaGeneratorConfigPart<? extends AccessibleObject> configPart) {
        configPart.withNullableCheck(this::isNullable);
        configPart.withArrayMinItemsResolver(this::resolveArrayMinItems);
        configPart.withArrayMaxItemsResolver(this::resolveArrayMaxItems);
        configPart.withStringMinLengthResolver(this::resolveStringMinLength);
        configPart.withStringMaxLengthResolver(this::resolveStringMaxLength);
        configPart.withNumberInclusiveMinimumResolver(this::resolveNumberInclusiveMinimum);
        configPart.withNumberExclusiveMinimumResolver(this::resolveNumberExclusiveMinimum);
        configPart.withNumberInclusiveMaximumResolver(this::resolveNumberInclusiveMaximum);
        configPart.withNumberExclusiveMaximumResolver(this::resolveNumberExclusiveMaximum);
    }

    private Boolean isNullable(AccessibleObject fieldOrMethod, JavaType type) {
        Boolean result = fieldOrMethod.isAnnotationPresent(NotNull.class) || fieldOrMethod.isAnnotationPresent(NotBlank.class) || fieldOrMethod.isAnnotationPresent(NotEmpty.class) ? Boolean.FALSE : (fieldOrMethod.isAnnotationPresent(Null.class) ? Boolean.TRUE : null);
        return result;
    }

    private Integer resolveArrayMinItems(AccessibleObject fieldOrMethod, JavaType type) {
        if (ReflectionTypeUtils.isArrayType((JavaType)type)) {
            Size sizeAnnotation = fieldOrMethod.getAnnotation(Size.class);
            if (sizeAnnotation != null && sizeAnnotation.min() > 0) {
                return sizeAnnotation.min();
            }
            if (fieldOrMethod.isAnnotationPresent(NotEmpty.class)) {
                return 1;
            }
        }
        return null;
    }

    private Integer resolveArrayMaxItems(AccessibleObject fieldOrMethod, JavaType type) {
        Size sizeAnnotation;
        if (ReflectionTypeUtils.isArrayType((JavaType)type) && (sizeAnnotation = fieldOrMethod.getAnnotation(Size.class)) != null && sizeAnnotation.max() < Integer.MAX_VALUE) {
            return sizeAnnotation.max();
        }
        return null;
    }

    private Integer resolveStringMinLength(AccessibleObject fieldOrMethod, JavaType type) {
        Class rawType = ReflectionTypeUtils.getRawType((Type)type.getResolvedType());
        if (CharSequence.class.isAssignableFrom(rawType)) {
            Size sizeAnnotation = fieldOrMethod.getAnnotation(Size.class);
            if (sizeAnnotation != null && sizeAnnotation.min() > 0) {
                return sizeAnnotation.min();
            }
            if (fieldOrMethod.isAnnotationPresent(NotEmpty.class) || fieldOrMethod.isAnnotationPresent(NotBlank.class)) {
                return 1;
            }
        }
        return null;
    }

    private Integer resolveStringMaxLength(AccessibleObject fieldOrMethod, JavaType type) {
        Size sizeAnnotation;
        Class rawType = ReflectionTypeUtils.getRawType((Type)type.getResolvedType());
        if (CharSequence.class.isAssignableFrom(rawType) && (sizeAnnotation = fieldOrMethod.getAnnotation(Size.class)) != null && sizeAnnotation.max() < Integer.MAX_VALUE) {
            return sizeAnnotation.max();
        }
        return null;
    }

    private BigDecimal resolveNumberInclusiveMinimum(AccessibleObject fieldOrMethod, JavaType type) {
        Min minAnnotation = fieldOrMethod.getAnnotation(Min.class);
        if (minAnnotation != null) {
            return new BigDecimal(minAnnotation.value());
        }
        DecimalMin decimalMinAnnotation = fieldOrMethod.getAnnotation(DecimalMin.class);
        if (decimalMinAnnotation != null && decimalMinAnnotation.inclusive()) {
            return new BigDecimal(decimalMinAnnotation.value());
        }
        PositiveOrZero positiveAnnotation = fieldOrMethod.getAnnotation(PositiveOrZero.class);
        if (positiveAnnotation != null) {
            return BigDecimal.ZERO;
        }
        return null;
    }

    private BigDecimal resolveNumberExclusiveMinimum(AccessibleObject fieldOrMethod, JavaType type) {
        DecimalMin decimalMinAnnotation = fieldOrMethod.getAnnotation(DecimalMin.class);
        if (decimalMinAnnotation != null && !decimalMinAnnotation.inclusive()) {
            return new BigDecimal(decimalMinAnnotation.value());
        }
        Positive positiveAnnotation = fieldOrMethod.getAnnotation(Positive.class);
        if (positiveAnnotation != null) {
            return BigDecimal.ZERO;
        }
        return null;
    }

    private BigDecimal resolveNumberInclusiveMaximum(AccessibleObject fieldOrMethod, JavaType type) {
        Max maxAnnotation = fieldOrMethod.getAnnotation(Max.class);
        if (maxAnnotation != null) {
            return new BigDecimal(maxAnnotation.value());
        }
        DecimalMax decimalMaxAnnotation = fieldOrMethod.getAnnotation(DecimalMax.class);
        if (decimalMaxAnnotation != null && decimalMaxAnnotation.inclusive()) {
            return new BigDecimal(decimalMaxAnnotation.value());
        }
        NegativeOrZero negativeAnnotation = fieldOrMethod.getAnnotation(NegativeOrZero.class);
        if (negativeAnnotation != null) {
            return BigDecimal.ZERO;
        }
        return null;
    }

    private BigDecimal resolveNumberExclusiveMaximum(AccessibleObject fieldOrMethod, JavaType type) {
        DecimalMax decimalMaxAnnotation = fieldOrMethod.getAnnotation(DecimalMax.class);
        if (decimalMaxAnnotation != null && !decimalMaxAnnotation.inclusive()) {
            return new BigDecimal(decimalMaxAnnotation.value());
        }
        Negative negativeAnnotation = fieldOrMethod.getAnnotation(Negative.class);
        if (negativeAnnotation != null) {
            return BigDecimal.ZERO;
        }
        return null;
    }
}

