/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.module.jackson;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.github.victools.jsonschema.generator.FieldScope;
import com.github.victools.jsonschema.generator.MethodScope;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.TypeScope;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class JacksonModule
implements Module {
    private ObjectMapper objectMapper;
    private final Map<Class<?>, BeanDescription> beanDescriptions = new HashMap();

    public void applyToConfigBuilder(SchemaGeneratorConfigBuilder builder) {
        this.objectMapper = builder.getObjectMapper();
        builder.forFields().withDescriptionResolver(this::resolveDescription).withPropertyNameOverrideResolver(this::getPropertyNameOverride).withIgnoreCheck(this::shouldIgnoreField);
        builder.forTypesInGeneral().withDescriptionResolver(this::resolveDescriptionForType);
    }

    protected <A extends Annotation> A getAnnotationFromFieldOrGetter(FieldScope field, Class<A> annotationClass) {
        Annotation annotation = field.getAnnotation(annotationClass);
        if (annotation == null) {
            MethodScope getter = field.findGetter();
            annotation = getter == null ? null : getter.getAnnotation(annotationClass);
        }
        return (A)annotation;
    }

    protected String resolveDescription(FieldScope field) {
        JsonPropertyDescription propertyAnnotation = this.getAnnotationFromFieldOrGetter(field, JsonPropertyDescription.class);
        if (propertyAnnotation != null) {
            return propertyAnnotation.value();
        }
        return null;
    }

    protected String resolveDescriptionForType(TypeScope scope) {
        Class rawType = scope.getType().getErasedType();
        JsonClassDescription classAnnotation = rawType.getAnnotation(JsonClassDescription.class);
        if (classAnnotation != null) {
            return classAnnotation.value();
        }
        return null;
    }

    protected String getPropertyNameOverride(FieldScope field) {
        String nameOverride;
        JsonProperty annotation = this.getAnnotationFromFieldOrGetter(field, JsonProperty.class);
        if (annotation != null && (nameOverride = annotation.value()) != null && !nameOverride.isEmpty() && !nameOverride.equals(field.getDeclaredName())) {
            return nameOverride;
        }
        return null;
    }

    protected final BeanDescription getBeanDescriptionForClass(ResolvedType targetType) {
        return this.beanDescriptions.computeIfAbsent(targetType.getErasedType(), type -> this.objectMapper.getSerializationConfig().introspect(this.objectMapper.getTypeFactory().constructType((Type)type)));
    }

    protected boolean shouldIgnoreField(FieldScope field) {
        String fieldName;
        BeanDescription beanDescription = this.getBeanDescriptionForClass(field.getDeclaringType());
        Set ignoredProperties = this.objectMapper.getSerializationConfig().getAnnotationIntrospector().findPropertyIgnorals((Annotated)beanDescription.getClassInfo()).getIgnored();
        if (ignoredProperties.contains(fieldName = field.getName())) {
            return true;
        }
        return beanDescription.findProperties().stream().noneMatch(propertyDefinition -> fieldName.equals(propertyDefinition.getInternalName()));
    }
}

