/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.module.jackson;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.members.RawMember;
import com.fasterxml.classmate.members.ResolvedMember;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.CustomDefinition;
import com.github.victools.jsonschema.generator.CustomDefinitionProviderV2;
import com.github.victools.jsonschema.generator.SchemaGenerationContext;
import com.github.victools.jsonschema.generator.SchemaKeyword;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Stream;

public class JsonUnwrappedDefinitionProvider
implements CustomDefinitionProviderV2 {
    public CustomDefinition provideCustomSchemaDefinition(ResolvedType javaType, SchemaGenerationContext context) {
        if (javaType.getMemberFields().stream().noneMatch(this::hasJsonUnwrappedAnnotation) && javaType.getMemberMethods().stream().noneMatch(this::hasJsonUnwrappedAnnotation)) {
            return null;
        }
        ObjectNode definition = context.createStandardDefinition(javaType, (CustomDefinitionProviderV2)this);
        ArrayNode allOf = definition.withArray(context.getKeyword(SchemaKeyword.TAG_ALLOF));
        ResolvedTypeWithMembers typeWithMembers = context.getTypeContext().resolveWithMembers(javaType);
        Stream.concat(Stream.of(typeWithMembers.getMemberFields()), Stream.of(typeWithMembers.getMemberMethods())).filter(member -> Optional.ofNullable((JsonUnwrapped)member.getAnnotations().get(JsonUnwrapped.class)).filter(JsonUnwrapped::enabled).isPresent()).map(member -> this.createUnwrappedMemberSchema((ResolvedMember<?>)member, context)).forEachOrdered(arg_0 -> ((ArrayNode)allOf).add(arg_0));
        return new CustomDefinition(definition);
    }

    private boolean hasJsonUnwrappedAnnotation(RawMember member) {
        for (Annotation annotation : member.getAnnotations()) {
            if (!(annotation instanceof JsonUnwrapped) || !((JsonUnwrapped)annotation).enabled()) continue;
            return true;
        }
        return false;
    }

    private ObjectNode createUnwrappedMemberSchema(ResolvedMember<?> member, SchemaGenerationContext context) {
        ObjectNode definition = context.createStandardDefinition(member.getType(), null);
        JsonUnwrapped annotation = (JsonUnwrapped)member.getAnnotations().get(JsonUnwrapped.class);
        if (!annotation.prefix().isEmpty() || !annotation.suffix().isEmpty()) {
            this.applyPrefixAndSuffixToPropertyNames((JsonNode)definition, annotation.prefix(), annotation.suffix(), context);
        }
        return definition;
    }

    private void applyPrefixAndSuffixToPropertyNames(JsonNode definition, String prefix, String suffix, SchemaGenerationContext context) {
        JsonNode allOf;
        JsonNode properties = definition.get(context.getKeyword(SchemaKeyword.TAG_PROPERTIES));
        if (properties instanceof ObjectNode && !properties.isEmpty()) {
            ArrayList fieldNames = new ArrayList();
            properties.fieldNames().forEachRemaining(fieldNames::add);
            for (String fieldName : fieldNames) {
                JsonNode propertySchema = ((ObjectNode)properties).remove(fieldName);
                ((ObjectNode)properties).set(prefix + fieldName + suffix, propertySchema);
            }
        }
        if ((allOf = definition.get(context.getKeyword(SchemaKeyword.TAG_ALLOF))) instanceof ArrayNode) {
            allOf.forEach(allOfEntry -> this.applyPrefixAndSuffixToPropertyNames((JsonNode)allOfEntry, prefix, suffix, context));
        }
    }
}

