/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.plugin.maven;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.IntStream;

public class GlobHandler {
    private static final char ESCAPE_CHAR = '\\';
    private static final char ASTERISK_CHAR = '*';
    private static final char QUESTION_MARK_CHAR = '?';
    private static final char EXCLAMATION_SIGN_CHAR = '!';
    private static final char COMMA_CHAR = ',';
    private static final int[] GLOB_IDENTIFIERS = new int[]{92, 42, 63, 47, 43, 91, 123};
    private static final int[] INPUT_CHARS_REQUIRING_ESCAPE = new int[]{46, 40, 41, 43, 124, 94, 36, 64, 37};

    public static Predicate<String> createClassOrPackageNameFilter(String input, boolean forPackage) {
        return className -> GlobHandler.createClassOrPackageNamePattern(input, forPackage).matcher((CharSequence)className).matches();
    }

    public static Pattern createClassOrPackageNamePattern(String input, boolean forPackage) {
        Object inputRegex = GlobHandler.convertInputToRegex(input);
        if (forPackage) {
            inputRegex = (String)inputRegex + (((String)inputRegex).charAt(((String)inputRegex).length() - 1) == '/' ? ".+" : "/.+");
        }
        return Pattern.compile((String)inputRegex);
    }

    private static String convertInputToRegex(String input) {
        if (IntStream.of(GLOB_IDENTIFIERS).anyMatch(identifier -> input.chars().anyMatch(inputChar -> inputChar == identifier))) {
            return GlobHandler.convertGlobToRegex(input);
        }
        return input.replace('.', '/');
    }

    private static String convertGlobToRegex(String pattern) {
        StringBuilder sb = new StringBuilder(pattern.length());
        AtomicInteger inGroup = new AtomicInteger(0);
        AtomicInteger inClass = new AtomicInteger(0);
        AtomicInteger firstIndexInClass = new AtomicInteger(-1);
        char[] arr = pattern.toCharArray();
        AtomicInteger index = new AtomicInteger(0);
        while (index.get() < arr.length) {
            char ch = arr[index.get()];
            switch (ch) {
                case '\\': {
                    GlobHandler.handleEscapeChar(sb, arr, index.incrementAndGet());
                    break;
                }
                case '*': {
                    GlobHandler.handleAsteriskChar(sb, inClass, arr, index);
                    break;
                }
                case '?': {
                    GlobHandler.handleQuestionMarkChar(sb, inClass);
                    break;
                }
                case '[': {
                    GlobHandler.handleOpeningBracketChar(sb, inClass, firstIndexInClass, index);
                    break;
                }
                case ']': {
                    GlobHandler.handleClosingBracketChar(sb, inClass);
                    break;
                }
                case '!': {
                    GlobHandler.handleExclamationSignChar(sb, firstIndexInClass, index);
                    break;
                }
                case '{': {
                    GlobHandler.handleOpeningBraceChar(sb, inGroup);
                    break;
                }
                case '}': {
                    GlobHandler.handleClosingBraceChar(sb, inGroup);
                    break;
                }
                case ',': {
                    GlobHandler.handleCommaChar(sb, inGroup);
                    break;
                }
                default: {
                    boolean shouldBeEscaped;
                    boolean bl = shouldBeEscaped = IntStream.of(INPUT_CHARS_REQUIRING_ESCAPE).anyMatch(specialChar -> specialChar == ch) && (inClass.get() == 0 || ch == '^' && firstIndexInClass.get() == index.get());
                    if (shouldBeEscaped) {
                        sb.append('\\');
                    }
                    sb.append(ch);
                }
            }
            index.incrementAndGet();
        }
        return sb.toString();
    }

    private static void handleEscapeChar(StringBuilder sb, char[] arr, int nextCharIndex) {
        if (nextCharIndex >= arr.length) {
            sb.append('\\');
        } else {
            char next = arr[nextCharIndex];
            switch (next) {
                case ',': {
                    break;
                }
                case 'E': 
                case 'Q': {
                    sb.append('\\').append('\\');
                    break;
                }
                default: {
                    sb.append('\\');
                }
            }
            sb.append(next);
        }
    }

    private static void handleAsteriskChar(StringBuilder sb, AtomicInteger inClass, char[] arr, AtomicInteger index) {
        if (inClass.get() != 0) {
            sb.append('*');
        } else if (index.get() + 1 < arr.length && arr[index.get() + 1] == '*') {
            index.incrementAndGet();
            sb.append(".*");
        } else {
            sb.append("[^/]*");
        }
    }

    private static void handleQuestionMarkChar(StringBuilder sb, AtomicInteger inClass) {
        if (inClass.get() == 0) {
            sb.append("[^/]");
        } else {
            sb.append('?');
        }
    }

    private static void handleExclamationSignChar(StringBuilder sb, AtomicInteger firstIndexInClass, AtomicInteger index) {
        if (firstIndexInClass.get() == index.get()) {
            sb.append('^');
        } else {
            sb.append('!');
        }
    }

    private static void handleOpeningBracketChar(StringBuilder sb, AtomicInteger inClass, AtomicInteger firstIndexInClass, AtomicInteger index) {
        inClass.incrementAndGet();
        firstIndexInClass.set(index.get() + 1);
        sb.append('[');
    }

    private static void handleClosingBracketChar(StringBuilder sb, AtomicInteger inClass) {
        inClass.decrementAndGet();
        sb.append(']');
    }

    private static void handleOpeningBraceChar(StringBuilder sb, AtomicInteger inGroup) {
        inGroup.incrementAndGet();
        sb.append('(');
    }

    private static void handleClosingBraceChar(StringBuilder sb, AtomicInteger inGroup) {
        inGroup.decrementAndGet();
        sb.append(')');
    }

    private static void handleCommaChar(StringBuilder sb, AtomicInteger inGroup) {
        if (inGroup.get() > 0) {
            sb.append('|');
        } else {
            sb.append(',');
        }
    }
}

