/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.impl.module;

import com.fasterxml.classmate.ResolvedType;
import com.github.victools.jsonschema.generator.ConfigFunction;
import com.github.victools.jsonschema.generator.FieldScope;
import com.github.victools.jsonschema.generator.MemberScope;
import com.github.victools.jsonschema.generator.MethodScope;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.SchemaGenerationContext;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.TypeScope;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.BiFunction;
import tools.jackson.databind.JsonNode;

public class AdditionalPropertiesModule
implements Module {
    private final ConfigFunction<TypeScope, Type> generalAdditionalPropertiesResolver;
    private final BiFunction<FieldScope, SchemaGenerationContext, JsonNode> fieldAdditionalPropertiesResolver;
    private final BiFunction<MethodScope, SchemaGenerationContext, JsonNode> methodAdditionalPropertiesResolver;

    public static AdditionalPropertiesModule forMapValues() {
        ConfigFunction<TypeScope, Type> generalResolver = scope -> {
            if (scope.getType().isInstanceOf(Map.class)) {
                return scope.getTypeParameterFor(Map.class, 1);
            }
            return null;
        };
        return new AdditionalPropertiesModule(generalResolver, AdditionalPropertiesModule::createDefinitionForMemberMap, AdditionalPropertiesModule::createDefinitionForMemberMap);
    }

    private static JsonNode createDefinitionForMemberMap(MemberScope<?, ?> member, SchemaGenerationContext context) {
        if (!member.getType().isInstanceOf(Map.class)) {
            return null;
        }
        ResolvedType valueType = member.getTypeParameterFor(Map.class, 1);
        if (valueType == null || valueType.getErasedType() == Object.class) {
            return null;
        }
        return member.getContext().performActionOnMember(member.asFakeContainerItemScope(Map.class, 1), field -> context.createStandardDefinitionReference((FieldScope)field, null), method -> context.createStandardDefinitionReference((MethodScope)method, null));
    }

    public static AdditionalPropertiesModule forbiddenForAllObjectsButContainers() {
        return new AdditionalPropertiesModule(scope -> scope.isContainerType() ? null : Void.class);
    }

    public AdditionalPropertiesModule(ConfigFunction<TypeScope, Type> generalAdditionalPropertiesResolver) {
        this(generalAdditionalPropertiesResolver, null, null);
    }

    public AdditionalPropertiesModule(ConfigFunction<TypeScope, Type> generalAdditionalPropertiesResolver, BiFunction<FieldScope, SchemaGenerationContext, JsonNode> fieldAdditionalPropertiesResolver, BiFunction<MethodScope, SchemaGenerationContext, JsonNode> methodAdditionalPropertiesResolver) {
        this.generalAdditionalPropertiesResolver = generalAdditionalPropertiesResolver;
        this.fieldAdditionalPropertiesResolver = fieldAdditionalPropertiesResolver;
        this.methodAdditionalPropertiesResolver = methodAdditionalPropertiesResolver;
    }

    @Override
    public void applyToConfigBuilder(SchemaGeneratorConfigBuilder builder) {
        if (this.generalAdditionalPropertiesResolver != null) {
            builder.forTypesInGeneral().withAdditionalPropertiesResolver((ConfigFunction)this.generalAdditionalPropertiesResolver);
        }
        if (this.fieldAdditionalPropertiesResolver != null) {
            builder.forFields().withAdditionalPropertiesResolver((BiFunction)this.fieldAdditionalPropertiesResolver);
        }
        if (this.methodAdditionalPropertiesResolver != null) {
            builder.forMethods().withAdditionalPropertiesResolver((BiFunction)this.methodAdditionalPropertiesResolver);
        }
    }
}

