/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.TypeContext;
import com.github.victools.jsonschema.generator.impl.SchemaGenerationContextImpl;
import com.github.victools.jsonschema.generator.impl.TypeContextFactory;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class SchemaGenerator {
    private final SchemaGeneratorConfig config;
    private final TypeContext typeContext;

    public SchemaGenerator(SchemaGeneratorConfig config) {
        this(config, TypeContextFactory.createDefaultTypeContext());
    }

    public SchemaGenerator(SchemaGeneratorConfig config, TypeContext context) {
        this.config = config;
        this.typeContext = context;
    }

    public JsonNode generateSchema(Type mainTargetType, Type ... typeParameters) {
        ObjectNode definitionsNode;
        SchemaGenerationContextImpl generationContext = new SchemaGenerationContextImpl(this.config, this.typeContext);
        ResolvedType mainType = this.typeContext.resolve(mainTargetType, typeParameters);
        generationContext.parseType(mainType);
        ObjectNode jsonSchemaResult = this.config.createObjectNode();
        if (this.config.shouldIncludeSchemaVersionIndicator()) {
            jsonSchemaResult.put("$schema", "http://json-schema.org/draft-07/schema#");
        }
        if ((definitionsNode = this.buildDefinitionsAndResolveReferences(mainType, generationContext)).size() > 0) {
            jsonSchemaResult.set("definitions", (JsonNode)definitionsNode);
        }
        ObjectNode mainSchemaNode = generationContext.getDefinition(mainType);
        jsonSchemaResult.setAll(mainSchemaNode);
        return jsonSchemaResult;
    }

    private ObjectNode buildDefinitionsAndResolveReferences(ResolvedType mainSchemaTarget, SchemaGenerationContextImpl generationContext) {
        Map aliases = generationContext.getDefinedTypes().stream().collect(Collectors.groupingBy(this.typeContext::getSchemaDefinitionName, TreeMap::new, Collectors.toList()));
        ObjectNode definitionsNode = this.config.createObjectNode();
        boolean createDefinitionsForAll = this.config.shouldCreateDefinitionsForAllObjects();
        for (Map.Entry aliasEntry : aliases.entrySet()) {
            String referenceKey;
            boolean referenceInline;
            List types = (List)aliasEntry.getValue();
            List<ObjectNode> referencingNodes = types.stream().flatMap(type -> generationContext.getReferences((ResolvedType)type).stream()).collect(Collectors.toList());
            List<ObjectNode> nullableReferences = types.stream().flatMap(type -> generationContext.getNullableReferences((ResolvedType)type).stream()).collect(Collectors.toList());
            String alias = ((String)aliasEntry.getKey()).replaceAll("[ ]+", "").replaceAll("\\[\\]", "*").replaceAll("<", "(").replaceAll(">", ")");
            boolean bl = referenceInline = !types.contains(mainSchemaTarget) && (referencingNodes.isEmpty() || !createDefinitionsForAll && referencingNodes.size() + nullableReferences.size() < 2);
            if (referenceInline) {
                referencingNodes.forEach(referenceNode -> referenceNode.setAll(generationContext.getDefinition((ResolvedType)types.get(0))));
                referenceKey = null;
            } else {
                if (types.contains(mainSchemaTarget)) {
                    referenceKey = "#";
                } else {
                    definitionsNode.set(alias, (JsonNode)generationContext.getDefinition((ResolvedType)types.get(0)));
                    referenceKey = "#/definitions/" + alias;
                }
                referencingNodes.forEach(referenceNode -> referenceNode.put("$ref", referenceKey));
            }
            if (nullableReferences.isEmpty()) continue;
            ObjectNode definition = referenceInline ? generationContext.getDefinition((ResolvedType)types.get(0)) : this.config.createObjectNode().put("$ref", referenceKey);
            generationContext.makeNullable(definition);
            if (createDefinitionsForAll || nullableReferences.size() > 1) {
                String nullableAlias = alias + "-nullable";
                String nullableReferenceKey = "#/definitions/" + nullableAlias;
                definitionsNode.set(nullableAlias, (JsonNode)definition);
                nullableReferences.forEach(referenceNode -> referenceNode.put("$ref", nullableReferenceKey));
                continue;
            }
            nullableReferences.forEach(referenceNode -> referenceNode.setAll(definition));
        }
        return definitionsNode;
    }
}

