/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.impl;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.members.HierarchicType;
import com.fasterxml.classmate.members.ResolvedField;
import com.fasterxml.classmate.members.ResolvedMethod;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.github.victools.jsonschema.generator.CustomDefinition;
import com.github.victools.jsonschema.generator.CustomDefinitionProviderV2;
import com.github.victools.jsonschema.generator.FieldScope;
import com.github.victools.jsonschema.generator.MethodScope;
import com.github.victools.jsonschema.generator.SchemaGenerationContext;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.TypeContext;
import com.github.victools.jsonschema.generator.TypeScope;
import com.github.victools.jsonschema.generator.impl.AttributeCollector;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaGenerationContextImpl
implements SchemaGenerationContext {
    private static final Logger logger = LoggerFactory.getLogger(SchemaGenerationContextImpl.class);
    private final SchemaGeneratorConfig generatorConfig;
    private final TypeContext typeContext;
    private final Map<ResolvedType, ObjectNode> definitions = new HashMap<ResolvedType, ObjectNode>();
    private final Map<ResolvedType, List<ObjectNode>> references = new HashMap<ResolvedType, List<ObjectNode>>();
    private final Map<ResolvedType, List<ObjectNode>> nullableReferences = new HashMap<ResolvedType, List<ObjectNode>>();

    public SchemaGenerationContextImpl(SchemaGeneratorConfig generatorConfig, TypeContext typeContext) {
        this.generatorConfig = generatorConfig;
        this.typeContext = typeContext;
    }

    protected SchemaGeneratorConfig getGeneratorConfig() {
        return this.generatorConfig;
    }

    @Override
    public TypeContext getTypeContext() {
        return this.typeContext;
    }

    public void parseType(ResolvedType type) {
        this.traverseGenericType(type, null, false);
    }

    SchemaGenerationContextImpl putDefinition(ResolvedType javaType, ObjectNode definitionNode) {
        this.definitions.put(javaType, definitionNode);
        return this;
    }

    public boolean containsDefinition(ResolvedType javaType) {
        return this.definitions.containsKey(javaType);
    }

    public ObjectNode getDefinition(ResolvedType javaType) {
        return this.definitions.get(javaType);
    }

    public Set<ResolvedType> getDefinedTypes() {
        return Collections.unmodifiableSet(this.definitions.keySet());
    }

    SchemaGenerationContextImpl addReference(ResolvedType javaType, ObjectNode referencingNode, boolean isNullable) {
        Map<ResolvedType, List<ObjectNode>> targetMap = isNullable ? this.nullableReferences : this.references;
        List<ObjectNode> valueList = targetMap.get(javaType);
        if (valueList == null) {
            valueList = new ArrayList<ObjectNode>();
            targetMap.put(javaType, valueList);
        }
        valueList.add(referencingNode);
        return this;
    }

    public List<ObjectNode> getReferences(ResolvedType javaType) {
        return Collections.unmodifiableList(this.references.getOrDefault(javaType, Collections.emptyList()));
    }

    public List<ObjectNode> getNullableReferences(ResolvedType javaType) {
        return Collections.unmodifiableList(this.nullableReferences.getOrDefault(javaType, Collections.emptyList()));
    }

    @Override
    public ObjectNode createDefinition(ResolvedType targetType) {
        ObjectNode definition = this.generatorConfig.createObjectNode();
        this.traverseGenericType(targetType, definition, false, true, null);
        return definition;
    }

    @Override
    public ObjectNode createStandardDefinition(ResolvedType targetType, CustomDefinitionProviderV2 ignoredDefinitionProvider) {
        ObjectNode definition = this.generatorConfig.createObjectNode();
        this.traverseGenericType(targetType, definition, false, true, ignoredDefinitionProvider);
        return definition;
    }

    protected void traverseGenericType(ResolvedType targetType, ObjectNode targetNode, boolean isNullable) {
        this.traverseGenericType(targetType, targetNode, isNullable, false, null);
    }

    private void traverseGenericType(ResolvedType targetType, ObjectNode targetNode, boolean isNullable, boolean forceInlineDefinition, CustomDefinitionProviderV2 ignoredDefinitionProvider) {
        ObjectNode definition;
        if (!forceInlineDefinition && this.containsDefinition(targetType)) {
            logger.debug("adding reference to existing definition of {}", (Object)targetType);
            this.addReference(targetType, targetNode, isNullable);
            return;
        }
        CustomDefinition customDefinition = this.generatorConfig.getCustomDefinition(targetType, this, ignoredDefinitionProvider);
        if (customDefinition != null && customDefinition.isMeantToBeInline()) {
            if (targetNode == null) {
                logger.debug("storing configured custom inline type for {} as definition (since it is the main schema \"#\")", (Object)targetType);
                definition = customDefinition.getValue();
                this.putDefinition(targetType, definition);
            } else {
                logger.debug("directly applying configured custom inline type for {}", (Object)targetType);
                targetNode.setAll(customDefinition.getValue());
                definition = targetNode;
            }
            if (isNullable) {
                this.makeNullable(definition);
            }
        } else {
            boolean isContainerType = this.typeContext.isContainerType(targetType);
            if (forceInlineDefinition || isContainerType && targetNode != null && customDefinition == null) {
                definition = targetNode;
            } else {
                definition = this.generatorConfig.createObjectNode();
                this.putDefinition(targetType, definition);
                if (targetNode != null) {
                    this.addReference(targetType, targetNode, isNullable);
                }
            }
            if (customDefinition != null) {
                logger.debug("applying configured custom definition for {}", (Object)targetType);
                definition.setAll(customDefinition.getValue());
            } else if (isContainerType) {
                logger.debug("generating definition for {}", (Object)targetType);
                this.generateArrayDefinition(targetType, definition, isNullable);
            } else {
                logger.debug("generating definition for {}", (Object)targetType);
                this.generateObjectDefinition(targetType, definition);
            }
        }
        TypeScope scope = this.typeContext.createTypeScope(targetType);
        ObjectNode typeAttributes = AttributeCollector.collectTypeAttributes(scope, this);
        typeAttributes.setAll(definition);
        definition.setAll(typeAttributes);
        this.generatorConfig.getTypeAttributeOverrides().forEach(override -> override.overrideTypeAttributes(definition, scope, this.generatorConfig));
    }

    private void generateArrayDefinition(ResolvedType targetType, ObjectNode definition, boolean isNullable) {
        if (isNullable) {
            definition.set("type", (JsonNode)this.generatorConfig.createArrayNode().add("array").add("null"));
        } else {
            definition.put("type", "array");
        }
        ObjectNode arrayItemTypeRef = this.generatorConfig.createObjectNode();
        definition.set("items", (JsonNode)arrayItemTypeRef);
        ResolvedType itemType = this.typeContext.getContainerItemType(targetType);
        this.traverseGenericType(itemType, arrayItemTypeRef, false);
    }

    private void generateObjectDefinition(ResolvedType targetType, ObjectNode definition) {
        definition.put("type", "object");
        TreeMap<String, JsonNode> targetFields = new TreeMap<String, JsonNode>();
        TreeMap<String, JsonNode> targetMethods = new TreeMap<String, JsonNode>();
        HashSet<String> requiredProperties = new HashSet<String>();
        this.collectObjectProperties(targetType, targetFields, targetMethods, requiredProperties);
        if (!targetFields.isEmpty() || !targetMethods.isEmpty()) {
            ObjectNode propertiesNode = this.generatorConfig.createObjectNode();
            propertiesNode.setAll(targetFields);
            propertiesNode.setAll(targetMethods);
            definition.set("properties", (JsonNode)propertiesNode);
            if (!requiredProperties.isEmpty()) {
                ArrayNode requiredNode = this.generatorConfig.createArrayNode();
                requiredProperties.forEach(arg_0 -> ((ArrayNode)requiredNode).add(arg_0));
                definition.set("required", (JsonNode)requiredNode);
            }
        }
    }

    private void collectObjectProperties(ResolvedType targetType, Map<String, JsonNode> targetFields, Map<String, JsonNode> targetMethods, Set<String> requiredProperties) {
        logger.debug("collecting non-static fields and methods from {}", (Object)targetType);
        ResolvedTypeWithMembers targetTypeWithMembers = this.typeContext.resolveWithMembers(targetType);
        this.populateFields(targetTypeWithMembers, ResolvedTypeWithMembers::getMemberFields, targetFields, requiredProperties);
        this.populateMethods(targetTypeWithMembers, ResolvedTypeWithMembers::getMemberMethods, targetMethods, requiredProperties);
        boolean includeStaticFields = this.generatorConfig.shouldIncludeStaticFields();
        boolean includeStaticMethods = this.generatorConfig.shouldIncludeStaticMethods();
        if (includeStaticFields || includeStaticMethods) {
            for (HierarchicType singleHierarchy : targetTypeWithMembers.allTypesAndOverrides()) {
                ResolvedType hierachyType = singleHierarchy.getType();
                logger.debug("collecting static fields and methods from {}", (Object)hierachyType);
                if ((!includeStaticFields || hierachyType.getStaticFields().isEmpty()) && (!includeStaticMethods || hierachyType.getStaticMethods().isEmpty())) continue;
                ResolvedTypeWithMembers hierarchyTypeMembers = hierachyType == targetType ? targetTypeWithMembers : this.typeContext.resolveWithMembers(hierachyType);
                if (includeStaticFields) {
                    this.populateFields(hierarchyTypeMembers, ResolvedTypeWithMembers::getStaticFields, targetFields, requiredProperties);
                }
                if (!includeStaticMethods) continue;
                this.populateMethods(hierarchyTypeMembers, ResolvedTypeWithMembers::getStaticMethods, targetMethods, requiredProperties);
            }
        }
    }

    private void populateFields(ResolvedTypeWithMembers declaringTypeMembers, Function<ResolvedTypeWithMembers, ResolvedField[]> fieldLookup, Map<String, JsonNode> collectedFields, Set<String> requiredProperties) {
        Stream.of(fieldLookup.apply(declaringTypeMembers)).map(declaredField -> this.typeContext.createFieldScope((ResolvedField)declaredField, declaringTypeMembers)).filter(fieldScope -> !this.generatorConfig.shouldIgnore((FieldScope)fieldScope)).forEach(fieldScope -> this.populateField((FieldScope)fieldScope, collectedFields, requiredProperties));
    }

    private void populateMethods(ResolvedTypeWithMembers declaringTypeMembers, Function<ResolvedTypeWithMembers, ResolvedMethod[]> methodLookup, Map<String, JsonNode> collectedMethods, Set<String> requiredProperties) {
        Stream.of(methodLookup.apply(declaringTypeMembers)).map(declaredMethod -> this.typeContext.createMethodScope((ResolvedMethod)declaredMethod, declaringTypeMembers)).filter(methodScope -> !this.generatorConfig.shouldIgnore((MethodScope)methodScope)).forEach(methodScope -> this.populateMethod((MethodScope)methodScope, collectedMethods, requiredProperties));
    }

    private void populateField(FieldScope field, Map<String, JsonNode> collectedFields, Set<String> requiredProperties) {
        String propertyNameOverride = this.generatorConfig.resolvePropertyNameOverride(field);
        FieldScope fieldWithOverride = propertyNameOverride == null ? field : field.withOverriddenName(propertyNameOverride);
        String propertyName = fieldWithOverride.getSchemaPropertyName();
        if (this.generatorConfig.isRequired(field)) {
            requiredProperties.add(propertyName);
        }
        if (collectedFields.containsKey(propertyName)) {
            logger.debug("ignoring overridden {}.{}", (Object)fieldWithOverride.getDeclaringType(), (Object)fieldWithOverride.getDeclaredName());
            return;
        }
        ObjectNode subSchema = this.generatorConfig.createObjectNode();
        collectedFields.put(propertyName, (JsonNode)subSchema);
        ResolvedType typeOverride = this.generatorConfig.resolveTargetTypeOverride(fieldWithOverride);
        fieldWithOverride = typeOverride == null ? fieldWithOverride : fieldWithOverride.withOverriddenType(typeOverride);
        ObjectNode fieldAttributes = AttributeCollector.collectFieldAttributes(fieldWithOverride, this);
        boolean isNullable = !((Field)fieldWithOverride.getRawMember()).isEnumConstant() && this.generatorConfig.isNullable(fieldWithOverride);
        this.populateSchema(fieldWithOverride.getType(), subSchema, isNullable, fieldAttributes);
    }

    private void populateMethod(MethodScope method, Map<String, JsonNode> collectedMethods, Set<String> requiredProperties) {
        String propertyNameOverride = this.generatorConfig.resolvePropertyNameOverride(method);
        MethodScope methodWithOverride = propertyNameOverride == null ? method : method.withOverriddenName(propertyNameOverride);
        String propertyName = methodWithOverride.getSchemaPropertyName();
        if (this.generatorConfig.isRequired(method)) {
            requiredProperties.add(propertyName);
        }
        if (collectedMethods.containsKey(propertyName)) {
            logger.debug("ignoring overridden {}.{}", (Object)methodWithOverride.getDeclaringType(), (Object)methodWithOverride.getDeclaredName());
            return;
        }
        ResolvedType typeOverride = this.generatorConfig.resolveTargetTypeOverride(methodWithOverride);
        MethodScope methodScope = methodWithOverride = typeOverride == null ? methodWithOverride : methodWithOverride.withOverriddenType(typeOverride);
        if (methodWithOverride.isVoid()) {
            collectedMethods.put(propertyName, (JsonNode)BooleanNode.FALSE);
        } else {
            ObjectNode subSchema = this.generatorConfig.createObjectNode();
            collectedMethods.put(propertyName, (JsonNode)subSchema);
            ObjectNode methodAttributes = AttributeCollector.collectMethodAttributes(methodWithOverride, this);
            boolean isNullable = this.generatorConfig.isNullable(methodWithOverride);
            this.populateSchema(methodWithOverride.getType(), subSchema, isNullable, methodAttributes);
        }
    }

    private void populateSchema(ResolvedType javaType, ObjectNode targetNode, boolean isNullable, ObjectNode collectedAttributes) {
        CustomDefinition customDefinition = this.generatorConfig.getCustomDefinition(javaType, this, null);
        if (customDefinition != null && customDefinition.isMeantToBeInline()) {
            targetNode.setAll(customDefinition.getValue());
            if (collectedAttributes != null && collectedAttributes.size() > 0) {
                targetNode.setAll(collectedAttributes);
            }
            if (isNullable) {
                this.makeNullable(targetNode);
            }
        } else {
            ObjectNode referenceContainer;
            if (collectedAttributes == null || collectedAttributes.size() == 0) {
                referenceContainer = targetNode;
            } else if (customDefinition == null && this.typeContext.isContainerType(javaType)) {
                referenceContainer = targetNode;
                referenceContainer.setAll(collectedAttributes);
            } else {
                referenceContainer = this.generatorConfig.createObjectNode();
                targetNode.set("allOf", (JsonNode)this.generatorConfig.createArrayNode().add((JsonNode)referenceContainer).add((JsonNode)collectedAttributes));
            }
            try {
                this.traverseGenericType(javaType, referenceContainer, isNullable);
            }
            catch (UnsupportedOperationException ex) {
                logger.warn("Skipping type definition due to error", (Throwable)ex);
            }
        }
    }

    @Override
    public ObjectNode makeNullable(ObjectNode node) {
        if (node.has("$ref") || node.has("allOf") || node.has("anyOf") || node.has("oneOf")) {
            ObjectNode nullSchema = this.generatorConfig.createObjectNode().put("type", "null");
            ArrayNode oneOf = this.generatorConfig.createArrayNode().add((JsonNode)nullSchema).add(this.generatorConfig.createObjectNode().setAll(node));
            node.removeAll();
            node.set("oneOf", (JsonNode)oneOf);
        } else {
            JsonNode fixedJsonSchemaType = node.get("type");
            if (fixedJsonSchemaType instanceof ArrayNode) {
                ArrayNode arrayOfTypes = (ArrayNode)fixedJsonSchemaType;
                boolean alreadyContainsNull = false;
                for (JsonNode arrayEntry : arrayOfTypes) {
                    alreadyContainsNull = alreadyContainsNull || "null".equals(arrayEntry.textValue());
                }
                if (!alreadyContainsNull) {
                    arrayOfTypes.add("null");
                }
            } else if (fixedJsonSchemaType instanceof TextNode && !"null".equals(fixedJsonSchemaType.textValue())) {
                node.replace("type", (JsonNode)this.generatorConfig.createArrayNode().add(fixedJsonSchemaType).add("null"));
            }
        }
        return node;
    }
}

