/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaKeyword;
import com.github.victools.jsonschema.generator.SchemaVersion;
import com.github.victools.jsonschema.generator.TypeContext;
import com.github.victools.jsonschema.generator.impl.AttributeCollector;
import com.github.victools.jsonschema.generator.impl.DefinitionKey;
import com.github.victools.jsonschema.generator.impl.SchemaGenerationContextImpl;
import com.github.victools.jsonschema.generator.impl.TypeContextFactory;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class SchemaGenerator {
    private final SchemaGeneratorConfig config;
    private final TypeContext typeContext;

    public SchemaGenerator(SchemaGeneratorConfig config) {
        this(config, TypeContextFactory.createDefaultTypeContext());
    }

    public SchemaGenerator(SchemaGeneratorConfig config, TypeContext context) {
        this.config = config;
        this.typeContext = context;
    }

    public JsonNode generateSchema(Type mainTargetType, Type ... typeParameters) {
        ObjectNode definitionsNode;
        SchemaGenerationContextImpl generationContext = new SchemaGenerationContextImpl(this.config, this.typeContext);
        ResolvedType mainType = this.typeContext.resolve(mainTargetType, typeParameters);
        DefinitionKey mainKey = generationContext.parseType(mainType);
        ObjectNode jsonSchemaResult = this.config.createObjectNode();
        if (this.config.shouldIncludeSchemaVersionIndicator()) {
            jsonSchemaResult.put(this.config.getKeyword(SchemaKeyword.TAG_SCHEMA), this.config.getKeyword(SchemaKeyword.TAG_SCHEMA_VALUE));
        }
        if ((definitionsNode = this.buildDefinitionsAndResolveReferences(mainKey, generationContext)).size() > 0) {
            jsonSchemaResult.set(this.config.getKeyword(SchemaKeyword.TAG_DEFINITIONS), (JsonNode)definitionsNode);
        }
        ObjectNode mainSchemaNode = generationContext.getDefinition(mainKey);
        jsonSchemaResult.setAll(mainSchemaNode);
        if (this.config.shouldCleanupUnnecessaryAllOfElements()) {
            String allOfTagName = this.config.getKeyword(SchemaKeyword.TAG_ALLOF);
            this.finaliseSchemaParts(jsonSchemaResult, nodeToCheck -> this.mergeAllOfPartsIfPossible((JsonNode)nodeToCheck, allOfTagName));
        }
        String anyOfTagName = this.config.getKeyword(SchemaKeyword.TAG_ANYOF);
        this.finaliseSchemaParts(jsonSchemaResult, nodeToCheck -> this.reduceAnyOfWrappersIfPossible((JsonNode)nodeToCheck, anyOfTagName));
        return jsonSchemaResult;
    }

    private ObjectNode buildDefinitionsAndResolveReferences(DefinitionKey mainSchemaKey, SchemaGenerationContextImpl generationContext) {
        ObjectNode definitionsNode = this.config.createObjectNode();
        boolean createDefinitionsForAll = this.config.shouldCreateDefinitionsForAllObjects();
        boolean inlineAllSchemas = this.config.shouldInlineAllSchemas();
        for (Map.Entry<DefinitionKey, String> entry : this.getReferenceKeys(mainSchemaKey, generationContext).entrySet()) {
            String referenceKey;
            ObjectNode definition;
            boolean referenceInline;
            String definitionName = entry.getValue();
            DefinitionKey definitionKey = entry.getKey();
            List<ObjectNode> references = generationContext.getReferences(definitionKey);
            List<ObjectNode> nullableReferences = generationContext.getNullableReferences(definitionKey);
            boolean bl = referenceInline = inlineAllSchemas || (references.isEmpty() || !createDefinitionsForAll && references.size() + nullableReferences.size() < 2) && !mainSchemaKey.equals(definitionKey);
            if (referenceInline) {
                definition = generationContext.getDefinition(definitionKey);
                references.forEach(node -> AttributeCollector.mergeMissingAttributes(node, definition));
                referenceKey = null;
            } else {
                if (mainSchemaKey.equals(definitionKey)) {
                    referenceKey = this.config.getKeyword(SchemaKeyword.TAG_REF_MAIN);
                } else {
                    definitionsNode.set(definitionName, (JsonNode)generationContext.getDefinition(definitionKey));
                    referenceKey = this.config.getKeyword(SchemaKeyword.TAG_REF_PREFIX) + definitionName;
                }
                references.forEach(node -> node.put(this.config.getKeyword(SchemaKeyword.TAG_REF), referenceKey));
            }
            if (nullableReferences.isEmpty()) continue;
            definition = referenceInline ? generationContext.getDefinition(definitionKey) : this.config.createObjectNode().put(this.config.getKeyword(SchemaKeyword.TAG_REF), referenceKey);
            generationContext.makeNullable(definition);
            if (!inlineAllSchemas && (createDefinitionsForAll || nullableReferences.size() > 1)) {
                String nullableDefinitionName = definitionName + "-nullable";
                definitionsNode.set(nullableDefinitionName, (JsonNode)definition);
                nullableReferences.forEach(node -> node.put(this.config.getKeyword(SchemaKeyword.TAG_REF), this.config.getKeyword(SchemaKeyword.TAG_REF_PREFIX) + nullableDefinitionName));
                continue;
            }
            nullableReferences.forEach(node -> AttributeCollector.mergeMissingAttributes(node, definition));
        }
        return definitionsNode;
    }

    private Map<DefinitionKey, String> getReferenceKeys(DefinitionKey mainSchemaKey, SchemaGenerationContextImpl generationContext) {
        Map aliases = generationContext.getDefinedTypes().stream().collect(Collectors.groupingBy(this::getSchemaBaseDefinitionName, TreeMap::new, Collectors.toList()));
        LinkedHashMap<DefinitionKey, String> referenceKeys = new LinkedHashMap<DefinitionKey, String>();
        for (Map.Entry group : aliases.entrySet()) {
            List definitionKeys = (List)group.getValue();
            if (definitionKeys.size() == 1 || definitionKeys.size() == 2 && definitionKeys.contains(mainSchemaKey)) {
                definitionKeys.forEach(key -> {
                    String cfr_ignored_0 = (String)referenceKeys.put((DefinitionKey)key, (String)group.getKey());
                });
                continue;
            }
            AtomicInteger counter = new AtomicInteger(0);
            definitionKeys.forEach(key -> referenceKeys.put((DefinitionKey)key, (String)group.getKey() + "-" + counter.incrementAndGet()));
        }
        return referenceKeys;
    }

    private String getSchemaBaseDefinitionName(DefinitionKey key) {
        String schemaDefinitionName = this.typeContext.getSchemaDefinitionName(key.getType());
        String uriCompatibleName = schemaDefinitionName.replaceAll("[ ]+", "").replaceAll("\\[\\]", "*").replaceAll("<", "(").replaceAll(">", ")");
        return uriCompatibleName;
    }

    private Set<String> getTagNamesContainingSchema() {
        SchemaVersion schemaVersion = this.config.getSchemaVersion();
        return Stream.of(SchemaKeyword.TAG_ADDITIONAL_PROPERTIES, SchemaKeyword.TAG_ITEMS).map(keyword -> keyword.forVersion(schemaVersion)).collect(Collectors.toSet());
    }

    private Set<String> getTagNamesContainingSchemaArray() {
        SchemaVersion schemaVersion = this.config.getSchemaVersion();
        return Stream.of(SchemaKeyword.TAG_ALLOF, SchemaKeyword.TAG_ANYOF, SchemaKeyword.TAG_ONEOF).map(keyword -> keyword.forVersion(schemaVersion)).collect(Collectors.toSet());
    }

    private Set<String> getTagNamesContainingSchemaObject() {
        SchemaVersion schemaVersion = this.config.getSchemaVersion();
        return Stream.of(SchemaKeyword.TAG_PATTERN_PROPERTIES, SchemaKeyword.TAG_PROPERTIES).map(keyword -> keyword.forVersion(schemaVersion)).collect(Collectors.toSet());
    }

    private void finaliseSchemaParts(ObjectNode schemaNode, Consumer<ObjectNode> performCleanUpOnSingleSchemaNode) {
        ArrayList<ObjectNode> nextNodesToCheck = new ArrayList<ObjectNode>();
        Consumer<JsonNode> addNodeToCheck = node -> {
            if (node instanceof ObjectNode) {
                nextNodesToCheck.add((ObjectNode)node);
            }
        };
        nextNodesToCheck.add(schemaNode);
        Optional.ofNullable(schemaNode.get(this.config.getKeyword(SchemaKeyword.TAG_DEFINITIONS))).filter(definitions -> definitions instanceof ObjectNode).ifPresent(definitions -> ((ObjectNode)definitions).forEach(addNodeToCheck));
        Set<String> tagsWithSchemas = this.getTagNamesContainingSchema();
        Set<String> tagsWithSchemaArrays = this.getTagNamesContainingSchemaArray();
        Set<String> tagsWithSchemaObjects = this.getTagNamesContainingSchemaObject();
        do {
            ArrayList currentNodesToCheck = new ArrayList(nextNodesToCheck);
            nextNodesToCheck.clear();
            for (ObjectNode nodeToCheck : currentNodesToCheck) {
                performCleanUpOnSingleSchemaNode.accept(nodeToCheck);
                tagsWithSchemas.stream().map(arg_0 -> ((ObjectNode)nodeToCheck).get(arg_0)).forEach(addNodeToCheck);
                tagsWithSchemaArrays.stream().map(arg_0 -> ((ObjectNode)nodeToCheck).get(arg_0)).filter(possibleArrayNode -> possibleArrayNode instanceof ArrayNode).forEach(arrayNode -> arrayNode.forEach(addNodeToCheck));
                tagsWithSchemaObjects.stream().map(arg_0 -> ((ObjectNode)nodeToCheck).get(arg_0)).filter(possibleObjectNode -> possibleObjectNode instanceof ObjectNode).forEach(objectNode -> objectNode.forEach(addNodeToCheck));
            }
        } while (!nextNodesToCheck.isEmpty());
    }

    private void mergeAllOfPartsIfPossible(JsonNode schemaNode, String allOfTagName) {
        if (!(schemaNode instanceof ObjectNode)) {
            return;
        }
        JsonNode allOfTag = schemaNode.get(allOfTagName);
        if (!(allOfTag instanceof ArrayNode)) {
            return;
        }
        allOfTag.forEach(part -> this.mergeAllOfPartsIfPossible((JsonNode)part, allOfTagName));
        ArrayList allOfElements = new ArrayList();
        allOfTag.forEach(allOfElements::add);
        if (allOfElements.stream().anyMatch(part -> !(part instanceof ObjectNode) && !part.asBoolean())) {
            return;
        }
        List<ObjectNode> parts = allOfElements.stream().filter(part -> part instanceof ObjectNode).map(part -> (ObjectNode)part).collect(Collectors.toList());
        Map fieldsFromAllParts = Stream.concat(Stream.of(schemaNode), parts.stream()).flatMap(part -> StreamSupport.stream(((Iterable)() -> part.fields()).spliterator(), false)).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
        if ((this.config.getSchemaVersion() == SchemaVersion.DRAFT_6 || this.config.getSchemaVersion() == SchemaVersion.DRAFT_7) && fieldsFromAllParts.containsKey(this.config.getKeyword(SchemaKeyword.TAG_REF))) {
            return;
        }
        String ifTagName = this.config.getKeyword(SchemaKeyword.TAG_IF);
        for (Map.Entry fieldEntries : fieldsFromAllParts.entrySet()) {
            int offset;
            if (fieldEntries.getValue().size() == 1) continue;
            if (ifTagName.equals(fieldEntries.getKey())) {
                return;
            }
            if (!allOfTagName.equals(fieldEntries.getKey())) {
                offset = 0;
            } else {
                if (fieldEntries.getValue().size() == 2) continue;
                offset = 1;
            }
            if (fieldEntries.getValue().stream().skip(offset + 1).allMatch(arg_0 -> ((JsonNode)((JsonNode)fieldEntries.getValue().get(offset))).equals(arg_0))) continue;
            return;
        }
        ObjectNode schemaObjectNode = (ObjectNode)schemaNode;
        schemaObjectNode.remove(allOfTagName);
        parts.forEach(arg_0 -> ((ObjectNode)schemaObjectNode).setAll(arg_0));
    }

    private void reduceAnyOfWrappersIfPossible(JsonNode schemaNode, String anyOfTagName) {
        if (!(schemaNode instanceof ObjectNode)) {
            return;
        }
        JsonNode anyOfTag = schemaNode.get(anyOfTagName);
        if (!(anyOfTag instanceof ArrayNode)) {
            return;
        }
        anyOfTag.forEach(part -> this.reduceAnyOfWrappersIfPossible((JsonNode)part, anyOfTagName));
        for (int index = anyOfTag.size() - 1; index > -1; --index) {
            JsonNode nestedAnyOf;
            JsonNode arrayEntry = anyOfTag.get(index);
            if (!(arrayEntry instanceof ObjectNode) || arrayEntry.size() != 1 || !((nestedAnyOf = arrayEntry.get(anyOfTagName)) instanceof ArrayNode)) continue;
            ((ArrayNode)anyOfTag).remove(index);
            for (int nestedEntryIndex = nestedAnyOf.size() - 1; nestedEntryIndex > -1; --nestedEntryIndex) {
                ((ArrayNode)anyOfTag).insert(index, nestedAnyOf.get(nestedEntryIndex));
            }
        }
    }
}

