/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.victools.jsonschema.generator.CustomDefinitionProviderV2;
import com.github.victools.jsonschema.generator.FieldScope;
import com.github.victools.jsonschema.generator.MethodScope;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.Option;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigPart;
import com.github.victools.jsonschema.generator.SchemaGeneratorTypeConfigPart;
import com.github.victools.jsonschema.generator.TypeAttributeOverride;
import com.github.victools.jsonschema.generator.TypeScope;
import com.github.victools.jsonschema.generator.impl.SchemaGeneratorConfigImpl;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class SchemaGeneratorConfigBuilder {
    private final ObjectMapper objectMapper;
    private final OptionPreset preset;
    private final Map<Option, Boolean> options = new HashMap<Option, Boolean>();
    private final SchemaGeneratorTypeConfigPart<TypeScope> typesInGeneralConfigPart = new SchemaGeneratorTypeConfigPart();
    private final SchemaGeneratorConfigPart<FieldScope> fieldConfigPart = new SchemaGeneratorConfigPart();
    private final SchemaGeneratorConfigPart<MethodScope> methodConfigPart = new SchemaGeneratorConfigPart();
    private final List<CustomDefinitionProviderV2> customDefinitions = new ArrayList<CustomDefinitionProviderV2>();
    private final List<TypeAttributeOverride> typeAttributeOverrides = new ArrayList<TypeAttributeOverride>();

    public SchemaGeneratorConfigBuilder(ObjectMapper objectMapper) {
        this(objectMapper, OptionPreset.FULL_DOCUMENTATION);
    }

    public SchemaGeneratorConfigBuilder(ObjectMapper objectMapper, OptionPreset preset) {
        this.objectMapper = objectMapper;
        this.preset = preset;
    }

    public SchemaGeneratorConfig build() {
        Map<Option, Boolean> completeSetOfOptions = EnumSet.allOf(Option.class).stream().collect(Collectors.toMap(option -> option, option -> this.options.getOrDefault(option, this.preset.isOptionEnabledByDefault((Option)((Object)option)))));
        Set enabledOptions = completeSetOfOptions.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toSet());
        Predicate<Option> isValid = configuredOption -> enabledOptions.stream().noneMatch(enabledOne -> enabledOne.isOverriding((Option)((Object)configuredOption)));
        completeSetOfOptions.entrySet().stream().filter(setting -> (Boolean)setting.getValue() == false || isValid.test((Option)((Object)((Object)setting.getKey())))).map(setting -> ((Option)((Object)((Object)setting.getKey()))).getModule((Boolean)setting.getValue())).filter(Objects::nonNull).forEach(this::with);
        return new SchemaGeneratorConfigImpl(this.objectMapper, completeSetOfOptions, this.typesInGeneralConfigPart, this.fieldConfigPart, this.methodConfigPart, this.customDefinitions, this.typeAttributeOverrides);
    }

    public SchemaGeneratorTypeConfigPart<TypeScope> forTypesInGeneral() {
        return this.typesInGeneralConfigPart;
    }

    public SchemaGeneratorConfigPart<FieldScope> forFields() {
        return this.fieldConfigPart;
    }

    public SchemaGeneratorConfigPart<MethodScope> forMethods() {
        return this.methodConfigPart;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public Boolean getSetting(Option setting) {
        return this.options.get((Object)setting);
    }

    public SchemaGeneratorConfigBuilder with(Module module) {
        module.applyToConfigBuilder(this);
        return this;
    }

    public SchemaGeneratorConfigBuilder with(CustomDefinitionProviderV2 definitionProvider) {
        this.customDefinitions.add(definitionProvider);
        return this;
    }

    public SchemaGeneratorConfigBuilder with(TypeAttributeOverride override) {
        this.typeAttributeOverrides.add(override);
        return this;
    }

    public SchemaGeneratorConfigBuilder with(Option setting, Option ... moreSettings) {
        return this.setOptionEnabled(setting, moreSettings, true);
    }

    public SchemaGeneratorConfigBuilder without(Option setting, Option ... moreSettings) {
        return this.setOptionEnabled(setting, moreSettings, false);
    }

    private SchemaGeneratorConfigBuilder setOptionEnabled(Option setting, Option[] moreSettings, boolean enabled) {
        this.options.put(setting, enabled);
        if (moreSettings != null) {
            for (Option additionalSetting : moreSettings) {
                this.options.put(additionalSetting, enabled);
            }
        }
        return this;
    }
}

