/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.FieldScope;
import com.github.victools.jsonschema.generator.MethodScope;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeCollector {
    private static final Logger logger = LoggerFactory.getLogger(AttributeCollector.class);
    private final ObjectMapper objectMapper;

    public AttributeCollector(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public static ObjectNode collectFieldAttributes(FieldScope field, SchemaGeneratorConfig config) {
        ObjectNode node = config.createObjectNode();
        AttributeCollector collector = new AttributeCollector(config.getObjectMapper());
        collector.setTitle(node, config.resolveTitle(field));
        collector.setDescription(node, config.resolveDescription(field));
        collector.setEnum(node, config.resolveEnum(field));
        collector.setStringMinLength(node, config.resolveStringMinLength(field));
        collector.setStringMaxLength(node, config.resolveStringMaxLength(field));
        collector.setStringFormat(node, config.resolveStringFormat(field));
        collector.setNumberInclusiveMinimum(node, config.resolveNumberInclusiveMinimum(field));
        collector.setNumberExclusiveMinimum(node, config.resolveNumberExclusiveMinimum(field));
        collector.setNumberInclusiveMaximum(node, config.resolveNumberInclusiveMaximum(field));
        collector.setNumberExclusiveMaximum(node, config.resolveNumberExclusiveMaximum(field));
        collector.setNumberMultipleOf(node, config.resolveNumberMultipleOf(field));
        collector.setArrayMinItems(node, config.resolveArrayMinItems(field));
        collector.setArrayMaxItems(node, config.resolveArrayMaxItems(field));
        collector.setArrayUniqueItems(node, config.resolveArrayUniqueItems(field));
        config.getFieldAttributeOverrides().forEach(override -> override.overrideInstanceAttributes(node, field));
        return node;
    }

    public static ObjectNode collectMethodAttributes(MethodScope method, SchemaGeneratorConfig config) {
        ObjectNode node = config.createObjectNode();
        AttributeCollector collector = new AttributeCollector(config.getObjectMapper());
        collector.setTitle(node, config.resolveTitle(method));
        collector.setDescription(node, config.resolveDescription(method));
        collector.setEnum(node, config.resolveEnum(method));
        collector.setStringMinLength(node, config.resolveStringMinLength(method));
        collector.setStringMaxLength(node, config.resolveStringMaxLength(method));
        collector.setStringFormat(node, config.resolveStringFormat(method));
        collector.setNumberInclusiveMinimum(node, config.resolveNumberInclusiveMinimum(method));
        collector.setNumberExclusiveMinimum(node, config.resolveNumberExclusiveMinimum(method));
        collector.setNumberInclusiveMaximum(node, config.resolveNumberInclusiveMaximum(method));
        collector.setNumberExclusiveMaximum(node, config.resolveNumberExclusiveMaximum(method));
        collector.setNumberMultipleOf(node, config.resolveNumberMultipleOf(method));
        collector.setArrayMinItems(node, config.resolveArrayMinItems(method));
        collector.setArrayMaxItems(node, config.resolveArrayMaxItems(method));
        collector.setArrayUniqueItems(node, config.resolveArrayUniqueItems(method));
        config.getMethodAttributeOverrides().forEach(override -> override.overrideInstanceAttributes(node, method));
        return node;
    }

    public AttributeCollector setTitle(ObjectNode node, String title) {
        if (title != null) {
            node.put("title", title);
        }
        return this;
    }

    public AttributeCollector setDescription(ObjectNode node, String description) {
        if (description != null) {
            node.put("description", description);
        }
        return this;
    }

    public AttributeCollector setEnum(ObjectNode node, Collection<?> enumValues) {
        if (enumValues != null) {
            List<String> valuesAsString = enumValues.stream().filter(this::isSupportedEnumValue).map(this::convertObjectToString).collect(Collectors.toList());
            if (valuesAsString.size() == 1) {
                String singleValue = (String)valuesAsString.get(0);
                node.putPOJO("const", (Object)singleValue);
            } else if (!valuesAsString.isEmpty()) {
                ArrayNode array = node.arrayNode();
                valuesAsString.forEach(arg_0 -> ((ArrayNode)array).addPOJO(arg_0));
                node.set("enum", (JsonNode)array);
            }
        }
        return this;
    }

    private boolean isSupportedEnumValue(Object target) {
        if (target == null) {
            return true;
        }
        Class<?> targetType = target.getClass();
        return targetType.isPrimitive() || Number.class.isAssignableFrom(targetType) || CharSequence.class.isAssignableFrom(targetType) || Enum.class.isAssignableFrom(targetType);
    }

    private String convertObjectToString(Object target) {
        try {
            return this.objectMapper.writeValueAsString(target);
        }
        catch (JsonProcessingException ex) {
            logger.warn("Failed to convert value to string via ObjectMapper: {}", target, (Object)ex);
            return target == null ? null : '\"' + target.toString() + '\"';
        }
    }

    public AttributeCollector setStringMinLength(ObjectNode node, Integer minLength) {
        if (minLength != null) {
            node.put("minLength", minLength);
        }
        return this;
    }

    public AttributeCollector setStringMaxLength(ObjectNode node, Integer maxLength) {
        if (maxLength != null) {
            node.put("maxLength", maxLength);
        }
        return this;
    }

    public AttributeCollector setStringFormat(ObjectNode node, String format) {
        if (format != null) {
            node.put("format", format);
        }
        return this;
    }

    public AttributeCollector setNumberInclusiveMinimum(ObjectNode node, BigDecimal inclusiveMinimum) {
        if (inclusiveMinimum != null) {
            node.put("minimum", inclusiveMinimum);
        }
        return this;
    }

    public AttributeCollector setNumberExclusiveMinimum(ObjectNode node, BigDecimal exclusiveMinimum) {
        if (exclusiveMinimum != null) {
            node.put("exclusiveMinimum", exclusiveMinimum);
        }
        return this;
    }

    public AttributeCollector setNumberInclusiveMaximum(ObjectNode node, BigDecimal inclusiveMaximum) {
        if (inclusiveMaximum != null) {
            node.put("maximum", inclusiveMaximum);
        }
        return this;
    }

    public AttributeCollector setNumberExclusiveMaximum(ObjectNode node, BigDecimal exclusiveMaximum) {
        if (exclusiveMaximum != null) {
            node.put("exclusiveMaximum", exclusiveMaximum);
        }
        return this;
    }

    public AttributeCollector setNumberMultipleOf(ObjectNode node, BigDecimal multipleOf) {
        if (multipleOf != null) {
            node.put("multipleOf", multipleOf);
        }
        return this;
    }

    public AttributeCollector setArrayMinItems(ObjectNode node, Integer minItemCount) {
        if (minItemCount != null) {
            node.put("minItems", minItemCount);
        }
        return this;
    }

    public AttributeCollector setArrayMaxItems(ObjectNode node, Integer maxItemCount) {
        if (maxItemCount != null) {
            node.put("maxItems", maxItemCount);
        }
        return this;
    }

    public AttributeCollector setArrayUniqueItems(ObjectNode node, Boolean uniqueItems) {
        if (uniqueItems != null) {
            node.put("uniqueItems", uniqueItems);
        }
        return this;
    }
}

