/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.impl;

import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.members.ResolvedField;
import com.fasterxml.classmate.members.ResolvedMember;
import com.fasterxml.classmate.members.ResolvedMethod;
import java.lang.reflect.Method;
import java.util.stream.Stream;

public final class ReflectionGetterUtils {
    private ReflectionGetterUtils() {
    }

    public static ResolvedMethod findGetterForField(ResolvedField field, ResolvedTypeWithMembers declaringType) {
        String capitalisedFieldName = field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
        String getterName1 = "get" + capitalisedFieldName;
        String getterName2 = "is" + capitalisedFieldName;
        ResolvedMethod[] methods = declaringType.getMemberMethods();
        ResolvedMethod getter = Stream.of(methods).filter(method -> ((Method)method.getRawMember()).getParameterCount() == 0).filter(method -> method.getName().equals(getterName1) || method.getName().equals(getterName2)).filter(ResolvedMember::isPublic).findFirst().orElse(null);
        return getter;
    }

    public static boolean hasGetter(ResolvedField field, ResolvedTypeWithMembers declaringType) {
        return ReflectionGetterUtils.findGetterForField(field, declaringType) != null;
    }

    public static ResolvedField findFieldForGetter(ResolvedMethod method, ResolvedTypeWithMembers declaringType) {
        if (method.getReturnType() == null || !method.isPublic()) {
            return null;
        }
        String methodName = method.getName();
        String fieldName = methodName.startsWith("get") && methodName.length() > 3 && Character.isUpperCase(methodName.charAt(3)) ? methodName.substring(3, 4).toLowerCase() + methodName.substring(4) : (methodName.startsWith("is") && methodName.length() > 2 && Character.isUpperCase(methodName.charAt(2)) ? methodName.substring(2, 3).toLowerCase() + methodName.substring(3) : null);
        if (fieldName == null) {
            return null;
        }
        return Stream.of(declaringType.getMemberFields()).filter(memberField -> memberField.getName().equals(fieldName)).findFirst().orElse(null);
    }

    public static boolean isGetter(ResolvedMethod method, ResolvedTypeWithMembers declaringType) {
        return ReflectionGetterUtils.findFieldForGetter(method, declaringType) != null;
    }
}

