/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.impl;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.members.ResolvedField;
import com.fasterxml.classmate.members.ResolvedMethod;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeCollector {
    private static final Logger logger = LoggerFactory.getLogger(AttributeCollector.class);
    private final ObjectMapper objectMapper;

    public AttributeCollector(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public static ObjectNode collectFieldAttributes(ResolvedField field, ResolvedType type, ResolvedTypeWithMembers declaringType, SchemaGeneratorConfig config) {
        ObjectNode node = config.createObjectNode();
        AttributeCollector collector = new AttributeCollector(config.getObjectMapper());
        collector.setTitle(node, config.resolveTitle(field, type, declaringType));
        collector.setDescription(node, config.resolveDescription(field, type, declaringType));
        collector.setEnum(node, config.resolveEnum(field, type, declaringType));
        collector.setStringMinLength(node, config.resolveStringMinLength(field, type, declaringType));
        collector.setStringMaxLength(node, config.resolveStringMaxLength(field, type, declaringType));
        collector.setStringFormat(node, config.resolveStringFormat(field, type, declaringType));
        collector.setNumberInclusiveMinimum(node, config.resolveNumberInclusiveMinimum(field, type, declaringType));
        collector.setNumberExclusiveMinimum(node, config.resolveNumberExclusiveMinimum(field, type, declaringType));
        collector.setNumberInclusiveMaximum(node, config.resolveNumberInclusiveMaximum(field, type, declaringType));
        collector.setNumberExclusiveMaximum(node, config.resolveNumberExclusiveMaximum(field, type, declaringType));
        collector.setNumberMultipleOf(node, config.resolveNumberMultipleOf(field, type, declaringType));
        collector.setArrayMinItems(node, config.resolveArrayMinItems(field, type, declaringType));
        collector.setArrayMaxItems(node, config.resolveArrayMaxItems(field, type, declaringType));
        collector.setArrayUniqueItems(node, config.resolveArrayUniqueItems(field, type, declaringType));
        config.getFieldAttributeOverrides().forEach(override -> override.overrideInstanceAttributes(node, field, type, declaringType, config));
        return node;
    }

    public static ObjectNode collectMethodAttributes(ResolvedMethod method, ResolvedType returnType, ResolvedTypeWithMembers declaringType, SchemaGeneratorConfig config) {
        ObjectNode node = config.createObjectNode();
        AttributeCollector collector = new AttributeCollector(config.getObjectMapper());
        collector.setTitle(node, config.resolveTitle(method, returnType, declaringType));
        collector.setDescription(node, config.resolveDescription(method, returnType, declaringType));
        collector.setEnum(node, config.resolveEnum(method, returnType, declaringType));
        collector.setStringMinLength(node, config.resolveStringMinLength(method, returnType, declaringType));
        collector.setStringMaxLength(node, config.resolveStringMaxLength(method, returnType, declaringType));
        collector.setStringFormat(node, config.resolveStringFormat(method, returnType, declaringType));
        collector.setNumberInclusiveMinimum(node, config.resolveNumberInclusiveMinimum(method, returnType, declaringType));
        collector.setNumberExclusiveMinimum(node, config.resolveNumberExclusiveMinimum(method, returnType, declaringType));
        collector.setNumberInclusiveMaximum(node, config.resolveNumberInclusiveMaximum(method, returnType, declaringType));
        collector.setNumberExclusiveMaximum(node, config.resolveNumberExclusiveMaximum(method, returnType, declaringType));
        collector.setNumberMultipleOf(node, config.resolveNumberMultipleOf(method, returnType, declaringType));
        collector.setArrayMinItems(node, config.resolveArrayMinItems(method, returnType, declaringType));
        collector.setArrayMaxItems(node, config.resolveArrayMaxItems(method, returnType, declaringType));
        collector.setArrayUniqueItems(node, config.resolveArrayUniqueItems(method, returnType, declaringType));
        config.getMethodAttributeOverrides().forEach(override -> override.overrideInstanceAttributes(node, method, returnType, declaringType, config));
        return node;
    }

    public AttributeCollector setTitle(ObjectNode node, String title) {
        if (title != null) {
            node.put("title", title);
        }
        return this;
    }

    public AttributeCollector setDescription(ObjectNode node, String description) {
        if (description != null) {
            node.put("description", description);
        }
        return this;
    }

    public AttributeCollector setEnum(ObjectNode node, Collection<?> enumValues) {
        if (enumValues != null) {
            List<String> valuesAsString = enumValues.stream().filter(this::isSupportedEnumValue).map(this::convertObjectToString).collect(Collectors.toList());
            if (valuesAsString.size() == 1) {
                String singleValue = (String)valuesAsString.get(0);
                node.putPOJO("const", (Object)singleValue);
            } else if (!valuesAsString.isEmpty()) {
                ArrayNode array = node.arrayNode();
                valuesAsString.forEach(arg_0 -> ((ArrayNode)array).addPOJO(arg_0));
                node.set("enum", (JsonNode)array);
            }
        }
        return this;
    }

    private boolean isSupportedEnumValue(Object target) {
        if (target == null) {
            return true;
        }
        Class<?> targetType = target.getClass();
        return targetType.isPrimitive() || Number.class.isAssignableFrom(targetType) || CharSequence.class.isAssignableFrom(targetType) || Enum.class.isAssignableFrom(targetType);
    }

    private String convertObjectToString(Object target) {
        try {
            return this.objectMapper.writeValueAsString(target);
        }
        catch (JsonProcessingException ex) {
            logger.warn("Failed to convert value to string via ObjectMapper: {}", target, (Object)ex);
            return target == null ? null : '\"' + target.toString() + '\"';
        }
    }

    public AttributeCollector setStringMinLength(ObjectNode node, Integer minLength) {
        if (minLength != null) {
            node.put("minLength", minLength);
        }
        return this;
    }

    public AttributeCollector setStringMaxLength(ObjectNode node, Integer maxLength) {
        if (maxLength != null) {
            node.put("maxLength", maxLength);
        }
        return this;
    }

    public AttributeCollector setStringFormat(ObjectNode node, String format) {
        if (format != null) {
            node.put("format", format);
        }
        return this;
    }

    public AttributeCollector setNumberInclusiveMinimum(ObjectNode node, BigDecimal inclusiveMinimum) {
        if (inclusiveMinimum != null) {
            node.put("minimum", inclusiveMinimum);
        }
        return this;
    }

    public AttributeCollector setNumberExclusiveMinimum(ObjectNode node, BigDecimal exclusiveMinimum) {
        if (exclusiveMinimum != null) {
            node.put("exclusiveMinimum", exclusiveMinimum);
        }
        return this;
    }

    public AttributeCollector setNumberInclusiveMaximum(ObjectNode node, BigDecimal inclusiveMaximum) {
        if (inclusiveMaximum != null) {
            node.put("maximum", inclusiveMaximum);
        }
        return this;
    }

    public AttributeCollector setNumberExclusiveMaximum(ObjectNode node, BigDecimal exclusiveMaximum) {
        if (exclusiveMaximum != null) {
            node.put("exclusiveMaximum", exclusiveMaximum);
        }
        return this;
    }

    public AttributeCollector setNumberMultipleOf(ObjectNode node, BigDecimal multipleOf) {
        if (multipleOf != null) {
            node.put("multipleOf", multipleOf);
        }
        return this;
    }

    public AttributeCollector setArrayMinItems(ObjectNode node, Integer minItemCount) {
        if (minItemCount != null) {
            node.put("minItems", minItemCount);
        }
        return this;
    }

    public AttributeCollector setArrayMaxItems(ObjectNode node, Integer maxItemCount) {
        if (maxItemCount != null) {
            node.put("maxItems", maxItemCount);
        }
        return this;
    }

    public AttributeCollector setArrayUniqueItems(ObjectNode node, Boolean uniqueItems) {
        if (uniqueItems != null) {
            node.put("uniqueItems", uniqueItems);
        }
        return this;
    }
}

