/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.impl;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.JavaType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SchemaGenerationContext {
    private final Map<JavaType, ObjectNode> definitions = new HashMap<JavaType, ObjectNode>();
    private final Map<JavaType, List<ObjectNode>> references = new HashMap<JavaType, List<ObjectNode>>();
    private final Map<JavaType, List<ObjectNode>> nullableReferences = new HashMap<JavaType, List<ObjectNode>>();

    public SchemaGenerationContext putDefinition(JavaType javaType, ObjectNode definitionNode) {
        this.definitions.put(javaType, definitionNode);
        return this;
    }

    public boolean containsDefinition(JavaType javaType) {
        return this.definitions.containsKey(javaType);
    }

    public ObjectNode getDefinition(JavaType javaType) {
        return this.definitions.get(javaType);
    }

    public Set<JavaType> getDefinedTypes() {
        return Collections.unmodifiableSet(this.definitions.keySet());
    }

    public SchemaGenerationContext addReference(JavaType javaType, ObjectNode referencingNode, boolean isNullable) {
        Map<JavaType, List<ObjectNode>> targetMap = isNullable ? this.nullableReferences : this.references;
        List<ObjectNode> valueList = targetMap.get(javaType);
        if (valueList == null) {
            valueList = new ArrayList<ObjectNode>();
            targetMap.put(javaType, valueList);
        }
        valueList.add(referencingNode);
        return this;
    }

    public List<ObjectNode> getReferences(JavaType javaType) {
        return Collections.unmodifiableList(this.references.getOrDefault(javaType, Collections.emptyList()));
    }

    public List<ObjectNode> getNullableReferences(JavaType javaType) {
        return Collections.unmodifiableList(this.nullableReferences.getOrDefault(javaType, Collections.emptyList()));
    }
}

