/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.impl.module;

import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.impl.ReflectionGetterUtils;
import java.lang.reflect.Method;
import java.util.function.Predicate;

public class MethodExclusionModule
implements Module {
    private final Predicate<Method> shouldExcludeMethodsMatching;

    public static MethodExclusionModule forStaticMethods() {
        return new MethodExclusionModule(MethodExclusionModule::isMethodStatic);
    }

    public static MethodExclusionModule forVoidMethods() {
        return new MethodExclusionModule(MethodExclusionModule::isMethodVoid);
    }

    public static MethodExclusionModule forGetterMethods() {
        return new MethodExclusionModule(ReflectionGetterUtils::isGetter);
    }

    public static MethodExclusionModule forNonStaticNonVoidNonGetterMethods() {
        return new MethodExclusionModule(method -> !MethodExclusionModule.isMethodStatic(method) && !MethodExclusionModule.isMethodVoid(method) && !ReflectionGetterUtils.isGetter(method));
    }

    private static boolean isMethodStatic(Method method) {
        return (method.getModifiers() & 8) == 8;
    }

    private static boolean isMethodVoid(Method method) {
        Class<?> returnType = method.getReturnType();
        return returnType == Void.TYPE || returnType == Void.class;
    }

    public MethodExclusionModule(Predicate<Method> shouldExcludeMethodsMatching) {
        this.shouldExcludeMethodsMatching = shouldExcludeMethodsMatching;
    }

    @Override
    public void applyToConfigBuilder(SchemaGeneratorConfigBuilder builder) {
        builder.forMethods().withIgnoreCheck(this.shouldExcludeMethodsMatching);
    }
}

