/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.impl.module;

import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.impl.ReflectionGetterUtils;
import java.lang.reflect.Field;
import java.util.function.Predicate;

public class FieldExclusionModule
implements Module {
    private final Predicate<Field> shouldExcludeFieldsMatching;

    public static FieldExclusionModule forPublicStaticFields() {
        return new FieldExclusionModule(field -> FieldExclusionModule.isFieldPublic(field) && FieldExclusionModule.isFieldStatic(field));
    }

    public static FieldExclusionModule forPublicNonStaticFields() {
        return new FieldExclusionModule(field -> FieldExclusionModule.isFieldPublic(field) && !FieldExclusionModule.isFieldStatic(field));
    }

    public static FieldExclusionModule forNonPublicStaticFields() {
        return new FieldExclusionModule(field -> !FieldExclusionModule.isFieldPublic(field) && FieldExclusionModule.isFieldStatic(field));
    }

    public static FieldExclusionModule forNonPublicNonStaticFieldsWithGetter() {
        return new FieldExclusionModule(field -> !FieldExclusionModule.isFieldPublic(field) && !FieldExclusionModule.isFieldStatic(field) && ReflectionGetterUtils.hasGetter(field));
    }

    public static FieldExclusionModule forNonPublicNonStaticFieldsWithoutGetter() {
        return new FieldExclusionModule(field -> !FieldExclusionModule.isFieldPublic(field) && !FieldExclusionModule.isFieldStatic(field) && !ReflectionGetterUtils.hasGetter(field));
    }

    public static FieldExclusionModule forTransientFields() {
        return new FieldExclusionModule(FieldExclusionModule::isFieldTransient);
    }

    private static boolean isFieldPublic(Field field) {
        return (field.getModifiers() & 1) == 1;
    }

    private static boolean isFieldStatic(Field field) {
        return (field.getModifiers() & 8) == 8;
    }

    private static boolean isFieldTransient(Field field) {
        return (field.getModifiers() & 0x80) == 128;
    }

    public FieldExclusionModule(Predicate<Field> shouldExcludeFieldsMatching) {
        this.shouldExcludeFieldsMatching = shouldExcludeFieldsMatching;
    }

    @Override
    public void applyToConfigBuilder(SchemaGeneratorConfigBuilder builder) {
        builder.forFields().withIgnoreCheck(this.shouldExcludeFieldsMatching);
    }
}

