/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.watchverticallive.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.base.IBaseViewImpl;
import com.vhall.appui.baselib.utils.AsyncManager;
import com.vhall.appui.baselib.utils.DensityUtils;
import com.vhall.document.DocumentView;
import com.vhall.player.stream.play.impl.VHVideoPlayerView;
import com.vhall.vhallrtc.client.Stream;
import com.vhall.vhallrtc.client.VHRenderView;
import org.webrtc.RendererCommon;

public class WatchDocWidget
extends IBaseViewImpl
implements View.OnClickListener {
    private ImageView back_live;
    private FrameLayout main_screen_view;
    private RelativeLayout doc_container;
    private BackListener mListener;
    private DocumentView documentView;
    private View mChildView;

    public WatchDocWidget(@NonNull Context context) {
        super(context);
    }

    public WatchDocWidget(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public WatchDocWidget(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void onClick(View v) {
        if (v == this.back_live && this.mListener != null) {
            this.mListener.onBack();
        }
    }

    public void setListener(BackListener listener) {
        this.mListener = listener;
    }

    @Override
    public void init() {
        super.init();
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.watch_vertical_live_watch_doc_layout, (ViewGroup)this);
        this.back_live = (ImageView)this.findViewById(R.id.back_live);
        this.main_screen_view = (FrameLayout)this.findViewById(R.id.main_screen_view);
        this.doc_container = (RelativeLayout)this.findViewById(R.id.doc_container);
        this.back_live.setOnClickListener(this::onClick);
    }

    public void setData(DocumentView view) {
        this.documentView = view;
        this.doc_container.removeAllViews();
        this.doc_container.addView((View)view, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(DensityUtils.getScreenWidth(), DensityUtils.getScreenWidth() / 16 * 9));
    }

    public void show(final View view) {
        this.main_screen_view.removeAllViews();
        this.main_screen_view.setVisibility(8);
        view.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(DensityUtils.dpToPxInt(120.0f), DensityUtils.dpToPxInt(68.0f)));
        this.main_screen_view.addView(view);
        this.mChildView = view;
        AsyncManager.postDelay(new Runnable(){

            @Override
            public void run() {
                WatchDocWidget.this.main_screen_view.setVisibility(0);
                WatchDocWidget.this.doc_container.setVisibility(0);
                if (view instanceof VHVideoPlayerView) {
                    ((VHVideoPlayerView)view).setDrawMode(1);
                    view.setVisibility(0);
                }
            }
        }, 10L);
        this.setVisibility(0);
    }

    public void show(Stream mainStream) {
        if (mainStream == null) {
            return;
        }
        this.main_screen_view.removeAllViews();
        VHRenderView render_view = new VHRenderView(this.getContext());
        render_view.getHolder().setFormat(-2);
        render_view.setZOrderMediaOverlay(true);
        render_view.init(null, null);
        render_view.setScalingType(RendererCommon.ScalingType.SCALE_ASPECT_FILL);
        mainStream.removeAllRenderView();
        mainStream.addRenderView(render_view);
        this.main_screen_view.addView((View)render_view);
        this.setVisibility(0);
    }

    public View getChildView() {
        if (this.mChildView == null) {
            return null;
        }
        if (this.mChildView.getParent() != null) {
            ((ViewGroup)this.mChildView.getParent()).removeView(this.mChildView);
        }
        return this.mChildView;
    }

    public void hide() {
        this.setVisibility(8);
    }

    public void destroyed() {
        this.doc_container.removeAllViews();
        this.setVisibility(8);
    }

    public void onTrick() {
    }

    public static interface BackListener {
        public void onBack();
    }
}

