/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.watchverticallive.widget;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.CountDownTimer;
import android.util.Log;
import android.view.View;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.vhall.appui.baselib.R;

public class CountDownPopu
extends PopupWindow {
    Context context;
    TextView mSecondsView;
    CountDown mCount;
    View root;

    public CountDownPopu(Context context) {
        super(context);
        this.context = context;
        this.setWidth(-2);
        this.setHeight(-2);
        ColorDrawable dw = new ColorDrawable(0);
        this.setBackgroundDrawable((Drawable)dw);
        this.setOutsideTouchable(false);
        this.setFocusable(false);
        this.root = View.inflate((Context)context, (int)R.layout.count_down_layout, null);
        this.root.measure(0, 0);
        this.setContentView(this.root);
        this.mSecondsView = (TextView)this.root.findViewById(R.id.tv_seconds);
        this.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
            }
        });
    }

    public void dismiss() {
        super.dismiss();
        if (this.mCount != null) {
            this.mCount.cancel();
        }
    }

    public void showAtLocation(View parent, int gravity, int x, int y) {
        super.showAtLocation(parent, gravity, x, y);
        this.startCountDown();
    }

    public void showAsDropDown(View anchor, int xoff, int yoff, int gravity) {
        super.showAsDropDown(anchor, xoff, yoff, gravity);
        this.startCountDown();
    }

    public void showAsDropDown(View anchor, int xoff, int yoff) {
        super.showAsDropDown(anchor, xoff, yoff);
        this.startCountDown();
    }

    private void startCountDown() {
        if (this.mCount == null) {
            this.mCount = new CountDown(30000L, 1000L);
        }
        this.mCount.start();
    }

    public void show(View v) {
        int y = v.getHeight() + this.getContentView().getMeasuredHeight();
        Log.i((String)"popu", (String)("v:" + v.getHeight() + " root:" + this.getContentView().getMeasuredHeight()));
        this.showAsDropDown(v, -18, -y - 10);
    }

    class CountDown
    extends CountDownTimer {
        public CountDown(long millisInFuture, long countDownInterval) {
            super(millisInFuture, countDownInterval);
        }

        public void onTick(long millisUntilFinished) {
            CountDownPopu.this.mSecondsView.setText((CharSequence)(String.valueOf(millisUntilFinished / 1000L) + "s"));
        }

        public void onFinish() {
            CountDownPopu.this.dismiss();
        }
    }
}

